/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class BooleanImageHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;
    boolean[][] retval = new boolean[1][1];

    public BooleanImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireImageValueChanged(boolean[][] newValue, long timeStamp) {
        this.propChanges.fireBooleanImageEvent((IBooleanImage)((Object)this.attribute), newValue, timeStamp);
    }

    void insert(DeviceAttribute da, boolean[][] boolImage) {
        boolean[] flatBool = this.flatten(boolImage);
        da.insert(flatBool, boolImage[0].length, boolImage.length);
    }

    boolean[] flatten(boolean[][] src) {
        int lineSize = src[0].length;
        int size = src.length * src[0].length;
        boolean[] dst = new boolean[size];
        for (int i = 0; i < src.length; ++i) {
            System.arraycopy(src[i], 0, dst, i * lineSize, lineSize);
        }
        return dst;
    }

    boolean[][] getBooleanImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        boolean[] tmp = deviceAttribute.extractBooleanArray();
        int ydim = this.attribute.getYDimension();
        int xdim = this.attribute.getXDimension();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new boolean[ydim][xdim];
        }
        int k = 0;
        for (int y = 0; y < ydim; ++y) {
            for (int x = 0; x < xdim; ++x) {
                this.retval[y][x] = tmp[k++];
            }
        }
        return this.retval;
    }

    void addBooleanImageListener(IBooleanImageListener l) {
        this.propChanges.addBooleanImageListener(l);
    }

    void removeBooleanImageListener(IBooleanImageListener l) {
        this.propChanges.removeBooleanImageListener(l);
    }

    public String getVersion() {
        return "$Id$";
    }
}

