/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanImage
extends AAttribute
implements IBooleanImage {
    BooleanImageHelper imageHelper = new BooleanImageHelper(this);
    boolean[][] imageValue = null;

    @Override
    public boolean[][] getValue() {
        return this.imageValue;
    }

    @Override
    public void setValue(boolean[][] bImage) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.checkDimensions(bImage);
            this.imageHelper.insert(da, bImage);
            this.writeAtt(da);
            this.imageHelper.fireImageValueChanged(bImage, System.currentTimeMillis());
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
        catch (Exception ex) {
            this.setAttError("Couldn't set value", new ATKException(ex));
        }
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        ++this.refreshCount;
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getBooleanImageValue(att);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed e) {
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            System.out.println("BooleanImage.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("BooleanImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(attValue);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            System.out.println("BooleanImage.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanImage.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.imageValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean[][] newValue) {
        this.imageHelper.fireImageValueChanged(newValue, this.timeStamp);
    }

    @Override
    public void addBooleanImageListener(IBooleanImageListener l) {
        this.imageHelper.addBooleanImageListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeBooleanImageListener(IBooleanImageListener l) {
        this.imageHelper.removeBooleanImageListener(l);
        this.removeStateListener(l);
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "BooleanImage.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "BooleanImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("BooleanImage.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(da);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("BooleanImage.periodic.extractBoolean() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("BooleanImage.periodic.extractBoolean()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "BooleanImage.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "BooleanImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("BooleanImage.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanImage.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(da);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("BooleanImage.change.extractBoolean() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("BooleanImage.change.extractBoolean()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return true;
    }
}

