/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoAttConfigListener;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoAttConfigEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.PropertyStorage;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.util.AtkTimer;
import java.io.IOException;
import java.util.Map;

public abstract class AAttribute
implements IAttribute,
ITangoPeriodicListener,
ITangoChangeListener,
ITangoAttConfigListener {
    static final String RAW_IMAGE_FORMAT = "RawImage";
    protected transient AttributeInfoEx config;
    protected PropertyStorage propertyStorage = null;
    protected EventSupport propChanges;
    protected Device device;
    protected DeviceAttribute attribute;
    protected String error;
    protected String nameSansDevice;
    protected String name;
    protected transient AtkTimer timer;
    protected String state = "OK";
    protected long timeStamp;
    @Deprecated
    protected boolean skippingRefresh = false;
    protected String alias;
    protected long refreshCount = 0L;
    protected long changeCount = 0L;
    protected long periodicCount = 0L;
    public long lastRefreshCount = 0L;
    public long lastChangeCount = 0L;
    public long lastPeriodicCount = 0L;
    public String statRefresh;
    public String statChange;
    public String statPeriodic;
    protected long configCount = 0L;
    protected int eventType = 0;
    protected DevFailed eventError = null;
    private boolean hasEvents = false;
    protected boolean attPropertiesLoaded = false;
    private boolean shouldDoEvent = true;
    private static String VERSION = "$Id$";

    public String getVersion() {
        return VERSION;
    }

    protected AAttribute() {
        if (this.propChanges == null) {
            this.propChanges = new EventSupport();
        }
    }

    protected void serializeInit() throws IOException {
        System.out.print(this.name + "...");
        this.timer = AtkTimer.getInstance();
        try {
            AttributeInfoEx config = this.getDevice().getAttributeInfo(this.name);
            this.init(this.device, this.nameSansDevice, config, true);
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected void init(Device d, String name, AttributeInfoEx config, boolean doEvent) {
        AAttribute aAttribute = this;
        this.timer = aAttribute.timer.getInstance();
        this.propertyStorage = new PropertyStorage();
        this.setDevice(d);
        this.nameSansDevice = name;
        this.setName(this.device + "/" + name);
        this.shouldDoEvent = doEvent;
        this.setConfiguration(config);
        if (doEvent && d.doesEvent()) {
            this.subscribeAttributeEvent();
        }
        if (!this.hasEvents) {
            try {
                this.readFirstValueFromNetwork();
            }
            catch (DevFailed e) {
                this.readAttError("Couldn't read from network", new ConnectionException(e));
            }
        }
    }

    protected void connectionlessInit(Device d, String name, boolean doEvent) {
        AAttribute aAttribute = this;
        this.timer = aAttribute.timer.getInstance();
        this.propertyStorage = new PropertyStorage();
        this.setDevice(d);
        this.nameSansDevice = name;
        this.setName(this.device + "/" + name);
        this.shouldDoEvent = doEvent;
    }

    protected void reconnectAtt() {
        this.getDevice().reconnect();
        if (!this.getDevice().isConnected()) {
            return;
        }
        try {
            AttributeInfoEx configAtt = this.getDevice().getAttributeInfo(this.getNameSansDevice());
            this.setConfiguration(configAtt);
        }
        catch (DevFailed ex) {
            return;
        }
        if (this.shouldDoEvent && this.getDevice().doesEvent()) {
            this.subscribeAttributeEvent();
        }
    }

    private void subscribeAttributeEvent() {
        TangoEventsAdapter evtAdapt = null;
        String[] filters = new String[]{};
        try {
            evtAdapt = new TangoEventsAdapter((DeviceProxy)this.getDevice());
        }
        catch (DevFailed dfe) {
            this.hasEvents = false;
            return;
        }
        long t0 = System.currentTimeMillis();
        try {
            evtAdapt.addTangoChangeListener((ITangoChangeListener)this, this.nameSansDevice, filters);
            this.hasEvents = true;
            this.trace(2, "AAttribute.subscribeAttributeChangeEvent(" + this.name + ") ok:", t0);
        }
        catch (DevFailed dfe) {
            if (dfe.errors[0].reason.equals("API_EventPropertiesNotSet")) {
                try {
                    evtAdapt.addTangoPeriodicListener((ITangoPeriodicListener)this, this.nameSansDevice, filters);
                    this.hasEvents = true;
                    this.trace(2, "AAttribute.subscribeAttributePeriodicEvent(" + this.name + ") ok:", t0);
                }
                catch (DevFailed dfe2) {
                    this.hasEvents = false;
                    this.eventError = dfe2;
                    this.trace(1, "AATtribute.subscribeAttributePeriodicEvent(" + this.name + ") failed:", t0);
                }
            }
            this.hasEvents = false;
            this.eventError = dfe;
            this.trace(1, "AAttribute.subscribeAttributeEvent(" + this.name + ") failed:", t0);
        }
        try {
            evtAdapt.addTangoAttConfigListener((ITangoAttConfigListener)this, this.nameSansDevice, filters);
            this.trace(2, "AAttribute.subscribeAttributeConfigEvent(" + this.name + ") ok:", t0);
            return;
        }
        catch (DevFailed dfe) {
            this.trace(1, "AAttribute.subscribeAttributeConfigEvent(" + this.name + ") failed:", t0);
            return;
        }
    }

    public void attConfig(TangoAttConfigEvent evt) {
        ++this.configCount;
        AttributeInfoEx attInfo = null;
        long t0 = System.currentTimeMillis();
        this.trace(2048, "AAttribute.attConfig method called for " + this.getName(), t0);
        try {
            attInfo = evt.getValue();
            this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") success", t0);
            if (attInfo != null) {
                this.updateConfiguration(attInfo);
            }
        }
        catch (DevFailed dfe) {
            this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
            } else {
                this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, got other DevFailed error", t0);
            }
        }
        catch (Exception e) {
            this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("AAttribute.attConfigEvt.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("AAttribute.attConfigEvt.getValue()------------------------------------------------");
        }
    }

    @Override
    public boolean hasEvents() {
        return this.hasEvents;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getChangeCount() {
        return this.changeCount;
    }

    public int getEventType() {
        return this.eventType;
    }

    public long getPeriodicCount() {
        return this.periodicCount;
    }

    public long getConfigCount() {
        return this.configCount;
    }

    public String getSubscriptionError() {
        if (!this.getDevice().doesEvent()) {
            return "ATK does not manage event for the parent device " + this.getDevice().getName() + " (IDL<3)";
        }
        if (this.eventError != null) {
            return this.eventError.errors[0].desc;
        }
        return "";
    }

    public DeviceAttribute getDeviceAttribute() {
        return this.attribute;
    }

    public String toString() {
        return this.name;
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    @Override
    public String getType() {
        StringBuffer retval = new StringBuffer();
        int dataType = this.config.data_type;
        switch (dataType) {
            case 2: {
                retval.append("Short");
                break;
            }
            case 6: {
                retval.append("UShort");
                break;
            }
            case 19: {
                retval.append("State");
                break;
            }
            case 1: {
                retval.append("Boolean");
                break;
            }
            case 5: {
                retval.append("Double");
                break;
            }
            case 3: {
                retval.append("Long");
                break;
            }
            case 7: {
                retval.append("ULong");
                break;
            }
            case 23: {
                retval.append("Long64");
                break;
            }
            case 24: {
                retval.append("ULong64");
                break;
            }
            case 8: {
                retval.append("String");
                break;
            }
            case 22: {
                retval.append("UChar");
                break;
            }
            case 4: {
                retval.append("Float");
                break;
            }
            case 29: {
                retval.append("Enum");
            }
        }
        AttrDataFormat format = this.config.data_format;
        switch (format.value()) {
            case 0: {
                retval.append("Scalar");
                break;
            }
            case 1: {
                retval.append("Spectrum");
                break;
            }
            case 2: {
                retval.append("Image");
            }
        }
        return retval.toString();
    }

    public int getTangoDataType() {
        int dataType = this.config.data_type;
        return dataType;
    }

    @Override
    public void storeConfig() {
        Property property;
        if (this.getProperty("unit").isSpecified()) {
            this.config.unit = this.getProperty("unit").getStringValue();
        }
        if (this.getProperty("standard_unit").isSpecified()) {
            this.config.standard_unit = this.getProperty("standard_unit").getStringValue();
        }
        if (this.getProperty("format").isSpecified()) {
            this.config.format = this.getProperty("format").getStringValue();
        }
        if (this.getProperty("data_type").isSpecified()) {
            this.config.data_type = this.getProperty("data_type").getIntValue();
        }
        if (this.getProperty("max_dim_x").isSpecified()) {
            this.config.max_dim_x = this.getProperty("max_dim_x").getIntValue();
        }
        if (this.getProperty("max_dim_y").isSpecified()) {
            this.config.max_dim_y = this.getProperty("max_dim_y").getIntValue();
        }
        if (this.getProperty("description").isSpecified()) {
            this.config.description = this.getProperty("description").getStringValue();
        }
        if (this.getProperty("label").isSpecified()) {
            this.config.label = this.getProperty("label").getStringValue();
        }
        if (this.getProperty("display_unit").isSpecified()) {
            this.config.display_unit = this.getProperty("display_unit").getStringValue();
        }
        if ((property = this.getProperty("min_value")) != null && property.isSpecified()) {
            this.config.min_value = property.getStringValue();
        }
        if ((property = this.getProperty("max_value")) != null && property.isSpecified()) {
            this.config.max_value = property.getStringValue();
        }
        if ((property = this.getProperty("min_alarm")) != null && property.isSpecified()) {
            if (this.config.alarms != null) {
                this.config.alarms.min_alarm = property.getStringValue();
            } else {
                this.config.min_alarm = property.getStringValue();
            }
        }
        if ((property = this.getProperty("max_alarm")) != null && property.isSpecified()) {
            if (this.config.alarms != null) {
                this.config.alarms.max_alarm = property.getStringValue();
            } else {
                this.config.max_alarm = property.getStringValue();
            }
        }
        if ((property = this.getProperty("min_warning")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.min_warning = property.getStringValue();
        }
        if ((property = this.getProperty("max_warning")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.max_warning = property.getStringValue();
        }
        if ((property = this.getProperty("delta_t")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.delta_t = property.getStringValue();
        }
        if ((property = this.getProperty("delta_val")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.delta_val = property.getStringValue();
        }
        if (this.config.data_type == 29 && (property = this.getProperty("enum_label")) != null && property.isSpecified() && property instanceof StringArrayProperty) {
            StringArrayProperty saProp = (StringArrayProperty)property;
            this.config.enum_label = saProp.getStringArrayValue();
        }
        try {
            this.device.storeInfo(this.config);
            this.setConfiguration(this.device.getAttributeInfo(this.getName()));
            this.getState();
        }
        catch (DevFailed d) {
            this.setAttError("Couldn't store config", new AttributeSetException(d));
        }
    }

    @Override
    public String getFormat() {
        return this.getProperty("format").getStringValue();
    }

    @Override
    public void addErrorListener(IErrorListener l) {
        this.propChanges.addErrorListener(l);
    }

    @Override
    public void removeErrorListener(IErrorListener l) {
        this.propChanges.removeErrorListener(l);
    }

    @Override
    public void addSetErrorListener(ISetErrorListener l) {
        this.propChanges.addSetErrorListener(l);
    }

    @Override
    public void removeSetErrorListener(ISetErrorListener l) {
        this.propChanges.removeSetErrorListener(l);
    }

    @Override
    public void addStateListener(IAttributeStateListener l) {
        this.propChanges.addAttributeStateListener(l);
    }

    @Override
    public void removeStateListener(IAttributeStateListener l) {
        this.propChanges.removeAttributeStateListener(l);
    }

    public void setDevice(Device d) {
        this.device = d;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    protected void readAttError(String s, Throwable t) {
        this.propChanges.fireReadErrorEvent(this, t);
    }

    protected void setAttError(String s, Throwable t) {
        this.propChanges.fireSetErrorEvent(this, t);
    }

    @Override
    public String getUnit() {
        return this.getProperty("unit").getStringValue();
    }

    @Override
    public String getStandardUnit() {
        return this.getProperty("standard_unit").getStringValue();
    }

    @Override
    public double getStandardUnitFactor() {
        double factor = (Double)this.getProperty("standard_unit").getValue();
        return factor;
    }

    @Override
    public String getDisplayUnit() {
        return this.getProperty("display_unit").getStringValue();
    }

    @Override
    public double getDisplayUnitFactor() {
        double factor = (Double)this.getProperty("display_unit").getValue();
        return factor;
    }

    @Override
    public String getLabel() {
        return this.getProperty("label").getStringValue();
    }

    @Override
    public void setLabel(String label) {
        this.propertyStorage.setProperty((IEntity)this, "label", label, true);
    }

    @Override
    public void setName(String s) {
        this.name = s;
        this.propertyStorage.setProperty((IEntity)this, "name", s, false);
    }

    @Override
    public void setDescription(String desc) {
        this.propertyStorage.setProperty((IEntity)this, "description", desc, true);
    }

    @Override
    public String getDescription() {
        return this.propertyStorage.getProperty("description").getStringValue();
    }

    public int getLevel() {
        return this.propertyStorage.getProperty("level").getIntValue();
    }

    @Override
    public boolean isOperator() {
        Property prop = this.getProperty("level");
        if (prop != null && prop instanceof DisplayLevelProperty) {
            DisplayLevelProperty dlp = (DisplayLevelProperty)prop;
            return dlp.isOperator();
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        Property prop = this.getProperty("level");
        if (prop != null && prop instanceof DisplayLevelProperty) {
            DisplayLevelProperty dlp = (DisplayLevelProperty)prop;
            return dlp.isExpert();
        }
        return false;
    }

    private void updateConfiguration(AttributeInfoEx newConfig) {
        this.setConfiguration(newConfig);
        this.propertyStorage.refreshProperties();
    }

    protected void setConfiguration(AttributeInfoEx c) {
        double std_unit;
        double disp_unit;
        this.timer.startTimer(Thread.currentThread());
        this.config = c;
        this.propertyStorage.setProperty((IEntity)this, "unit", this.config.unit, false);
        this.propertyStorage.setProperty((IAttribute)this, "data_format", this.config.data_format, false);
        this.propertyStorage.setProperty((IEntity)this, "format", this.config.format, true);
        this.propertyStorage.setProperty((IEntity)this, "data_type", new Integer(this.config.data_type), false);
        this.propertyStorage.setProperty((IEntity)this, "description", this.config.description, true);
        this.propertyStorage.setProperty((IEntity)this, "label", this.config.label, true);
        this.propertyStorage.setProperty((IAttribute)this, "writable", this.config.writable, false);
        this.propertyStorage.setProperty((IEntity)this, "writable_attr_name", this.config.writable_attr_name, false);
        if ("None".equals(this.config.writable_attr_name)) {
            this.propertyStorage.getProperty("writable_attr_name").setSpecified(false);
        }
        try {
            disp_unit = Double.parseDouble(this.config.display_unit);
            if (disp_unit <= 0.0) {
                disp_unit = 1.0;
            }
        }
        catch (NumberFormatException nfe) {
            disp_unit = 1.0;
        }
        this.propertyStorage.setProperty((IEntity)this, "display_unit", new Double(disp_unit), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_x", new Integer(this.config.max_dim_x), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_y", new Integer(this.config.max_dim_y), false);
        this.propertyStorage.setProperty((IEntity)this, "level", this.config.level, false);
        try {
            std_unit = Double.parseDouble(this.config.standard_unit);
            if (std_unit <= 0.0) {
                std_unit = 1.0;
            }
        }
        catch (NumberFormatException nfe) {
            std_unit = 1.0;
        }
        this.setProperty("standard_unit", new Double(std_unit), false);
        if (this.config.data_type == 29) {
            this.propertyStorage.setProperty((IEntity)this, "enum_label", this.config.enum_label, true);
        }
        this.timer.endTimer(Thread.currentThread());
    }

    public static String[] getPropertyNames() {
        String[] names = new String[]{"name", "unit", "data_format", "data_type", "description", "label", "writable", "writable_attr_name", "display_unit", "max_dim_x", "max_dim_y", "level", "standard_unit", "min_value", "max_value", "min_alarm", "max_alarm", "min_warning", "max_warning", "delta_t", "delta_val"};
        return names;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameSansDevice() {
        return this.nameSansDevice;
    }

    @Override
    public boolean isWritable() {
        AttrWriteType wt = (AttrWriteType)this.getProperty("writable").getValue();
        return wt == AttrWriteType.WRITE || wt == AttrWriteType.READ_WRITE;
    }

    private final void readFirstValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
    }

    protected final DeviceAttribute readValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    protected final DeviceAttribute readDeviceValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttributeFromDevice(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    public abstract void dispatch(DeviceAttribute var1);

    public abstract void dispatchError(DevFailed var1);

    protected void setState() throws DevFailed {
        AttrQuality q = this.attribute.getQuality();
        if (0 == q.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == q.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == q.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == q.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == q.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    protected void setState(DeviceAttribute da) throws DevFailed {
        AttrQuality q = da.getQuality();
        if (0 == q.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == q.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == q.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == q.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == q.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    public DeviceAttribute getAttribute() {
        return this.attribute;
    }

    protected void setState(String s) {
        this.state = s;
        this.propChanges.fireAttributeStateEvent(this, s);
    }

    @Override
    public String getState() {
        try {
            this.readValueFromNetwork();
        }
        catch (DevFailed e) {
            this.readAttError("Couldn't read from network", new ConnectionException(e));
            return "UNKNOWN";
        }
        catch (Exception e) {
            this.readAttError("Couldn't read from network", e);
            return "UNKNOWN";
        }
        return this.state;
    }

    protected void writeAtt(DeviceAttribute da) throws DevFailed {
        this.device.writeAttribute(da);
    }

    @Override
    public int getMaxXDimension() {
        return this.getProperty("max_dim_x").getIntValue();
    }

    @Override
    public int getMaxYDimension() {
        return this.getProperty("max_dim_y").getIntValue();
    }

    @Override
    public int getYDimension() {
        try {
            return this.attribute.getDimY();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getHeight() {
        return this.getYDimension();
    }

    @Override
    public int getXDimension() {
        try {
            return this.attribute.getDimX();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getWidth() {
        return this.getYDimension();
    }

    @Override
    @Deprecated
    public void setSkippingRefresh(boolean b) {
        this.skippingRefresh = b;
    }

    @Override
    @Deprecated
    public boolean isSkippingRefresh() {
        return this.skippingRefresh;
    }

    protected void checkDimensions(Object[][] o) {
        if (o.length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (o[0].length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(double[][] o) {
        if (o[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (o.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(boolean[][] o) {
        if (o[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (o.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static String[] flatten(String[][] src) {
        int size = src.length * src[0].length;
        String[] dst = new String[size];
        for (int i = 0; i < src.length; ++i) {
            System.arraycopy(src[i], 0, dst, i * src.length, src.length);
        }
        return dst;
    }

    protected final DeviceDataHistory[] readAttHistoryFromNetwork() throws DevFailed {
        return this.device.attribute_history(this.nameSansDevice);
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }

    public void freeInternalData() {
        this.attribute = null;
    }

    @Override
    public Property getProperty(String name) {
        return this.propertyStorage.getProperty(name);
    }

    @Override
    public Map getPropertyMap() {
        return this.propertyStorage.getPropertyMap();
    }

    @Override
    public void setProperty(String name, Number value) {
        this.propertyStorage.setProperty(name, value);
    }

    @Override
    public void setProperty(String name, Number value, boolean editable) {
        this.propertyStorage.setProperty((IEntity)this, name, value, editable);
    }

    public PropertyStorage getPropertyStorage() {
        return this.propertyStorage;
    }

    public void setPropertyStorage(PropertyStorage propertyStorage) {
        this.propertyStorage = propertyStorage;
    }

    @Override
    public boolean areAttPropertiesLoaded() {
        return this.attPropertiesLoaded;
    }

    @Override
    public void loadAttProperties() {
        this.attPropertiesLoaded = true;
    }

    @Override
    public String getDeviceName() {
        if (this.device != null) {
            return this.device.getName();
        }
        return this.getDeviceNameFromAtt(this.getName());
    }

    private String getDeviceNameFromAtt(String attName) {
        int idx = attName.lastIndexOf(47);
        if (idx != -1) {
            return attName.substring(0, idx);
        }
        return attName;
    }
}

