/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.ATKEvent;
import fr.esrf.tangoatk.core.INumberImage;

public class NumberImageEvent
extends ATKEvent {
    double[][] value;
    double[][] devValue;

    public NumberImageEvent(INumberImage source, double[][] value, long timeStamp) {
        super(source, timeStamp);
        this.setValue(value);
        this.devValue = new double[1][1];
    }

    public double[][] getValue() {
        return this.value;
    }

    public double[][] getDeviceValue() {
        double dispUnitFactor = 1.0;
        if (this.source != null && this.source instanceof INumberImage) {
            dispUnitFactor = ((INumberImage)this.source).getDisplayUnitFactor();
        }
        if (dispUnitFactor <= 0.0) {
            dispUnitFactor = 1.0;
        }
        if (dispUnitFactor == 1.0) {
            return this.value;
        }
        int ydim = this.value.length;
        int xdim = this.value[0].length;
        if (ydim != this.devValue.length || this.devValue.length == 0 || xdim != this.devValue[0].length) {
            this.devValue = new double[ydim][xdim];
        }
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.devValue[i][j] = this.value[i][j] / dispUnitFactor;
            }
        }
        return this.devValue;
    }

    public double[][] getStandardValue() {
        double stdUnitFactor = 1.0;
        double[][] devVal = this.getDeviceValue();
        if (this.source != null && this.source instanceof INumberImage) {
            stdUnitFactor = ((INumberImage)this.source).getStandardUnitFactor();
        }
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return devVal;
        }
        int ydim = devVal.length;
        int xdim = devVal[0].length;
        double[][] stdVal = new double[ydim][xdim];
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                stdVal[i][j] = devVal[i][j] * stdUnitFactor;
            }
        }
        return stdVal;
    }

    public void setValue(double[][] value) {
        this.value = value;
    }

    public void setSource(INumberImage source) {
        this.source = source;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

