/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanImageEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.BooleanSpectrumEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EndGroupExecutionEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.EnumSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.ICommandGroup;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.IEndGroupExecutionListener;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IEnumSpectrum;
import fr.esrf.tangoatk.core.IEnumSpectrumListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.RawImageEvent;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.StringImageEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.List;

public class EventSupport
implements Serializable {
    protected AtkEventListenerList listenerList = new AtkEventListenerList();
    protected NumberScalarEvent numberScalarEvent = null;
    protected StringScalarEvent stringScalarEvent = null;
    protected StringSpectrumEvent stringSpectrumEvent;
    protected NumberSpectrumEvent numberSpectrumEvent = null;
    protected NumberImageEvent numberImageEvent = null;
    protected StateEvent stateEvent = null;
    protected AttributeStateEvent attributeStateEvent = null;
    protected StatusEvent statusEvent = null;
    protected ResultEvent resultEvent = null;
    protected ErrorEvent readErrorEvent = null;
    protected ErrorEvent setErrorEvent = null;
    protected BooleanImageEvent boolImageEvent = null;
    protected BooleanSpectrumEvent boolSpectrumEvent = null;
    protected BooleanScalarEvent boolScalarEvent = null;
    protected DevStateScalarEvent devStateScalarEvent = null;
    protected EndGroupExecutionEvent endGroupExecEvent = null;
    protected RawImageEvent rawImageEvent = null;
    protected EnumScalarEvent enumScalarEvent = null;
    protected EnumSpectrumEvent enumSpectrumEvent = null;
    protected StringImageEvent strImageEvent = null;
    protected DevStateSpectrumEvent devStateSpectrumEvent = null;

    public int getListenerCount() {
        return this.listenerList.getListenerCount();
    }

    public String getListenerInfo() {
        String ret = "";
        Object[] lst = this.listenerList.getListenerList();
        for (int i = 1; i < lst.length; i += 2) {
            String cName;
            WeakReference weakRef;
            String lName = lst[i - 1].toString();
            int p = lName.lastIndexOf(46);
            if (p >= 0) {
                lName = lName.substring(p + 1);
            }
            if ((weakRef = (WeakReference)lst[i]).get() == null) {
                cName = "LostWeakRef";
            } else {
                cName = ((EventListener)weakRef.get()).getClass().toString();
                if (cName.startsWith("class ")) {
                    cName = cName.substring(6);
                }
            }
            ret = ret + cName + " [@" + Integer.toHexString(lst[i].hashCode()) + "] is " + lName + "\n";
        }
        if (ret.length() == 0) {
            return "No listener registered.";
        }
        return ret;
    }

    public synchronized void addImageListener(IImageListener l) {
        this.listenerList.add(IImageListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeImageListener(IImageListener l) {
        this.listenerList.remove(IImageListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void addSpectrumListener(ISpectrumListener l) {
        this.listenerList.add(ISpectrumListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeSpectrumListener(ISpectrumListener l) {
        this.listenerList.remove(ISpectrumListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void addStringScalarListener(IStringScalarListener l) {
        this.listenerList.add(IStringScalarListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeStringScalarListener(IStringScalarListener l) {
        this.listenerList.remove(IStringScalarListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void addStringSpectrumListener(IStringSpectrumListener l) {
        this.listenerList.add(IStringSpectrumListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeStringSpectrumListener(IStringSpectrumListener l) {
        this.listenerList.remove(IStringSpectrumListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void addResultListener(IResultListener l) {
        this.listenerList.add(IResultListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeResultListener(IResultListener l) {
        this.listenerList.remove(IResultListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void addStateListener(IStateListener l) {
        this.listenerList.add(IStateListener.class, l);
    }

    public synchronized void removeStateListener(IStateListener l) {
        this.listenerList.remove(IStateListener.class, l);
    }

    public synchronized void addAttributeStateListener(IAttributeStateListener l) {
        this.listenerList.add(IAttributeStateListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeAttributeStateListener(IAttributeStateListener l) {
        this.listenerList.remove(IAttributeStateListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void addStatusListener(IStatusListener l) {
        this.listenerList.add(IStatusListener.class, l);
    }

    public synchronized void removeStatusListener(IStatusListener l) {
        this.listenerList.remove(IStatusListener.class, l);
    }

    public synchronized void addErrorListener(IErrorListener l) {
        this.listenerList.add(IErrorListener.class, l);
    }

    public synchronized void removeErrorListener(IErrorListener l) {
        this.listenerList.remove(IErrorListener.class, l);
    }

    public synchronized void addSetErrorListener(ISetErrorListener l) {
        this.listenerList.add(ISetErrorListener.class, l);
    }

    public synchronized void removeSetErrorListener(ISetErrorListener l) {
        this.listenerList.remove(ISetErrorListener.class, l);
    }

    public synchronized void addNumberScalarListener(INumberScalarListener l) {
        this.listenerList.add(INumberScalarListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeNumberScalarListener(INumberScalarListener l) {
        this.listenerList.remove(INumberScalarListener.class, l);
        this.removeErrorListener(l);
    }

    public synchronized void removeAtkEventListeners() {
        this.listenerList.removeAtkEventListeners();
    }

    public void fireResultEvent(ICommand source, List result) {
        this.fireResultEvent(source, result, System.currentTimeMillis());
    }

    public void fireResultEvent(ICommand source, List result, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.resultEvent == null) {
            this.resultEvent = new ResultEvent(source, result, timeStamp);
        } else {
            this.resultEvent.setSource(source);
            this.resultEvent.setResult(result);
            this.resultEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IResultListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IResultListener)weakRef.get()).resultChange(this.resultEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireStatusEvent(Object source, String status) {
        this.fireStatusEvent(source, status, System.currentTimeMillis());
    }

    public void fireStatusEvent(Object source, String status, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.statusEvent == null) {
            this.statusEvent = new StatusEvent(source, status, timeStamp);
        } else {
            this.statusEvent.setSource(source);
            this.statusEvent.setStatus(status);
            this.statusEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IStatusListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IStatusListener)weakRef.get()).statusChange(this.statusEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireStateEvent(Device source, String state) {
        this.fireStateEvent(source, state, System.currentTimeMillis());
    }

    public void fireStateEvent(Device source, String state, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.stateEvent == null) {
            this.stateEvent = new StateEvent(source, state, timeStamp);
        } else {
            this.stateEvent.setSource(source);
            this.stateEvent.setState(state);
            this.stateEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IStateListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IStateListener)weakRef.get()).stateChange(this.stateEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireAttributeStateEvent(IAttribute source, String state) {
        this.fireAttributeStateEvent(source, state, System.currentTimeMillis());
    }

    public void fireAttributeStateEvent(IAttribute source, String state, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.attributeStateEvent == null) {
            this.attributeStateEvent = new AttributeStateEvent(source, state, timeStamp);
        } else {
            this.attributeStateEvent.setSource(source);
            this.attributeStateEvent.setState(state);
            this.attributeStateEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IAttributeStateListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IAttributeStateListener)weakRef.get()).stateChange(this.attributeStateEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireReadErrorEvent(Object source, Throwable t) {
        this.fireReadErrorEvent(source, t, System.currentTimeMillis());
    }

    public void fireReadErrorEvent(Object source, Throwable t, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.readErrorEvent == null) {
            this.readErrorEvent = new ErrorEvent(source, t, timeStamp);
        } else {
            this.readErrorEvent.setSource(source);
            this.readErrorEvent.setError(t);
            this.readErrorEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IErrorListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IErrorListener)weakRef.get()).errorChange(this.readErrorEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireSetErrorEvent(Object source, Throwable t) {
        this.fireSetErrorEvent(source, t, System.currentTimeMillis());
    }

    public void fireSetErrorEvent(Object source, Throwable t, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.setErrorEvent == null) {
            this.setErrorEvent = new ErrorEvent(source, t, timeStamp);
        } else {
            this.setErrorEvent.setSource(source);
            this.setErrorEvent.setError(t);
            this.setErrorEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISetErrorListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((ISetErrorListener)weakRef.get()).setErrorOccured(this.setErrorEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireNumberScalarEvent(INumberScalar source, double value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.numberScalarEvent == null) {
            this.numberScalarEvent = new NumberScalarEvent(source, value, timeStamp);
        } else {
            this.numberScalarEvent.setSource(source);
            this.numberScalarEvent.setValue(value);
            this.numberScalarEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != INumberScalarListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((INumberScalarListener)weakRef.get()).numberScalarChange(this.numberScalarEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireStringScalarEvent(IStringScalar source, String value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.stringScalarEvent == null) {
            this.stringScalarEvent = new StringScalarEvent(source, value, timeStamp);
        } else {
            this.stringScalarEvent.setSource(source);
            this.stringScalarEvent.setValue(value);
            this.stringScalarEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IStringScalarListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IStringScalarListener)weakRef.get()).stringScalarChange(this.stringScalarEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireSpectrumEvent(INumberSpectrum source, double[] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.numberSpectrumEvent == null) {
            this.numberSpectrumEvent = new NumberSpectrumEvent(source, value, timeStamp);
        } else {
            this.numberSpectrumEvent.setSource(source);
            this.numberSpectrumEvent.setValue(value);
            this.numberSpectrumEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISpectrumListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((ISpectrumListener)weakRef.get()).spectrumChange(this.numberSpectrumEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireImageEvent(INumberImage source, double[][] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.numberImageEvent == null) {
            this.numberImageEvent = new NumberImageEvent(source, value, timeStamp);
        } else {
            this.numberImageEvent.setSource(source);
            this.numberImageEvent.setValue(value);
            this.numberImageEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IImageListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IImageListener)weakRef.get()).imageChange(this.numberImageEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public void fireStringSpectrumEvent(IStringSpectrum source, String[] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.stringSpectrumEvent == null) {
            this.stringSpectrumEvent = new StringSpectrumEvent(source, value, timeStamp);
        } else {
            this.stringSpectrumEvent.setSource(source);
            this.stringSpectrumEvent.setValue(value);
            this.stringSpectrumEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IStringSpectrumListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IStringSpectrumListener)weakRef.get()).stringSpectrumChange(this.stringSpectrumEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addBooleanImageListener(IBooleanImageListener l) {
        this.listenerList.add(IBooleanImageListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeBooleanImageListener(IBooleanImageListener l) {
        this.listenerList.remove(IBooleanImageListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireBooleanImageEvent(IBooleanImage source, boolean[][] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.boolImageEvent == null) {
            this.boolImageEvent = new BooleanImageEvent(source, value, timeStamp);
        } else {
            this.boolImageEvent.setSource(source);
            this.boolImageEvent.setValue(value);
            this.boolImageEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IBooleanImageListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IBooleanImageListener)weakRef.get()).booleanImageChange(this.boolImageEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addBooleanSpectrumListener(IBooleanSpectrumListener l) {
        this.listenerList.add(IBooleanSpectrumListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeBooleanSpectrumListener(IBooleanSpectrumListener l) {
        this.listenerList.remove(IBooleanSpectrumListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireBooleanSpectrumEvent(IBooleanSpectrum source, boolean[] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.boolSpectrumEvent == null) {
            this.boolSpectrumEvent = new BooleanSpectrumEvent(source, value, timeStamp);
        } else {
            this.boolSpectrumEvent.setSource(source);
            this.boolSpectrumEvent.setValue(value);
            this.boolSpectrumEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IBooleanSpectrumListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IBooleanSpectrumListener)weakRef.get()).booleanSpectrumChange(this.boolSpectrumEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addBooleanScalarListener(IBooleanScalarListener l) {
        this.listenerList.add(IBooleanScalarListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeBooleanScalarListener(IBooleanScalarListener l) {
        this.listenerList.remove(IBooleanScalarListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireBooleanScalarEvent(IBooleanScalar source, boolean value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.boolScalarEvent == null) {
            this.boolScalarEvent = new BooleanScalarEvent(source, value, timeStamp);
        } else {
            this.boolScalarEvent.setSource(source);
            this.boolScalarEvent.setValue(value);
            this.boolScalarEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IBooleanScalarListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IBooleanScalarListener)weakRef.get()).booleanScalarChange(this.boolScalarEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addDevStateScalarListener(IDevStateScalarListener l) {
        this.listenerList.add(IDevStateScalarListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeDevStateScalarListener(IDevStateScalarListener l) {
        this.listenerList.remove(IDevStateScalarListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireDevStateScalarEvent(IDevStateScalar source, String value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.devStateScalarEvent == null) {
            this.devStateScalarEvent = new DevStateScalarEvent(source, value, timeStamp);
        } else {
            this.devStateScalarEvent.setSource(source);
            this.devStateScalarEvent.setValue(value);
            this.devStateScalarEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IDevStateScalarListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IDevStateScalarListener)weakRef.get()).devStateScalarChange(this.devStateScalarEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addEndGroupExecutionListener(IEndGroupExecutionListener l) {
        this.listenerList.add(IEndGroupExecutionListener.class, l);
    }

    public synchronized void removeEndGroupExecutionListener(IEndGroupExecutionListener l) {
        this.listenerList.remove(IEndGroupExecutionListener.class, l);
    }

    public void fireEndGroupExecutionEvent(ICommandGroup source, List result) {
        this.fireEndGroupExecutionEvent(source, result, System.currentTimeMillis());
    }

    public void fireEndGroupExecutionEvent(ICommandGroup source, List result, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.endGroupExecEvent == null) {
            this.endGroupExecEvent = new EndGroupExecutionEvent(source, result, timeStamp);
        } else {
            this.endGroupExecEvent.setSource(source);
            this.endGroupExecEvent.setResult(result);
            this.endGroupExecEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEndGroupExecutionListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IEndGroupExecutionListener)weakRef.get()).endGroupExecution(this.endGroupExecEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addRawImageListener(IRawImageListener l) {
        this.listenerList.add(IRawImageListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeRawImageListener(IRawImageListener l) {
        this.listenerList.remove(IRawImageListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireRawImageEvent(IRawImage source, String encFormat, byte[] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.rawImageEvent == null) {
            this.rawImageEvent = new RawImageEvent(source, encFormat, value, timeStamp);
        } else {
            this.rawImageEvent.setSource(source);
            this.rawImageEvent.setValue(encFormat, value);
            this.rawImageEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IRawImageListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IRawImageListener)weakRef.get()).rawImageChange(this.rawImageEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addEnumScalarListener(IEnumScalarListener l) {
        this.listenerList.add(IEnumScalarListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeEnumScalarListener(IEnumScalarListener l) {
        this.listenerList.remove(IEnumScalarListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireEnumScalarEvent(IEnumScalar source, String value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.enumScalarEvent == null) {
            this.enumScalarEvent = new EnumScalarEvent(source, value, timeStamp);
        } else {
            this.enumScalarEvent.setSource(source);
            this.enumScalarEvent.setValue(value);
            this.enumScalarEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEnumScalarListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IEnumScalarListener)weakRef.get()).enumScalarChange(this.enumScalarEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addEnumSpectrumListener(IEnumSpectrumListener l) {
        this.listenerList.add(IEnumSpectrumListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeEnumSpectrumListener(IEnumSpectrumListener l) {
        this.listenerList.remove(IEnumSpectrumListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireEnumSpectrumEvent(IEnumSpectrum source, String[] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.enumSpectrumEvent == null) {
            this.enumSpectrumEvent = new EnumSpectrumEvent(source, value, timeStamp);
        } else {
            this.enumSpectrumEvent.setSource(source);
            this.enumSpectrumEvent.setValue(value);
            this.enumSpectrumEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEnumSpectrumListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IEnumSpectrumListener)weakRef.get()).enumSpectrumChange(this.enumSpectrumEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addStringImageListener(IStringImageListener l) {
        this.listenerList.add(IStringImageListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeStringImageListener(IStringImageListener l) {
        this.listenerList.remove(IStringImageListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireStringImageEvent(IStringImage source, String[][] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.strImageEvent == null) {
            this.strImageEvent = new StringImageEvent(source, value, timeStamp);
        } else {
            this.strImageEvent.setSource(source);
            this.strImageEvent.setValue(value);
            this.strImageEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IStringImageListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IStringImageListener)weakRef.get()).stringImageChange(this.strImageEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public synchronized void addDevStateSpectrumListener(IDevStateSpectrumListener l) {
        this.listenerList.add(IDevStateSpectrumListener.class, l);
        this.addErrorListener(l);
    }

    public synchronized void removeDevStateSpectrumListener(IDevStateSpectrumListener l) {
        this.listenerList.remove(IDevStateSpectrumListener.class, l);
        this.removeErrorListener(l);
    }

    public void fireDevStateSpectrumEvent(IDevStateSpectrum source, String[] value, long timeStamp) {
        Object[] listeners = this.listenerList.getListenerList();
        if (this.devStateSpectrumEvent == null) {
            this.devStateSpectrumEvent = new DevStateSpectrumEvent(source, value, timeStamp);
        } else {
            this.devStateSpectrumEvent.setSource(source);
            this.devStateSpectrumEvent.setValue(value);
            this.devStateSpectrumEvent.setTimeStamp(timeStamp);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IDevStateSpectrumListener.class) continue;
            WeakReference weakRef = (WeakReference)listeners[i + 1];
            if (weakRef.get() != null) {
                ((IDevStateSpectrumListener)weakRef.get()).devStateSpectrumChange(this.devStateSpectrumEvent);
                continue;
            }
            this.listenerList.remove(i);
        }
    }

    public String getVersion() {
        return "$Id$";
    }

    public AtkEventListenerList getListenerList() {
        return this.listenerList;
    }
}

