/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IRefreshee;
import fr.esrf.tangoatk.core.Refresher;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class DeviceFactory
implements IRefreshee,
Serializable {
    public static final int TRACE_NONE = 0;
    public static final int TRACE_FAIL = 1;
    public static final int TRACE_SUCCESS = 2;
    public static final int TRACE_REFRESHER = 4;
    public static final int TRACE_ATTREFRESHER = 8;
    public static final int TRACE_COMMAND = 16;
    public static final int TRACE_CHANGE_EVENT = 32;
    public static final int TRACE_STATE_REFRESHER = 64;
    public static final int TRACE_PERIODIC_EVENT = 128;
    public static final int TRACE_DEVFACTORY = 256;
    public static final int TRACE_ATTFACTORY = 512;
    public static final int TRACE_CMDFACTORY = 1024;
    public static final int TRACE_ATT_CONFIG_EVENT = 2048;
    public static final int TRACE_ALL = 255;
    private int traceMode = 0;
    private Object deviceMonitor = new Object();
    private String[] deviceNames = new String[0];
    private Vector<Device> devices = new Vector();
    private static DeviceFactory instance;
    protected int refreshInterval = 1000;
    protected Refresher refresher = null;
    protected static boolean autoStart;
    protected boolean traceUnexpected = false;

    private DeviceFactory() {
    }

    public static DeviceFactory getInstance() {
        if (instance == null) {
            instance = new DeviceFactory();
        }
        return instance;
    }

    public void setTraceMode(int level) {
        this.traceMode = level;
    }

    public int getTraceMode() {
        return this.traceMode;
    }

    public void trace(int level, String msg, long startTime) {
        if ((this.traceMode & level) != 0) {
            long now = System.currentTimeMillis();
            if (startTime >= 0L) {
                System.out.println(msg + " : " + Long.toString(now - startTime) + " ms");
            } else {
                System.out.println(msg);
            }
        }
    }

    public void setRefreshInterval(int milliSeconds) {
        this.refreshInterval = milliSeconds;
        if (this.refresher != null) {
            this.refresher.setRefreshInterval(this.refreshInterval);
        }
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void stopRefresher() {
        if (this.refresher != null) {
            this.refresher.stopRunning();
        }
        this.refresher = null;
    }

    public void startRefresher() {
        if (this.isRefreshing()) {
            return;
        }
        if (this.refresher == null) {
            this.refresher = new Refresher("device");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
            this.refresher.setTraceUnexpected(this.traceUnexpected);
            this.refresher.addRefreshee(this);
        }
        this.refresher.start();
    }

    public boolean isRefreshing() {
        if (this.refresher == null) {
            return false;
        }
        return this.refresher.isRunning();
    }

    public void setRefresher(Refresher r) {
        this.refresher = r;
    }

    public boolean isDevice(String name) {
        try {
            this.getDevice(name);
        }
        catch (ConnectionException de) {
            System.out.println("DeviceFactory.isDevice(" + name + ") : " + de.getErrors()[0].desc);
            return false;
        }
        catch (Exception e) {
            System.out.println("DeviceFactory.isDevice(" + name + ") : Unexpected exception caught...");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Device getDevice(String name) throws ConnectionException {
        Device d = null;
        String lowerName = name.toLowerCase();
        int pos = Arrays.binarySearch(this.deviceNames, lowerName);
        if (pos >= 0) {
            d = this.devices.get(pos);
        }
        if (pos < 0) {
            long t0 = System.currentTimeMillis();
            try {
                d = new Device(name);
                this.trace(2, "DeviceFactory.getDevice(" + name + ") ok", t0);
            }
            catch (DevFailed e) {
                this.trace(1, "DeviceFactory.getDevice(" + name + ") failed", t0);
                throw new ConnectionException(e);
            }
            int ipos = -(pos + 1);
            int lgth = this.deviceNames.length;
            String[] newDeviceNames = new String[lgth + 1];
            System.arraycopy(this.deviceNames, 0, newDeviceNames, 0, ipos);
            System.arraycopy(this.deviceNames, ipos, newDeviceNames, ipos + 1, lgth - ipos);
            newDeviceNames[ipos] = lowerName;
            Object object = this.deviceMonitor;
            synchronized (object) {
                this.devices.add(ipos, d);
                this.deviceNames = newDeviceNames;
            }
            this.dumpFactory("Adding " + lowerName);
            if (autoStart) {
                this.startRefresher();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Device getConnectionlessDevice(String name) throws ConnectionException {
        Device d = null;
        String lowerName = name.toLowerCase();
        int pos = Arrays.binarySearch(this.deviceNames, lowerName);
        if (pos >= 0) {
            d = this.devices.get(pos);
        }
        if (pos < 0) {
            long t0 = System.currentTimeMillis();
            try {
                d = new Device(name, true);
                this.trace(2, "DeviceFactory.getConnectionlessDevice(" + name + ") ok", t0);
            }
            catch (DevFailed e) {
                this.trace(1, "DeviceFactory.getConnectionlessDevice(" + name + ") failed", t0);
                throw new ConnectionException(e);
            }
            int ipos = -(pos + 1);
            int lgth = this.deviceNames.length;
            String[] newDeviceNames = new String[lgth + 1];
            System.arraycopy(this.deviceNames, 0, newDeviceNames, 0, ipos);
            System.arraycopy(this.deviceNames, ipos, newDeviceNames, ipos + 1, lgth - ipos);
            newDeviceNames[ipos] = lowerName;
            Object object = this.deviceMonitor;
            synchronized (object) {
                this.devices.add(ipos, d);
                this.deviceNames = newDeviceNames;
            }
            this.dumpFactory("Adding " + lowerName);
            if (autoStart) {
                this.startRefresher();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object[] devs;
        Object object = this.deviceMonitor;
        synchronized (object) {
            devs = this.devices.toArray();
        }
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < devs.length; ++i) {
            Device d = (Device)devs[i];
            if (d.getPropChanges().getListenerCount() <= 0) continue;
            d.refresh();
        }
        this.trace(64, "DeviceFactory.refresh() Loop time", t0);
    }

    private void dumpFactory(String msg) {
        if ((this.traceMode & 0x100) != 0) {
            System.out.println("-- DeviceFactory : " + msg + " --");
            for (int i = 0; i < this.deviceNames.length; ++i) {
                System.out.println("  " + i + ":" + this.deviceNames[i]);
            }
            System.out.println("-- DeviceFactory --------------------------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteDevice(String name) {
        String lowerName = name.toLowerCase();
        int pos = Arrays.binarySearch(this.deviceNames, lowerName);
        if (pos >= 0) {
            int lgth = this.deviceNames.length;
            String[] tmp = new String[lgth - 1];
            System.arraycopy(this.deviceNames, 0, tmp, 0, pos);
            System.arraycopy(this.deviceNames, pos + 1, tmp, pos, lgth - pos - 1);
            Object object = this.deviceMonitor;
            synchronized (object) {
                this.deviceNames = tmp;
                this.devices.remove(pos);
            }
            this.dumpFactory("Removing " + lowerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDeviceNames() {
        Vector<String> l = new Vector<String>();
        Object object = this.deviceMonitor;
        synchronized (object) {
            for (int i = 0; i < this.deviceNames.length; ++i) {
                l.add(this.deviceNames[i]);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device[] getDevices() {
        Device[] ret = null;
        Object object = this.deviceMonitor;
        synchronized (object) {
            ret = new Device[this.devices.size()];
            for (int i = 0; i < this.devices.size(); ++i) {
                ret[i] = this.devices.get(i);
            }
        }
        return ret;
    }

    public static void setAutoStart(boolean b) {
        autoStart = b;
    }

    public static boolean isAutoStart() {
        return autoStart;
    }

    public synchronized boolean containsDevice(String name) {
        Device d = null;
        String lowerName = name.toLowerCase();
        int pos = Arrays.binarySearch(this.deviceNames, lowerName);
        if (pos >= 0) {
            d = this.devices.get(pos);
        }
        return pos >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addDevice(Device dev) {
        Object d = null;
        String lowerName = null;
        if (dev == null) {
            return;
        }
        lowerName = dev.getName().toLowerCase();
        int pos = Arrays.binarySearch(this.deviceNames, lowerName);
        if (pos >= 0) {
            return;
        }
        int ipos = -(pos + 1);
        int lgth = this.deviceNames.length;
        String[] newDeviceNames = new String[lgth + 1];
        System.arraycopy(this.deviceNames, 0, newDeviceNames, 0, ipos);
        System.arraycopy(this.deviceNames, ipos, newDeviceNames, ipos + 1, lgth - ipos);
        newDeviceNames[ipos] = lowerName;
        Object object = this.deviceMonitor;
        synchronized (object) {
            this.devices.add(ipos, dev);
            this.deviceNames = newDeviceNames;
        }
        this.dumpFactory("Adding " + lowerName);
        if (autoStart) {
            this.startRefresher();
        }
    }

    public String getVersion() {
        return "$Id$";
    }

    public boolean isTraceUnexpected() {
        return this.traceUnexpected;
    }

    public void setTraceUnexpected(boolean traceUnexpected) {
        this.traceUnexpected = traceUnexpected;
        if (this.refresher != null) {
            this.refresher.setTraceUnexpected(traceUnexpected);
        }
    }

    static {
        autoStart = true;
    }
}

