/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class Device
extends DeviceProxy
implements IDevice,
Serializable {
    public static final String OPEN_CLOSE_PROP = "OpenCloseInverted";
    public static final String INSERT_EXTRACT_PROP = "InsertExtractInverted";
    private String name;
    private boolean supportsEvents;
    protected EventSupport propChanges;
    protected transient DeviceProxy proxy;
    private long refreshCount = 0L;
    private int idlVersion = 0;
    private boolean connected = true;
    protected Map<String, DeviceProperty> propertyMap;
    private boolean openCloseInverted = false;
    private boolean insertExtractInverted = false;
    protected boolean devPropertiesLoaded = false;
    private static Map<String, DevState> stringStateMap = new HashMap<String, DevState>();

    public Device(String name) throws DevFailed {
        super(name);
        this.init(name);
    }

    public Device(String name, String host, String port) throws DevFailed {
        super(name, host, port);
        this.init(name);
    }

    public Device(String name, boolean connectionLess) throws DevFailed {
        super(name);
        long t0 = System.currentTimeMillis();
        if (!connectionLess) {
            this.init(name);
        } else {
            try {
                this.init(name);
            }
            catch (DevFailed df) {
                this.trace(1, "Device.get_idl_version(" + name + ") failed", t0);
                this.setConnected(false);
            }
        }
    }

    protected void init(String name) throws DevFailed {
        long t0 = System.currentTimeMillis();
        this.propertyMap = new HashMap<String, DeviceProperty>();
        this.propChanges = new EventSupport();
        this.name = name;
        this.supportsEvents = false;
        this.openCloseInverted = false;
        this.insertExtractInverted = false;
        this.idlVersion = this.get_idl_version();
        this.trace(2, "Device.get_idl_version(" + name + ") ok", t0);
        if (this.idlVersion >= 3) {
            this.supportsEvents = true;
        }
    }

    public void reconnect() {
        long t0 = System.currentTimeMillis();
        try {
            this.idlVersion = this.get_idl_version();
            this.setConnected(true);
            this.trace(2, "Device.reconnect get_idl_version(" + this.name + ") ok", t0);
            if (this.idlVersion >= 3) {
                this.supportsEvents = true;
            }
        }
        catch (DevFailed dfe) {
            this.trace(1, "Device.reconnect get_idl_version(" + this.name + ") failed", t0);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void setConnected(boolean b) {
        this.connected = b;
    }

    public void addErrorListener(IErrorListener l) {
        this.propChanges.addErrorListener(l);
    }

    public void removeErrorListener(IErrorListener l) {
        this.propChanges.removeErrorListener(l);
    }

    @Override
    public void addStatusListener(IStatusListener l) {
        this.propChanges.addStatusListener(l);
    }

    @Override
    public void removeStatusListener(IStatusListener l) {
        this.propChanges.removeStatusListener(l);
    }

    @Override
    public void addStateListener(IStateListener l) {
        this.propChanges.addStateListener(l);
    }

    @Override
    public void removeStateListener(IStateListener l) {
        this.propChanges.removeStateListener(l);
    }

    public void addListener(IDeviceListener l) {
        this.propChanges.addStateListener(l);
        this.propChanges.addStatusListener(l);
    }

    public void removeListener(IDeviceListener l) {
        this.propChanges.removeStateListener(l);
        this.propChanges.removeStatusListener(l);
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    @Override
    public void refresh() {
        if (!this.isConnected()) {
            this.reconnect();
        }
        if (this.isConnected()) {
            ++this.refreshCount;
            DevState s = null;
            long t0 = System.currentTimeMillis();
            try {
                try {
                    s = this.state(false);
                    this.trace(64, "Device.refresh(State," + this.name + ") success", t0);
                    this.propChanges.fireStateEvent(this, Device.toString(s));
                }
                catch (DevFailed ex) {
                    this.trace(64, "Device.refresh(State," + this.name + ") failed", t0);
                    ConnectionException e = new ConnectionException(ex);
                    this.deviceError("Couldn't read state: ", e);
                    String newStatus = this.getName() + ":\n" + e.getDescription();
                    this.propChanges.fireStateEvent(this, "UNKNOWN");
                    this.propChanges.fireStatusEvent(this, newStatus);
                    return;
                }
                t0 = System.currentTimeMillis();
                try {
                    String newStatus = this.status(false);
                    this.trace(64, "Device.refresh(Status," + this.name + ") success", t0);
                    this.propChanges.fireStatusEvent(this, newStatus);
                }
                catch (DevFailed ex) {
                    this.trace(64, "Device.refresh(Status," + this.name + ") failed", t0);
                    ConnectionException e = new ConnectionException(ex);
                    String newStatus = this.getName() + ":\n" + e.getDescription();
                    this.propChanges.fireStatusEvent(this, newStatus);
                    return;
                }
            }
            catch (Exception ex) {
                System.out.println("-- Device.refresh() : Unexpected exception -----------------------");
                ex.printStackTrace();
                try {
                    ConnectionException e = new ConnectionException(ex);
                    this.propChanges.fireStateEvent(this, "UNKNOWN");
                    this.propChanges.fireStatusEvent(this, "UNKNOWN");
                    this.deviceError("Couldn't read state: ", e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isAlive() {
        long t0 = System.currentTimeMillis();
        try {
            this.ping();
            this.trace(2, "Device.ping(" + this.name + ") success", t0);
            return true;
        }
        catch (DevFailed e) {
            this.trace(1, "Device.ping(" + this.name + ") failed", t0);
            return false;
        }
    }

    public CommandInfo[] getCommandList() throws DevFailed {
        CommandInfo[] ret;
        long t0 = System.currentTimeMillis();
        try {
            ret = this.command_list_query();
            this.trace(2, "Device.command_list_query(" + this.name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(1, "Device.command_list_query(" + this.name + ") failed", t0);
            throw e;
        }
        return ret;
    }

    public CommandInfo getCommand(String name) throws DevFailed {
        CommandInfo ret;
        long t0 = System.currentTimeMillis();
        try {
            ret = this.command_query(name);
            this.trace(2, "Device.command_query(" + this.getName() + "/" + name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(1, "Device.command_query(" + this.getName() + "/" + name + ") failed", t0);
            throw e;
        }
        return ret;
    }

    public AttributeInfoEx[] getAttributeInfo(String[] name) throws DevFailed {
        AttributeInfoEx[] ret;
        long t0 = System.currentTimeMillis();
        try {
            ret = name == null ? this.get_attribute_info_ex() : this.get_attribute_info_ex(name);
            this.trace(2, "Device.get_attribute_info_ex(" + name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(1, "Device.get_attribute_info_ex(" + name + ") failed", t0);
            throw e;
        }
        return ret;
    }

    public AttributeInfoEx getAttributeInfo(String name) throws DevFailed {
        AttributeInfoEx ret;
        long t0 = System.currentTimeMillis();
        try {
            ret = this.get_attribute_info_ex(AEntityFactory.extractEntityName(name));
            this.trace(2, "Device.get_attribute_config(" + this.getName() + "/" + name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(1, "Device.get_attribute_info(" + this.getName() + "/" + name + ") failed", t0);
            throw e;
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        try {
            String al = this.get_alias();
            return al;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void deviceError(String s, Throwable t) {
        this.propChanges.fireReadErrorEvent(this, t);
    }

    @Override
    public String getState() {
        DevState ret = null;
        long t0 = System.currentTimeMillis();
        try {
            ret = this.state(false);
            this.trace(2, "Device.state(" + this.name + ") success", t0);
        }
        catch (Exception e) {
            this.trace(1, "Device.state(" + this.name + ") failed", t0);
            this.deviceError("Couldn't read state: ", new ConnectionException(e));
        }
        return Device.toString(ret);
    }

    public static String toString(DevState st) {
        if (st == null) {
            return "UNKNOWN";
        }
        switch (st.value()) {
            case 0: {
                return "ON";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "INSERT";
            }
            case 5: {
                return "EXTRACT";
            }
            case 6: {
                return "MOVING";
            }
            case 7: {
                return "STANDBY";
            }
            case 8: {
                return "FAULT";
            }
            case 9: {
                return "INIT";
            }
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "ALARM";
            }
            case 12: {
                return "DISABLE";
            }
        }
        return "UNKNOWN";
    }

    public static DevState getStateFromString(String st) {
        if (st == null) {
            return DevState.from_int((int)13);
        }
        if (stringStateMap.containsKey(st)) {
            return stringStateMap.get(st);
        }
        return DevState.from_int((int)13);
    }

    @Override
    public String getStatus() {
        String ret = "UNKNOWN";
        long t0 = System.currentTimeMillis();
        try {
            ret = this.status(false);
            this.trace(2, "Device.status(" + this.name + ") success", t0);
        }
        catch (Exception e) {
            this.trace(1, "Device.status(" + this.name + ") failed", t0);
            this.deviceError("Couldn't read status: ", new ConnectionException(e));
        }
        return ret;
    }

    public final DeviceAttribute readAttribute(String name) throws DevFailed {
        DeviceAttribute da;
        long t0 = System.currentTimeMillis();
        try {
            da = this.read_attribute(AEntityFactory.extractEntityName(name));
            this.trace(8, "Device.read_attribute(" + this.getName() + "/" + name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(8, "Device.read_attribute(" + this.getName() + "/" + name + ") failed", t0);
            throw e;
        }
        return da;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    @Override
    public int getIdlVersion() {
        return this.idlVersion;
    }

    public final DeviceAttribute readAttributeFromDevice(String name) throws DevFailed {
        DeviceAttribute da;
        long t0 = System.currentTimeMillis();
        this.set_source(DevSource.DEV);
        try {
            da = this.read_attribute(AEntityFactory.extractEntityName(name));
            this.trace(8, "Device.read_attribute_from_device(" + this.getName() + "/" + name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(8, "Device.read_attribute_from_device(" + this.getName() + "/" + name + ") failed", t0);
            this.set_source(DevSource.CACHE_DEV);
            throw e;
        }
        this.set_source(DevSource.CACHE_DEV);
        return da;
    }

    public void writeAttribute(DeviceAttribute a) throws DevFailed {
        long t0 = System.currentTimeMillis();
        try {
            this.write_attribute(a);
            this.trace(8, "Device.write_attribute(" + this.name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(8, "Device.write_attribute(" + this.name + ") failed", t0);
            throw e;
        }
        this.refresh();
    }

    public DeviceData executeCommand(String command, DeviceData argin) throws DevFailed {
        DeviceData data = null;
        long t0 = System.currentTimeMillis();
        try {
            data = this.command_inout(AEntityFactory.extractEntityName(command), argin);
            this.trace(16, "Device.command_inout(" + this.getName() + "/" + this.name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(16, "Device.command_inout(" + this.getName() + "/" + this.name + ") failed", t0);
            throw e;
        }
        return data;
    }

    public void storeInfo(AttributeInfoEx c) throws DevFailed {
        AttributeInfoEx[] ac = new AttributeInfoEx[]{c};
        long t0 = System.currentTimeMillis();
        try {
            this.set_attribute_info(ac);
            this.trace(8, "Device.set_attribute_info(" + this.name + ") success", t0);
        }
        catch (DevFailed e) {
            this.trace(8, "Device.set_attribute_info(" + this.name + ") failed", t0);
            throw e;
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean doesEvent() {
        return this.supportsEvents;
    }

    public String getVersion() {
        return "$Id$";
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        System.out.print("Storing device " + this.name + "...");
        out.defaultWriteObject();
        System.out.println("Done");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading device ");
        in.defaultReadObject();
        System.out.print(this.name + "...");
        try {
            this.proxy = new DeviceProxy(this.name);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        System.out.println("Done");
    }

    public DeviceProperty getProperty(String propertyName) {
        if (this.propertyMap != null) {
            return this.propertyMap.get(propertyName);
        }
        return null;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public void storeProperty(String propertyName) {
        DeviceProperty property = this.propertyMap.get(propertyName);
        if (property != null) {
            try {
                DbDatum dbProperty = this.get_property(property.getName());
                dbProperty.insert(property.getValue());
                this.put_property(dbProperty);
            }
            catch (DevFailed e) {
                JOptionPane.showMessageDialog(null, "Could not update property " + property.getName(), "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Could not update property " + property.getName() + " : \nThis property is not registered", "Error", 0);
        }
    }

    public void refreshPropertyMap() {
        String[] propnames = null;
        DbDatum[] data = new DbDatum[]{};
        try {
            propnames = this.get_property_list("*");
            if (propnames != null && propnames.length > 0 && (data = this.get_property(propnames)) == null) {
                data = new DbDatum[]{};
            }
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 0; i < data.length; ++i) {
                nameSet.add(data[i].name);
                DeviceProperty property = this.propertyMap.get(data[i].name);
                if (property == null) {
                    property = new DeviceProperty(this, data[i].name, data[i].extractStringArray());
                    this.propertyMap.put(data[i].name, property);
                    continue;
                }
                property.setValue(data[i].extractStringArray());
            }
            Set<String> keySet = this.propertyMap.keySet();
            if (keySet != null) {
                for (String name : keySet) {
                    if (nameSet.contains(name)) continue;
                    this.propertyMap.remove(name);
                }
            }
        }
        catch (DevFailed df) {
            JOptionPane.showMessageDialog(null, "Failed to update property map", "Error", 0);
        }
    }

    public int getDevTimeout() throws ConnectionException {
        long t0 = System.currentTimeMillis();
        try {
            int tmout_ms = this.get_timeout_millis();
            this.trace(2, "Device.getDevTimeout(" + this.name + ") success", t0);
            return tmout_ms;
        }
        catch (DevFailed de) {
            this.trace(1, "Device.getDevTimeout(" + this.name + ") failed", t0);
            ConnectionException ce = new ConnectionException(de);
            this.deviceError("Couldn't read timeout value : ", ce);
            throw ce;
        }
        catch (Exception ex) {
            this.trace(1, "Device.getDevTimeout(" + this.name + ") failed", t0);
            ConnectionException ce = new ConnectionException(ex);
            this.deviceError("Couldn't read timeout value : ", ce);
            throw ce;
        }
    }

    public synchronized void setDevTimeout(int tmout_ms) throws ConnectionException {
        long t0 = System.currentTimeMillis();
        try {
            this.set_timeout_millis(tmout_ms);
            this.trace(2, "Device.setDevTimeout(" + this.name + ") success", t0);
        }
        catch (DevFailed de) {
            this.trace(1, "Device.setDevTimeout(" + this.name + ") failed", t0);
            ConnectionException ce = new ConnectionException(de);
            this.deviceError("Couldn't set timeout value : ", ce);
            throw ce;
        }
        catch (Exception ex) {
            this.trace(1, "Device.setDevTimeout(" + this.name + ") failed", t0);
            ConnectionException ce = new ConnectionException(ex);
            this.deviceError("Couldn't set timeout value : ", ce);
            throw ce;
        }
    }

    @Override
    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }

    @Override
    public boolean getInvertedOpenClose() {
        return this.openCloseInverted;
    }

    @Override
    public boolean getInvertedInsertExtract() {
        return this.insertExtractInverted;
    }

    void setInvertedOpenClose(boolean b) {
        this.openCloseInverted = b;
    }

    void setInvertedInsertExtract(boolean b) {
        this.insertExtractInverted = b;
    }

    public boolean areDevPropertiesLoaded() {
        return this.devPropertiesLoaded;
    }

    public void loadDevProperties() {
        long t0 = System.currentTimeMillis();
        String[] propList = new String[]{OPEN_CLOSE_PROP, INSERT_EXTRACT_PROP};
        DbDatum[] propDbDatums = null;
        try {
            this.devPropertiesLoaded = true;
            propDbDatums = this.get_property(propList);
        }
        catch (DevFailed dfe) {
            this.trace(1, "Device.get_property(OpenCloseInverted, InsertExtractInverted) failed", t0);
        }
        if (propDbDatums == null) {
            return;
        }
        if (propDbDatums.length != 2) {
            return;
        }
        if (!propDbDatums[0].is_empty()) {
            this.openCloseInverted = propDbDatums[0].extractBoolean();
        }
        if (!propDbDatums[1].is_empty()) {
            this.insertExtractInverted = propDbDatums[1].extractBoolean();
        }
    }

    static {
        stringStateMap.put("ON", DevState.from_int((int)0));
        stringStateMap.put("OFF", DevState.from_int((int)1));
        stringStateMap.put("CLOSE", DevState.from_int((int)2));
        stringStateMap.put("OPEN", DevState.from_int((int)3));
        stringStateMap.put("INSERT", DevState.from_int((int)4));
        stringStateMap.put("EXTRACT", DevState.from_int((int)5));
        stringStateMap.put("MOVING", DevState.from_int((int)6));
        stringStateMap.put("STANDBY", DevState.from_int((int)7));
        stringStateMap.put("FAULT", DevState.from_int((int)8));
        stringStateMap.put("INIT", DevState.from_int((int)9));
        stringStateMap.put("RUNNING", DevState.from_int((int)10));
        stringStateMap.put("ALARM", DevState.from_int((int)11));
        stringStateMap.put("DISABLE", DevState.from_int((int)12));
        stringStateMap.put("UNKNOWN", DevState.from_int((int)13));
    }
}

