/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceItem;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class AttributeList
extends AEntityList {
    protected Vector<DeviceItem> deviceList = new Vector();
    protected boolean forceRefresh = true;
    protected DeviceAttribute[] att = null;
    protected DeviceItem devItem = null;
    protected Device dev = null;
    protected long currentTime;

    public AttributeList() {
        this.factory = AttributeFactory.getInstance();
    }

    public void addElement(Object entity) {
        if (!(entity instanceof AAttribute)) {
            System.out.println("Warning, AttributeList supports only IAttribute.");
            return;
        }
        AAttribute attToAdd = (AAttribute)entity;
        super.addElement(attToAdd);
        if (!this.forceRefresh && !attToAdd.hasEvents()) {
            this.addEntity(attToAdd);
        }
    }

    private synchronized void addEntity(AAttribute att) {
        int i = 0;
        boolean found = false;
        Device attDev = att.getDevice();
        while (i < this.deviceList.size() && !found) {
            found = this.deviceList.get(i).getDevice() == attDev;
            if (found) continue;
            ++i;
        }
        if (found) {
            this.deviceList.get(i).add(att);
        } else {
            DeviceItem item = new DeviceItem(attDev);
            item.add(att);
            this.deviceList.add(item);
        }
    }

    private synchronized void removeEntity(AAttribute att) {
        int i = 0;
        boolean found = false;
        Device attDev = att.getDevice();
        while (i < this.deviceList.size() && !found) {
            found = this.deviceList.get(i).getDevice() == attDev;
            if (found) continue;
            ++i;
        }
        if (found) {
            this.deviceList.get(i).remove(att);
            if (this.deviceList.get(i).getEntityNumber() == 0) {
                this.deviceList.remove(i);
            }
        }
    }

    void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    public Object remove(int index) {
        Object removed = super.remove(index);
        if (removed != null && removed instanceof AAttribute) {
            this.removeEntity((AAttribute)removed);
        }
        return removed;
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    @Override
    public void removeAllElements() {
        for (int i = 0; i < this.size(); ++i) {
            this.remove(i);
        }
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.isForceRefresh()) {
            super.refresh();
        } else {
            for (int i = 0; i < this.deviceList.size(); ++i) {
                AttributeList attributeList = this;
                synchronized (attributeList) {
                    this.devItem = this.deviceList.get(i);
                    this.dev = this.devItem.getDevice();
                    this.currentTime = System.currentTimeMillis();
                    try {
                        this.att = this.dev.read_attribute(this.devItem.getNames());
                        this.trace(4, "Device.read_attribute(" + this.dev.getName() + ") " + this.devItem.getEntityNumber() + " attributes read : OK", this.currentTime);
                        for (int j = 0; j < this.devItem.getEntityNumber(); ++j) {
                            this.devItem.getEntity(j).dispatch(this.att[j]);
                        }
                        this.att = null;
                    }
                    catch (DevFailed e) {
                        this.att = null;
                        this.trace(4, "Device.read_attribute(" + this.dev.getName() + ") " + this.devItem.getEntityNumber() + " attributes read : Failed", this.currentTime);
                        for (int j = 0; j < this.devItem.getEntityNumber(); ++j) {
                            this.devItem.getEntity(j).dispatchError(e);
                        }
                    }
                    this.devItem = null;
                    this.dev = null;
                    continue;
                }
            }
            this.fireRefresherStepEvent();
        }
    }

    @Override
    public void startRefresher() {
        for (int i = 0; i < this.size() && !this.forceRefresh; ++i) {
            IAttribute att = (IAttribute)this.get(i);
            int idl = att.getDevice().getIdlVersion();
            if (idl >= 3) continue;
            System.out.println("Warning, " + att.getName() + " has an IDL<=2 and does not support multiple DevFailed, switching to classic refresh.");
            this.forceRefresh = true;
        }
        super.startRefresher();
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading AttributeList ");
        in.defaultReadObject();
        System.out.println("Starting refresher on list");
        this.startRefresher();
    }
}

