/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;

public class ATKException
extends Exception {
    private DevError[] errors = new DevError[0];
    private Object source = null;
    public static String[] severity = new String[]{"WARNING", "ERROR", "PANIC"};
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    public static final int PANIC = 2;

    public ATKException() {
        this.source = this;
    }

    public ATKException(String s) {
        super(s);
        this.source = this;
    }

    public ATKException(DevFailed e) {
        this.setStackTrace(e.getStackTrace());
        this.source = e;
        if (e.errors != null) {
            this.errors = e.errors;
        } else {
            System.out.println("ATKException.ATKException() : Cannot handle DevFailed with null stack.");
        }
    }

    public ATKException(String s, DevError[] errs) {
        super(s);
        this.source = this;
        if (errs != null) {
            this.errors = errs;
        } else {
            System.out.println("ATKException.ATKException() : Cannot handle ATKException with null error stack.");
        }
    }

    public ATKException(Exception e) {
        super(e.getMessage());
        this.source = e;
        this.setStackTrace(e.getStackTrace());
    }

    public ATKException(Error err) {
        super(err.getMessage());
        this.source = err;
        this.setStackTrace(err.getStackTrace());
    }

    public void setError(DevFailed e) {
        this.setStackTrace(e.getStackTrace());
        this.source = e;
        if (e.errors != null) {
            this.errors = e.errors;
        } else {
            System.out.println("ATKException.setError() : Cannot handle DevFailed with null stack.");
        }
    }

    public DevError[] getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        String s = this.toString();
        if (s == null) {
            return this.getSourceName();
        }
        return s;
    }

    public int getSeverity() {
        return this.getSeverity(0);
    }

    public int getSeverity(int i) {
        try {
            return this.errors[i].severity.value();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public String getDescription() {
        if (this.errors.length == 0) {
            return this.getMessage();
        }
        return this.getDescription(0);
    }

    public String getDescription(int i) {
        try {
            return this.errors[i].desc.trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getOrigin() {
        return this.getOrigin(0);
    }

    public String getOrigin(int i) {
        try {
            return this.errors[i].origin.trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getReason() {
        return this.getReason(0);
    }

    public String getReason(int i) {
        try {
            return this.errors[i].reason.trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getStackLength() {
        return this.errors.length;
    }

    public String getSourceName() {
        String ret = this.source.getClass().toString();
        return ret.substring(6);
    }

    @Override
    public String toString() {
        if (this.errors.length == 0) {
            return super.getMessage();
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.errors.length; ++i) {
            DevError e = this.errors[i];
            buff.append("Severity: ");
            buff.append(severity[e.severity.value()]);
            buff.append("\nOrigin: ");
            buff.append(e.origin.trim());
            buff.append("\nDescription: ");
            buff.append(e.desc.trim());
            buff.append("\nReason: ");
            buff.append(e.reason.trim());
            buff.append("\n");
        }
        return buff.toString();
    }

    public String getVersion() {
        return "$Id$";
    }
}

