/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEntity;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AEntityFactory
implements TangoConst,
Serializable {
    private DeviceFactory deviceFactory = DeviceFactory.getInstance();

    public static String extractDeviceName(String entityName) {
        int j = entityName.lastIndexOf("#");
        int i = entityName.lastIndexOf("/");
        String deviceName = entityName.substring(0, i);
        if (j > 0) {
            deviceName = deviceName + entityName.substring(j);
        }
        return deviceName;
    }

    public static String extractDeviceNameAdvanced(String name) throws DevFailed {
        int i = name.lastIndexOf("/");
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        int tokenCount = tokenizer.countTokens();
        switch (tokenCount) {
            case 4: {
                return name.substring(0, i);
            }
            case 3: {
                return name;
            }
            case 2: {
                String alias = name.substring(0, i);
                Database db = ApiUtil.get_db_obj();
                try {
                    String referenceName = db.get_device_from_alias(alias);
                    if (referenceName == null || "".equals(referenceName) || alias.equals(referenceName)) {
                        return null;
                    }
                    return referenceName;
                }
                catch (DevFailed d) {
                    return null;
                }
            }
            case 1: {
                String alias = new String(name);
                Database db = ApiUtil.get_db_obj();
                try {
                    String referenceName = db.get_device_from_alias(alias);
                    if (referenceName == null || "".equals(referenceName) || alias.equals(referenceName)) {
                        referenceName = db.get_attribute_from_alias(alias);
                        if (referenceName == null || "".equals(referenceName) || alias.equals(referenceName)) {
                            return null;
                        }
                        i = referenceName.lastIndexOf("/");
                        return referenceName.substring(0, i);
                    }
                    return referenceName;
                }
                catch (DevFailed d1) {
                    try {
                        String referenceName = db.get_attribute_from_alias(alias);
                        if (referenceName == null || "".equals(referenceName) || alias.equals(referenceName)) {
                            return null;
                        }
                        i = referenceName.lastIndexOf("/");
                        return referenceName.substring(0, i);
                    }
                    catch (DevFailed d2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static String getFQName(Device device, String name) {
        return new StringBuffer(device.toString()).append("/").append(name).toString();
    }

    public static String extractEntityName(String entityName) {
        int i = entityName.lastIndexOf("/");
        if (i == -1) {
            return entityName;
        }
        return entityName.substring(i + 1, entityName.length());
    }

    public static boolean isWildCard(String entityName) {
        return entityName.indexOf("*") != -1;
    }

    protected Device getDevice(String deviceName) throws ConnectionException {
        return this.deviceFactory.getDevice(deviceName);
    }

    public List<IEntity> getEntities(String name) throws ConnectionException {
        try {
            Vector<IEntity> l;
            Device d = this.getDevice(AEntityFactory.extractDeviceName(name));
            if (!AEntityFactory.isWildCard(name)) {
                l = new Vector<IEntity>();
                l.add(this.getSingleEntity(name, d));
            } else {
                l = this.getWildCardEntities(name, d);
            }
            return l;
        }
        catch (ConnectionException ce) {
            if (name.toLowerCase().endsWith("/state")) {
                List<IEntity> eList = this.getConnectionlessSingleAttribute(name);
                if (eList == null) {
                    throw ce;
                }
                return eList;
            }
            throw ce;
        }
        catch (DevFailed d) {
            throw new ConnectionException(d);
        }
    }

    protected List<IEntity> getConnectionlessSingleAttribute(String name) throws ConnectionException {
        return null;
    }

    protected abstract List<IEntity> getWildCardEntities(String var1, Device var2) throws DevFailed;

    protected abstract IEntity getSingleEntity(String var1, Device var2) throws DevFailed;

    public abstract int getSize();

    public abstract String getVersion();
}

