/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.python.bouncycastle.asn1.ASN1GeneralizedTime;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1OutputStream;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.ASN1TaggedObject;
import org.python.bouncycastle.asn1.StreamUtil;
import org.python.bouncycastle.util.Arrays;
import org.python.bouncycastle.util.Strings;

public class DERGeneralizedTime
extends ASN1Primitive {
    private byte[] time;

    public static ASN1GeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)object;
        }
        if (object instanceof DERGeneralizedTime) {
            return new ASN1GeneralizedTime(((DERGeneralizedTime)object).time);
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)DERGeneralizedTime.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl || aSN1Primitive instanceof DERGeneralizedTime) {
            return DERGeneralizedTime.getInstance(aSN1Primitive);
        }
        return new ASN1GeneralizedTime(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public DERGeneralizedTime(String string2) {
        this.time = Strings.toByteArray(string2);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    DERGeneralizedTime(byte[] byArray) {
        this.time = byArray;
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.time);
    }

    public String getTime() {
        String string2 = Strings.fromByteArray(this.time);
        if (string2.charAt(string2.length() - 1) == 'Z') {
            return string2.substring(0, string2.length() - 1) + "GMT+00:00";
        }
        int n = string2.length() - 5;
        char c = string2.charAt(n);
        if (c == '-' || c == '+') {
            return string2.substring(0, n) + "GMT" + string2.substring(n, n + 3) + ":" + string2.substring(n + 3);
        }
        n = string2.length() - 3;
        c = string2.charAt(n);
        if (c == '-' || c == '+') {
            return string2.substring(0, n) + "GMT" + string2.substring(n) + ":00";
        }
        return string2 + this.calculateGMTOffset();
    }

    private String calculateGMTOffset() {
        String string2 = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (n < 0) {
            string2 = "-";
            n = -n;
        }
        int n2 = n / 3600000;
        int n3 = (n - n2 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(this.getDate())) {
                n2 += string2.equals("+") ? 1 : -1;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string2 + this.convert(n2) + ":" + this.convert(n3);
    }

    private String convert(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string2;
        String string3 = string2 = Strings.fromByteArray(this.time);
        if (string2.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string2.indexOf(45) > 0 || string2.indexOf(43) > 0) {
            string3 = this.getTime();
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : new SimpleDateFormat("yyyyMMddHHmmssz");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            char c;
            int n;
            String string4 = string3.substring(14);
            for (n = 1; n < string4.length() && '0' <= (c = string4.charAt(n)) && c <= '9'; ++n) {
            }
            if (n - 1 > 3) {
                string4 = string4.substring(0, 4) + string4.substring(n);
                string3 = string3.substring(0, 14) + string4;
            } else if (n - 1 == 1) {
                string4 = string4.substring(0, n) + "00" + string4.substring(n);
                string3 = string3.substring(0, 14) + string4;
            } else if (n - 1 == 2) {
                string4 = string4.substring(0, n) + "0" + string4.substring(n);
                string3 = string3.substring(0, 14) + string4;
            }
        }
        return simpleDateFormat.parse(string3);
    }

    private boolean hasFractionalSeconds() {
        for (int i = 0; i != this.time.length; ++i) {
            if (this.time[i] != 46 || i != 14) continue;
            return true;
        }
        return false;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        int n = this.time.length;
        return 1 + StreamUtil.calculateBodyLength(n) + n;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(24, this.time);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERGeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((DERGeneralizedTime)aSN1Primitive).time);
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

