/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tango.jhdb.Hdb;

public class Utils {
    static final int FORMAT_SEC = 0;
    static final int FORMAT_US = 1;
    static final int FORMAT_MS = 2;
    private static Date tmpDate = new Date();

    public static void showError(JFrame parent, String errorMsg) {
        JOptionPane.showMessageDialog(parent, errorMsg, "Error", 0);
    }

    public static void showError(String errorMsg) {
        Utils.showError(null, errorMsg);
    }

    public static boolean contains(int[] arr, int item) {
        boolean found = false;
        int i = 0;
        while (i < arr.length && !found) {
            found = arr[i] == item;
            if (found) continue;
            ++i;
        }
        return found;
    }

    public static String[] makeStringArray(String value) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.split("\n");
    }

    public static String[] formatDateAndTime(long time) {
        tmpDate.setTime(time / 1000L);
        String dStr = Hdb.hdbDateFormat.format(tmpDate);
        return dStr.split(" ");
    }

    public static String formatTime(long time, int format) {
        tmpDate.setTime(time / 1000L);
        int microSec = (int)(time % 1000000L);
        if (format == 1) {
            String microSecStr = String.format("%06d", microSec);
            return Hdb.hdbDateFormat.format(tmpDate) + "." + microSecStr;
        }
        if (format == 2) {
            String milliSecStr = String.format("%03d", microSec / 1000);
            return Hdb.hdbDateFormat.format(tmpDate) + "." + milliSecStr;
        }
        return Hdb.hdbDateFormat.format(tmpDate);
    }
}

