/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.MainPanel;
import HDBViewer.MultiLineTable;
import HDBViewer.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TablePanel
extends JPanel {
    MainPanel parent;
    MultiLineTable table;
    JScrollPane tableView;
    private JButton copyButton;
    private JCheckBox displayErrorCheck;
    private JCheckBox doMicroCheck;
    private JButton saveButton;
    private JPanel tableBtnPanel;
    private JPanel tablePanel;

    TablePanel(MainPanel parent) {
        this.parent = parent;
        this.initComponents();
        this.displayErrorCheck.setSelected(true);
        this.table = new MultiLineTable();
        this.tableView = new JScrollPane(this.table);
        this.tablePanel.add((Component)this.tableView, "Center");
        this.setPreferredSize(new Dimension(800, 600));
    }

    private void initComponents() {
        this.tablePanel = new JPanel();
        this.tableBtnPanel = new JPanel();
        this.doMicroCheck = new JCheckBox();
        this.displayErrorCheck = new JCheckBox();
        this.saveButton = new JButton();
        this.copyButton = new JButton();
        this.setLayout(new BorderLayout());
        this.tablePanel.setBorder(BorderFactory.createBevelBorder(1));
        this.tablePanel.setLayout(new BorderLayout());
        this.add((Component)this.tablePanel, "Center");
        this.tableBtnPanel.setLayout(new FlowLayout(2, 5, 1));
        this.doMicroCheck.setFont(new Font("Dialog", 0, 12));
        this.doMicroCheck.setText("Display microseconds");
        this.doMicroCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablePanel.this.doMicroCheckActionPerformed(evt);
            }
        });
        this.tableBtnPanel.add(this.doMicroCheck);
        this.displayErrorCheck.setFont(new Font("Dialog", 0, 12));
        this.displayErrorCheck.setText("Display errors");
        this.displayErrorCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablePanel.this.displayErrorCheckActionPerformed(evt);
            }
        });
        this.tableBtnPanel.add(this.displayErrorCheck);
        this.saveButton.setFont(new Font("Dialog", 0, 12));
        this.saveButton.setText("Save file");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablePanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.tableBtnPanel.add(this.saveButton);
        this.copyButton.setFont(new Font("Dialog", 0, 12));
        this.copyButton.setText("Copy Selection");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablePanel.this.copyButtonActionPerformed(evt);
            }
        });
        this.tableBtnPanel.add(this.copyButton);
        this.add((Component)this.tableBtnPanel, "South");
    }

    private void doMicroCheckActionPerformed(ActionEvent evt) {
        this.table.doMicroSec(this.doMicroCheck.isSelected());
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(".");
        if (chooser.showSaveDialog(null) == 0) {
            try {
                this.table.saveFile(chooser.getSelectedFile().getAbsolutePath());
            }
            catch (IOException e) {
                Utils.showError(e.getMessage());
            }
        }
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        StringSelection stringSelection = new StringSelection(this.table.getSelectionAsString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void displayErrorCheckActionPerformed(ActionEvent evt) {
        this.table.showError(this.displayErrorCheck.isSelected());
    }
}

