/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.PyHDBInterface;
import java.util.ArrayList;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;
import org.tango.jhdb.data.HdbDouble;
import org.tango.jhdb.data.HdbDoubleArray;
import org.tango.jhdb.data.HdbString;

public class PythonScript {
    private PyObject hdbInterfaceClass;

    public PythonScript(String fileName) {
        PythonInterpreter interpreter = new PythonInterpreter();
        interpreter.execfile(fileName);
        this.hdbInterfaceClass = interpreter.get("PyHDBInterface");
    }

    public HdbDataSet[] run(HdbDataSet[] inputs) throws HdbFailed {
        PyList pyR;
        PyList globalList = new PyList();
        for (int i = 0; i < inputs.length; ++i) {
            PyList attList = new PyList();
            attList.add((Object)inputs[i].getName());
            attList.add((Object)new PyInteger(inputs[i].size()));
            for (int j = 0; j < inputs[i].size(); ++j) {
                PyList vList = new PyList();
                HdbData d = inputs[i].get(j);
                int _sec = (int)(d.getDataTime() / 1000000L);
                int _usec = (int)(d.getDataTime() % 1000000L);
                vList.add((Object)_sec);
                vList.add((Object)_usec);
                vList.add((Object)d.getType());
                try {
                    if (HdbSigInfo.isNumericType((int)d.getType())) {
                        if (HdbSigInfo.isArrayType((int)d.getType())) {
                            vList.add((Object)d.getValueAsDoubleArray());
                        } else {
                            vList.add((Object)d.getValueAsDouble());
                        }
                    } else {
                        vList.add((Object)d.getValueAsString());
                    }
                }
                catch (HdbFailed e) {
                    vList.add((Object)e.getMessage());
                }
                attList.add((Object)vList);
            }
            globalList.add((Object)attList);
        }
        try {
            PyObject buildingObject = this.hdbInterfaceClass.__call__((PyObject)new PyInteger(globalList.size()), (PyObject)globalList);
            PyHDBInterface hdbI = (PyHDBInterface)buildingObject.__tojava__(PyHDBInterface.class);
            pyR = hdbI.getResult();
        }
        catch (Exception e) {
            throw new HdbFailed(e.toString());
        }
        HdbDataSet[] result = new HdbDataSet[pyR.size()];
        for (int i = 0; i < pyR.size(); ++i) {
            PyList attList = (PyList)pyR.get(i);
            String attName = (String)attList.get(0);
            int lgth = (Integer)attList.get(1);
            ArrayList<HdbString> list = new ArrayList<HdbString>();
            int _type = 0;
            for (int j = 0; j < lgth; ++j) {
                ArrayList<Object> v;
                HdbString d;
                PyList vList = (PyList)attList.get(j + 2);
                int _sec = (Integer)vList.get(0);
                int _usec = (Integer)vList.get(1);
                _type = (Integer)vList.get(2);
                if (HdbSigInfo.isNumericType((int)_type)) {
                    if (HdbSigInfo.isArrayType((int)_type)) {
                        d = new HdbDoubleArray(3);
                        PyList arrList = (PyList)vList.get(3);
                        ArrayList<Double> v2 = new ArrayList<Double>();
                        int k = 0;
                        while (k < arrList.size()) {
                            v2.add((Double)arrList.get(k));
                            ++j;
                        }
                        d.parseValue(v2);
                    } else {
                        d = new HdbDouble(1);
                        v = new ArrayList();
                        v.add((Double)vList.get(3));
                        d.parseValue(v);
                    }
                } else {
                    d = new HdbString(13);
                    v = new ArrayList<Object>();
                    v.add((String)vList.get(3));
                    d.parseValue(v);
                }
                long dt = (long)_sec * 1000000L + (long)_usec;
                d.setDataTime(dt);
                list.add(d);
            }
            result[i] = new HdbDataSet(list);
            result[i].setName(attName);
            result[i].setType(_type);
        }
        return result;
    }

    private PyHDBInterface run(PyList globalList) {
        PyObject buildingObject = this.hdbInterfaceClass.__call__((PyObject)new PyInteger(globalList.size()), (PyObject)globalList);
        return (PyHDBInterface)buildingObject.__tojava__(PyHDBInterface.class);
    }

    public static void main(String[] args) {
        System.out.println("Running PY");
        try {
            PythonScript script = new PythonScript("test.py");
            int t0 = (int)(System.currentTimeMillis() / 1000L);
            int us = 123456;
            PyList globalList = new PyList();
            PyList d1List = new PyList();
            d1List.add((Object)"Attribute 1");
            d1List.add((Object)new PyInteger(2));
            PyList v1_1 = new PyList();
            v1_1.add((Object)t0);
            v1_1.add((Object)us);
            v1_1.add((Object)1);
            v1_1.add((Object)1.1);
            d1List.add((Object)v1_1);
            PyList v1_2 = new PyList();
            v1_2.add((Object)(t0 + 1));
            v1_2.add((Object)us);
            v1_2.add((Object)1);
            v1_2.add((Object)3.2);
            d1List.add((Object)v1_2);
            PyList d2List = new PyList();
            d2List.add((Object)"Attribute 2");
            d2List.add((Object)new PyInteger(2));
            PyList v2_1 = new PyList();
            v2_1.add((Object)t0);
            v2_1.add((Object)us);
            v2_1.add((Object)1);
            v2_1.add((Object)2.7);
            d2List.add((Object)v2_1);
            PyList v2_2 = new PyList();
            v2_2.add((Object)(t0 + 1));
            v2_2.add((Object)us);
            v2_2.add((Object)1);
            v2_2.add((Object)0.4);
            d2List.add((Object)v2_2);
            globalList.add((Object)d1List);
            globalList.add((Object)d2List);
            PyList r = script.run(globalList).getResult();
            for (int i = 0; i < r.size(); ++i) {
                PyList l = (PyList)r.get(i);
                System.out.println("Name: " + l.get(0));
                int lgth = (Integer)l.get(1);
                for (int j = 0; j < lgth; ++j) {
                    PyList val = (PyList)l.get(2 + j);
                    int _sec = (Integer)val.get(0);
                    int _us = (Integer)val.get(1);
                    int type = (Integer)val.get(2);
                    double d = (Double)val.get(3);
                    System.out.println("# " + j + "(" + _sec + "," + _us + ")" + "=" + d);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Got error: " + e.toString());
        }
    }
}

