/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.ArrayAttributeInfo;
import HDBViewer.AttributeInfo;
import HDBViewer.ChartPanel;
import HDBViewer.DockedPanel;
import HDBViewer.ErrorDialog;
import HDBViewer.HDBTreePanel;
import HDBViewer.ImagePanel;
import HDBViewer.InfoDialog;
import HDBViewer.PythonScript;
import HDBViewer.SelectionPanel;
import HDBViewer.TablePanel;
import HDBViewer.ThreadDlg;
import HDBViewer.Utils;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Splash;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.tango.jhdb.Hdb;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbProgressListener;
import org.tango.jhdb.HdbReader;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.HdbSigParam;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;
import org.tango.jhdb.data.HdbFloatArray;
import org.tango.jhdb.data.HdbLong64Array;
import org.tango.jhdb.data.HdbLongArray;
import org.tango.jhdb.data.HdbShortArray;
import org.tango.jhdb.data.HdbState;
import org.tango.jhdb.data.HdbStateArray;

public class MainPanel
extends JFrame
implements IJLChartListener,
HdbProgressListener {
    static final String APP_RELEASE = "1.10";
    DockedPanel viewDockedPanel;
    ChartPanel chartPanel;
    TablePanel tablePanel;
    ImagePanel imagePanel;
    DockedPanel selDockedPanel;
    SelectionPanel selPanel;
    DockedPanel hdbTreeDockedPanel;
    HDBTreePanel hdbTreePanel;
    Hdb hdb;
    ArrayList<AttributeInfo> selection;
    ErrorDialog errorDialog = null;
    HdbDataSet[] results;
    ThreadDlg searchDlg;
    AttributeInfo selectedImage;
    boolean selectedImageRW;
    boolean runningFromShell;
    Splash splash;
    InfoDialog infoDialog;
    int dvIdx = 0;
    long startR;
    long stopR;
    protected static Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    private JMenuItem errorsMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JSplitPane hSplitPane;
    private JMenuItem infoMenuItem;
    private JMenuBar jMenuBar1;
    private JSplitPane vSplitPane;
    private JCheckBoxMenuItem viewDataviewCheckBoxMenuItem;
    private JMenu viewMenu;
    private JCheckBoxMenuItem viewQueryCheckBoxMenuItem;
    private JCheckBoxMenuItem viewSelectCheckBoxMenuItem;

    public MainPanel() {
        this(true, true);
    }

    public MainPanel(boolean runningFromShell, boolean showSplash) {
        this.runningFromShell = runningFromShell;
        this.initComponents();
        if (showSplash) {
            this.splash = new Splash();
            this.splash.setMaxProgress(100);
            this.splash.setMessage("Connection to HDB");
            this.splash.setTitle("HDB Viewer (1.10)");
            this.splash.setVisible(true);
        }
        this.errorDialog = new ErrorDialog();
        this.infoDialog = new InfoDialog();
        this.hdb = new Hdb();
        try {
            long t0 = System.currentTimeMillis();
            String hdbType = System.getProperty("HDB_TYPE");
            if (hdbType == null || hdbType.isEmpty()) {
                this.hdb.connect();
            } else if (hdbType.equalsIgnoreCase("cassandra")) {
                this.hdb.connectCassandra();
            } else if (hdbType.equalsIgnoreCase("mysql")) {
                this.hdb.connectMySQL();
            } else if (hdbType.equalsIgnoreCase("oracle")) {
                this.hdb.connectOracle();
            } else {
                this.hdb.connect();
            }
            long t1 = System.currentTimeMillis();
            this.infoDialog.addText(this.hdb.getReader().getInfo());
            this.infoDialog.addText("Connection time: " + (t1 - t0) + "ms");
        }
        catch (HdbFailed e) {
            if (showSplash) {
                this.splash.setVisible(false);
            }
            Utils.showError("Cannot connet to HDB\n" + e.getMessage());
            if (runningFromShell) {
                System.exit(0);
            }
            return;
        }
        this.hdb.getReader().addProgressListener((HdbProgressListener)this);
        if (showSplash) {
            this.splash.progress(50);
        }
        String hdbV = this.hdb.getDBType() == 3 ? "HDB" : "HDB++";
        this.setTitle(this.hdb.getDBTypeName() + " " + hdbV + " Viewer [" + APP_RELEASE + "]");
        this.selection = new ArrayList();
        this.chartPanel = new ChartPanel(this);
        this.tablePanel = new TablePanel(this);
        this.imagePanel = new ImagePanel(this);
        this.viewDockedPanel = new DockedPanel(this);
        this.viewDockedPanel.addPanel("Chart", this.chartPanel);
        this.viewDockedPanel.addPanel("Table", this.tablePanel);
        this.viewDockedPanel.addPanel("Image", this.imagePanel);
        this.vSplitPane.setRightComponent(this.viewDockedPanel);
        this.hdbTreeDockedPanel = new DockedPanel(this);
        this.hdbTreePanel = new HDBTreePanel(this);
        this.hdbTreeDockedPanel.addPanel("HDB Tree", this.hdbTreePanel);
        this.vSplitPane.setLeftComponent(this.hdbTreeDockedPanel);
        this.selDockedPanel = new DockedPanel(this);
        this.selPanel = new SelectionPanel(this);
        this.selDockedPanel.addPanel("Selection", this.selPanel);
        this.hSplitPane.setBottomComponent(this.selDockedPanel);
        if (runningFromShell) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(1);
        }
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        if (showSplash) {
            this.splash.progress(100);
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (showSplash) {
            this.splash.setVisible(false);
        }
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/HDBViewer/hdbpp.gif"));
        this.setIconImage(icon.getImage());
    }

    public void unselectAttribute(AttributeInfo ai, int item) {
        if (item < 0) {
            if (ai.chartData != null) {
                ai.chartData.removeFromAxis();
            }
            if (ai.wchartData != null) {
                ai.wchartData.removeFromAxis();
            }
            if (ai.errorData != null) {
                ai.errorData.removeFromAxis();
            }
            ai.selection = 0;
            ai.wselection = 0;
        } else {
            ArrayAttributeInfo aai = ai.arrAttInfos.get(item);
            if (aai.chartData != null) {
                aai.chartData.removeFromAxis();
            }
            if (aai.wchartData != null) {
                aai.wchartData.removeFromAxis();
            }
            aai.selection = 0;
            aai.wselection = 0;
        }
        this.chartPanel.chart.repaint();
    }

    public AttributeInfo addAttribute(String host, String name) throws HdbFailed {
        AttributeInfo ai = new AttributeInfo();
        ai.host = host;
        ai.name = name;
        HdbSigInfo si = this.hdb.getReader().getSigInfo(ai.getFullName());
        ai.type = HdbSigInfo.typeStr[si.type].substring(5).toLowerCase();
        ai.sigInfo = si;
        AttributeInfo eai = AttributeInfo.getFromList(ai, this.selection);
        if (eai != null) {
            return eai;
        }
        if (ai.isString()) {
            ai.table = true;
        }
        if (ai.isNumeric() && !ai.isArray()) {
            ai.selection = 1;
        }
        if (ai.isNumeric() && ai.isArray()) {
            ai.selection = 3;
        }
        if (ai.isState() && !ai.isArray()) {
            ai.step = true;
        }
        this.selection.add(ai);
        this.updateSelectionList();
        return ai;
    }

    public void setDate(long start, long stop) {
        this.hdbTreePanel.setDate(start, stop);
    }

    public void setTimeInterval(int it) {
        this.hdbTreePanel.setTimeInterval(it);
    }

    public void setHdbMode(int mode) {
        this.hdbTreePanel.setHdbMode(mode);
    }

    public void setPyScript(String name) {
        this.selPanel.setPyScript(name);
    }

    public AttributeInfo getAttributeInfo(String host, String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.selection.size()) {
            AttributeInfo ai = this.selection.get(i);
            found = ai.name.equalsIgnoreCase(name) && ai.host.equalsIgnoreCase(host);
            if (found) continue;
            ++i;
        }
        if (!found) {
            return null;
        }
        return this.selection.get(i);
    }

    public void selectAllY1() {
        for (AttributeInfo ai : this.selection) {
            if (ai.isNumeric() && !ai.isArray()) {
                this.selectAttribute(ai, -1, 1, false);
            }
            if (!ai.isExpanded()) continue;
            for (int j = 0; j < ai.arrAttInfos.size(); ++j) {
                ArrayAttributeInfo aai = ai.arrAttInfos.get(j);
                this.selectAttribute(ai, j, 1, false);
            }
        }
        this.updateSelectionList();
    }

    public void selectAllY2() {
        for (AttributeInfo ai : this.selection) {
            if (ai.isNumeric() && !ai.isArray()) {
                this.selectAttribute(ai, -1, 2, false);
            }
            if (!ai.isExpanded()) continue;
            for (int j = 0; j < ai.arrAttInfos.size(); ++j) {
                ArrayAttributeInfo aai = ai.arrAttInfos.get(j);
                this.selectAttribute(ai, j, 2, false);
            }
        }
        this.updateSelectionList();
    }

    public boolean selectAttribute(AttributeInfo ai, int item, int selMode, boolean selectWrite) {
        int curMode = 0;
        JLDataView dv = null;
        if (!ai.isNumeric() && selMode != 0) {
            Utils.showError(ai.name + "\nNot a numerical attribute");
            return false;
        }
        if (selMode == 3 && !ai.isArray()) {
            Utils.showError(ai.name + "\nNot an array attribute");
            return false;
        }
        if (item < 0) {
            if (selectWrite) {
                ai.wselection = selMode;
            } else {
                ai.selection = selMode;
            }
            if (selMode == 3) {
                this.selectImageItem(ai, selectWrite);
                return true;
            }
            if (!selectWrite) {
                curMode = ai.selection;
                dv = ai.chartData;
            } else {
                curMode = ai.wselection;
                dv = ai.wchartData;
            }
            if (dv == null) {
                return true;
            }
            dv.removeFromAxis();
            if (ai.errorData != null) {
                ai.errorData.removeFromAxis();
            }
            if (selMode == 1) {
                this.chartPanel.chart.getY1Axis().addDataView(dv);
                if (this.chartPanel.isShowingError()) {
                    this.chartPanel.chart.getY1Axis().addDataView(ai.errorData);
                }
            } else if (selMode == 2) {
                this.chartPanel.chart.getY2Axis().addDataView(dv);
                if (this.chartPanel.isShowingError()) {
                    this.chartPanel.chart.getY2Axis().addDataView(ai.errorData);
                }
            }
            this.chartPanel.chart.repaint();
            return true;
        }
        if (selMode == 3) {
            Utils.showError("Cannot display expanded item on image");
            return false;
        }
        ArrayAttributeInfo aai = ai.arrAttInfos.get(item);
        if (selectWrite) {
            aai.wselection = selMode;
        } else {
            aai.selection = selMode;
        }
        if (!selectWrite) {
            curMode = aai.selection;
            dv = aai.chartData;
        } else {
            curMode = aai.wselection;
            dv = aai.wchartData;
        }
        if (dv == null || dv.getDataLength() == 0) {
            if (ai.arrayData == null) {
                return true;
            }
            this.createDataviewExpanded(ai, item);
            dv = !selectWrite ? aai.chartData : aai.wchartData;
        }
        dv.removeFromAxis();
        if (selMode == 1) {
            this.chartPanel.chart.getY1Axis().addDataView(dv);
            if (this.chartPanel.isShowingError()) {
                // empty if block
            }
        } else if (selMode == 2) {
            this.chartPanel.chart.getY2Axis().addDataView(dv);
            if (this.chartPanel.isShowingError()) {
                // empty if block
            }
        }
        this.chartPanel.chart.repaint();
        return true;
    }

    private void createDataviewExpanded(AttributeInfo ai, int item) {
        boolean isRW = ai.isRW();
        HdbDataSet set = ai.arrayData;
        ArrayAttributeInfo aai = ai.arrAttInfos.get(item);
        Color c = defaultColor[this.dvIdx % defaultColor.length];
        if (aai.chartData == null) {
            aai.chartData = new JLDataView();
            aai.chartData.setColor(c);
            aai.chartData.setUnit(ai.unit);
        }
        aai.chartData.setName(ai.name + "[" + aai.idx + "]");
        ++this.dvIdx;
        if (isRW) {
            if (aai.wchartData == null) {
                aai.wchartData = new JLDataView();
                c = defaultColor[this.dvIdx % defaultColor.length];
                aai.wchartData.setColor(c);
                aai.wchartData.setUnit(ai.unit);
            }
            aai.wchartData.setName(ai.name + "_w[" + aai.idx + "]");
            ++this.dvIdx;
        }
        double lastValue = Double.NaN;
        double lastWriteValue = Double.NaN;
        for (int j = 0; j < set.size(); ++j) {
            HdbData d = set.get(j);
            double chartTime = (double)d.getDataTime() / 1000.0;
            try {
                if (aai.step) {
                    if (!Double.isNaN(lastValue)) {
                        aai.chartData.add(chartTime, lastValue);
                    }
                    if (aai.idx > d.size()) {
                        aai.chartData.add(chartTime, Double.NaN);
                        lastValue = Double.NaN;
                    } else {
                        lastValue = d.getValueAsDoubleArray()[aai.idx];
                        aai.chartData.add(chartTime, lastValue);
                    }
                    if (!isRW) continue;
                    if (!Double.isNaN(lastWriteValue)) {
                        aai.wchartData.add(chartTime, lastValue);
                    }
                    if (aai.idx > d.sizeW()) {
                        aai.wchartData.add(chartTime, Double.NaN);
                        lastWriteValue = Double.NaN;
                        continue;
                    }
                    lastWriteValue = d.getWriteValueAsDoubleArray()[aai.idx];
                    aai.wchartData.add(chartTime, lastWriteValue);
                    continue;
                }
                aai.chartData.add(chartTime, d.getValueAsDoubleArray()[aai.idx]);
                if (!isRW) continue;
                aai.wchartData.add(chartTime, d.getWriteValueAsDoubleArray()[aai.idx]);
                continue;
            }
            catch (HdbFailed e) {
                aai.chartData.add(chartTime, Double.NaN);
                if (isRW) {
                    aai.wchartData.add(chartTime, Double.NaN);
                }
                lastValue = Double.NaN;
                lastWriteValue = Double.NaN;
            }
        }
    }

    public void reset() {
        this.chartPanel.resetAll();
        this.tablePanel.table.reset();
        this.errorDialog.reset();
        if (this.selection != null) {
            for (AttributeInfo ai : this.selection) {
                if (ai.chartData != null) {
                    ai.chartData.reset();
                }
                if (ai.wchartData != null) {
                    ai.wchartData.reset();
                }
                ai.arrayData = null;
                if (ai.errorData != null) {
                    ai.errorData.reset();
                }
                if (!ai.isExpanded()) continue;
                for (ArrayAttributeInfo aai : ai.arrAttInfos) {
                    if (aai.chartData != null) {
                        aai.chartData.reset();
                    }
                    if (aai.wchartData == null) continue;
                    aai.wchartData.reset();
                }
            }
            int i = 0;
            while (i < this.selection.size()) {
                AttributeInfo ai;
                ai = this.selection.get(i);
                if (ai.sigInfo.sigId.startsWith("pyscript:")) {
                    this.selection.remove(i);
                    continue;
                }
                ++i;
            }
        }
        this.chartPanel.chart.repaint();
    }

    void saveConfigFile(String fileName) {
        try {
            FileWriter f = new FileWriter(fileName);
            f.write("HDBfile v1.0 {\n");
            f.write("  Global {\n");
            f.write("    script:\"" + this.selPanel.getPyScript() + "\"\n");
            f.write("    showError:" + Boolean.toString(this.chartPanel.isShowingError()) + "\n");
            f.write("    timeInterval:" + this.hdbTreePanel.getTimeInterval() + "\n");
            f.write("    hdbMode:" + this.hdbTreePanel.getHdbMode() + "\n");
            f.write("  }\n");
            for (AttributeInfo ai : this.selection) {
                f.write("  Attribute {\n");
                f.write("    host:\"" + ai.host + "\"\n");
                f.write("    name:\"" + ai.name + "\"\n");
                f.write("    step:" + Boolean.toString(ai.step) + "\n");
                f.write("    table:" + Boolean.toString(ai.table) + "\n");
                f.write("    selection:" + ai.selection + "\n");
                f.write("    wselection:" + ai.wselection + "\n");
                if (ai.isExpanded()) {
                    f.write("    expanded: {\n");
                    for (ArrayAttributeInfo aai : ai.arrAttInfos) {
                        f.write("    idx " + aai.idx + " {\n");
                        f.write("      step:" + Boolean.toString(aai.step) + "\n");
                        f.write("      table:" + Boolean.toString(aai.table) + "\n");
                        f.write("      selection:" + aai.selection + "\n");
                        f.write("      wselection:" + aai.wselection + "\n");
                        f.write("    }\n");
                    }
                    f.write("    }\n");
                }
                f.write("  }\n");
            }
            f.write("}\n");
            f.close();
        }
        catch (IOException e) {
            Utils.showError("Cannot save file !\n" + e.getMessage());
        }
    }

    public void setVisiblePanel(boolean showTree, boolean showSelection, boolean showViews) {
        if (!showTree) {
            this.closePanel(this.hdbTreeDockedPanel);
        }
        if (!showSelection) {
            this.closePanel(this.selDockedPanel);
        }
        if (!showViews) {
            this.closePanel(this.viewDockedPanel);
        }
        this.viewDataviewCheckBoxMenuItem.setSelected(showTree);
        this.viewQueryCheckBoxMenuItem.setSelected(showSelection);
        this.viewSelectCheckBoxMenuItem.setSelected(showViews);
        this.updateDockedView();
    }

    public void setVisibleView(int which) {
        this.viewDockedPanel.selectPanel(which);
    }

    public void loadSelectionFile(String fileName) {
        this.selPanel.loadFile(fileName);
    }

    public void performSearch() {
        int i;
        final String startDate = this.hdbTreePanel.getStartDate();
        final String stopDate = this.hdbTreePanel.getStopDate();
        String[] colNames = null;
        this.reset();
        Thread doSearch = new Thread(){

            @Override
            public void run() {
                int i;
                try {
                    Thread.sleep(150L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                HdbSigInfo[] sigIn = new HdbSigInfo[MainPanel.this.selection.size()];
                for (i = 0; i < sigIn.length; ++i) {
                    sigIn[i] = MainPanel.this.selection.get((int)i).sigInfo;
                }
                try {
                    MainPanel.this.startR = System.currentTimeMillis();
                    MainPanel.this.results = MainPanel.this.hdb.getReader().getData(sigIn, startDate, stopDate, MainPanel.this.hdbTreePanel.getHdbMode());
                    MainPanel.this.stopR = System.currentTimeMillis();
                    MainPanel.this.infoDialog.addText("Request time=" + (MainPanel.this.stopR - MainPanel.this.startR) + " ms");
                    for (i = 0; i < sigIn.length; ++i) {
                        try {
                            HdbSigParam p = MainPanel.this.hdb.getReader().getLastParam(sigIn[i].name);
                            MainPanel.this.selection.get((int)i).unit = p.unit;
                            try {
                                MainPanel.this.selection.get((int)i).A1 = p.display_unit;
                            }
                            catch (NumberFormatException e) {
                                MainPanel.this.infoDialog.addText("Warning: " + e.getMessage());
                            }
                            continue;
                        }
                        catch (HdbFailed e) {
                            MainPanel.this.infoDialog.addText("Warning: " + e.getMessage());
                        }
                    }
                    for (i = 0; i < sigIn.length; ++i) {
                        double A1 = MainPanel.this.selection.get((int)i).A1;
                        if (A1 == 1.0) continue;
                        MainPanel.this.results[i].applyConversionFactor(A1);
                    }
                    if (!MainPanel.this.selPanel.getPyScript().isEmpty()) {
                        int i2;
                        MainPanel.this.searchDlg.setTitle("Running python");
                        long t0 = System.currentTimeMillis();
                        PythonScript s = new PythonScript(MainPanel.this.selPanel.getPyScript());
                        HdbDataSet[] pyResults = s.run(MainPanel.this.results);
                        HdbDataSet[] newResults = new HdbDataSet[MainPanel.this.results.length + pyResults.length];
                        for (i2 = 0; i2 < MainPanel.this.results.length; ++i2) {
                            newResults[i2] = MainPanel.this.results[i2];
                        }
                        for (i2 = 0; i2 < pyResults.length; ++i2) {
                            newResults[MainPanel.this.results.length + i2] = pyResults[i2];
                            AttributeInfo ai = new AttributeInfo();
                            ai.host = "pyscript";
                            ai.name = pyResults[i2].getName();
                            ai.table = true;
                            int type = pyResults[i2].getType();
                            if (type <= 0 || type > 56) {
                                throw new HdbFailed("Wrong type code " + type);
                            }
                            ai.type = HdbSigInfo.typeStr[type].substring(5).toLowerCase();
                            HdbSigInfo dummySi = new HdbSigInfo();
                            dummySi.name = ai.name;
                            dummySi.type = type;
                            dummySi.sigId = ai.host + ":" + ai.name;
                            ai.sigInfo = dummySi;
                            MainPanel.this.selection.add(ai);
                        }
                        MainPanel.this.results = newResults;
                        long t1 = System.currentTimeMillis();
                        MainPanel.this.infoDialog.addText("Script time=" + (t1 - t0) + " ms");
                    }
                }
                catch (HdbFailed e) {
                    Utils.showError("HDB getData failed\n" + e.getMessage());
                }
                catch (Exception e2) {
                    Utils.showError("HDB getData failed\nUnexpected exception " + e2);
                    e2.printStackTrace();
                }
                MainPanel.this.searchDlg.hideDlg();
            }
        };
        Date rDate = new Date();
        rDate.setTime(System.currentTimeMillis());
        this.infoDialog.addText("-------------------------------------------------------");
        this.infoDialog.addText("Launch request on " + this.hdb.getDBTypeName() + " at " + Hdb.hdbDateFormat.format(rDate));
        this.infoDialog.addText("Attribute number: " + this.selection.size());
        this.infoDialog.addText("Start: " + startDate);
        this.infoDialog.addText("Stop: " + stopDate);
        this.results = null;
        boolean hasProgress = this.hdb.getDBType() != 3;
        this.searchDlg = this.isVisible() ? new ThreadDlg((Frame)this, "Fetching HDB data", hasProgress, doSearch) : new ThreadDlg(null, "Fetching HDB data", hasProgress, doSearch);
        this.searchDlg.showDlg();
        try {
            doSearch.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        doSearch = null;
        if (this.results == null) {
            return;
        }
        int nbTable = 0;
        int colIdx = 1;
        this.dvIdx = 0;
        int nbData = 0;
        int nbError = 0;
        for (AttributeInfo ai : this.selection) {
            if (ai.table) {
                ++nbTable;
            }
            if (ai.isRW()) {
                ++nbTable;
            }
            if (!ai.isExpanded()) continue;
            for (ArrayAttributeInfo aai : ai.arrAttInfos) {
                if (aai.table) {
                    ++nbTable;
                }
                if (!ai.isRW()) continue;
                ++nbTable;
            }
        }
        if (nbTable > 0) {
            colNames = new String[1 + nbTable];
            colNames[0] = "Time";
        } else {
            colNames = new String[]{};
        }
        this.imagePanel.updateImageSelection = true;
        boolean hasChart = false;
        boolean hasTable = false;
        boolean hasImage = false;
        for (int i2 = 0; i2 < this.results.length; ++i2) {
            AttributeInfo ai = this.selection.get(i2);
            boolean isRW = ai.isRW();
            ai.dataSize = 0;
            ai.errorSize = 0;
            if (ai.isNumeric() && !ai.isArray()) {
                if (ai.selection != 0 || ai.wselection != 0) {
                    hasChart = true;
                }
                Color c = defaultColor[this.dvIdx % defaultColor.length];
                if (ai.chartData == null) {
                    ai.chartData = new JLDataView();
                    ai.chartData.setColor(c);
                    ai.chartData.setUnit(ai.unit);
                }
                ai.chartData.setName(ai.name);
                if (ai.errorData == null) {
                    ai.errorData = new JLDataView();
                    ai.errorData.setLineWidth(0);
                    ai.errorData.setMarker(1);
                    ai.errorData.setLabelVisible(false);
                    ai.errorData.setMarkerColor(c.darker());
                }
                ai.errorData.setName(ai.name + "_error");
                ai.errors = new ArrayList();
                ++this.dvIdx;
                if (isRW) {
                    if (ai.wchartData == null) {
                        ai.wchartData = new JLDataView();
                        ai.wchartData.setColor(defaultColor[this.dvIdx % defaultColor.length]);
                        ai.wchartData.setUnit(ai.unit);
                    }
                    ai.wchartData.setName(ai.name + "_w");
                    ++this.dvIdx;
                }
                double lastValueForError = 0.0;
                double lastValue = Double.NaN;
                double lastWriteValue = Double.NaN;
                for (int j = 0; j < this.results[i2].size(); ++j) {
                    HdbData d = this.results[i2].get(j);
                    double chartTime = (double)d.getDataTime() / 1000.0;
                    try {
                        lastValueForError = d.getValueAsDouble();
                        if (ai.step) {
                            if (!Double.isNaN(lastValue)) {
                                ai.chartData.add(chartTime, lastValue);
                            }
                            ai.chartData.add(chartTime, d.getValueAsDouble());
                            lastValue = d.getValueAsDouble();
                            if (!isRW) continue;
                            if (!Double.isNaN(lastWriteValue)) {
                                ai.wchartData.add(chartTime, lastWriteValue);
                            }
                            ai.wchartData.add(chartTime, d.getWriteValueAsDouble());
                            lastWriteValue = d.getWriteValueAsDouble();
                            continue;
                        }
                        ai.chartData.add(chartTime, d.getValueAsDouble());
                        if (!isRW) continue;
                        ai.wchartData.add(chartTime, d.getWriteValueAsDouble());
                        continue;
                    }
                    catch (HdbFailed e) {
                        ai.chartData.add(chartTime, Double.NaN);
                        if (isRW) {
                            ai.wchartData.add(chartTime, Double.NaN);
                        }
                        ai.errorData.add(chartTime, lastValueForError);
                        ai.errors.add(d);
                        lastValue = Double.NaN;
                        lastWriteValue = Double.NaN;
                    }
                }
            }
            if (ai.table) {
                hasTable = true;
                colNames[colIdx] = ai.name + " (" + ai.unit + ")";
                if (isRW) {
                    colNames[colIdx + 1] = ai.name + "_w" + " (" + ai.unit + ")";
                }
                for (int j = 0; j < this.results[i2].size(); ++j) {
                    HdbData d = this.results[i2].get(j);
                    if (d.hasFailed()) {
                        String err = "/Err" + d.getErrorMessage();
                        this.tablePanel.table.add(err, d.getDataTime(), colIdx);
                        if (!isRW) continue;
                        this.tablePanel.table.add(err, d.getDataTime(), colIdx + 1);
                        continue;
                    }
                    if (ai.isState()) {
                        this.tablePanel.table.add("/State" + d.getValueAsString(), d.getDataTime(), colIdx);
                        if (!isRW) continue;
                        this.tablePanel.table.add("/State" + d.getWriteValueAsString(), d.getDataTime(), colIdx + 1);
                        continue;
                    }
                    this.tablePanel.table.add(d.getValueAsString(), d.getDataTime(), colIdx);
                    if (!isRW) continue;
                    this.tablePanel.table.add(d.getWriteValueAsString(), d.getDataTime(), colIdx + 1);
                }
                ++colIdx;
                if (isRW) {
                    ++colIdx;
                }
            }
            if (ai.isExpanded()) {
                for (ArrayAttributeInfo aai : ai.arrAttInfos) {
                    if (!aai.table) continue;
                    hasTable = true;
                    int idx = aai.idx;
                    colNames[colIdx] = ai.name + "[" + aai.idx + "] " + "(" + ai.unit + ")";
                    if (isRW) {
                        colNames[colIdx + 1] = ai.name + "_w[" + aai.idx + "] " + "(" + ai.unit + ")";
                    }
                    for (int j = 0; j < this.results[i2].size(); ++j) {
                        String err;
                        HdbData d = this.results[i2].get(j);
                        if (d.hasFailed()) {
                            err = "/Err" + d.getErrorMessage();
                            this.tablePanel.table.add(err, d.getDataTime(), colIdx);
                            if (!isRW) continue;
                            this.tablePanel.table.add(err, d.getDataTime(), colIdx + 1);
                            continue;
                        }
                        if (idx >= d.size()) {
                            err = "/ErrIndex out of bounds";
                            this.tablePanel.table.add(err, d.getDataTime(), colIdx);
                            if (!isRW) continue;
                            this.tablePanel.table.add(err, d.getDataTime(), colIdx + 1);
                            continue;
                        }
                        try {
                            String value;
                            String valueW = "";
                            if (ai.isState()) {
                                HdbStateArray hdbV = (HdbStateArray)d;
                                value = "/State" + HdbState.getStateString((int)hdbV.getValue()[idx]);
                                if (isRW && idx < d.sizeW()) {
                                    valueW = "/State" + HdbState.getStateString((int)hdbV.getWriteValue()[idx]);
                                }
                            } else if (d instanceof HdbFloatArray) {
                                HdbFloatArray hdbV = (HdbFloatArray)d;
                                value = Float.toString(hdbV.getValue()[idx]);
                                if (isRW && idx < d.sizeW()) {
                                    valueW = Float.toString(hdbV.getWriteValue()[idx]);
                                }
                            } else if (d instanceof HdbLongArray) {
                                HdbLongArray hdbV = (HdbLongArray)d;
                                value = Integer.toString(hdbV.getValue()[idx]);
                                if (isRW && idx < d.sizeW()) {
                                    valueW = Float.toString(hdbV.getWriteValue()[idx]);
                                }
                            } else if (d instanceof HdbLong64Array) {
                                HdbLong64Array hdbV = (HdbLong64Array)d;
                                value = Long.toString(hdbV.getValue()[idx]);
                                if (isRW && idx < d.sizeW()) {
                                    valueW = Float.toString(hdbV.getWriteValue()[idx]);
                                }
                            } else if (d instanceof HdbShortArray) {
                                HdbShortArray hdbV = (HdbShortArray)d;
                                value = Short.toString(hdbV.getValue()[idx]);
                                if (isRW && idx < d.sizeW()) {
                                    valueW = Float.toString(hdbV.getWriteValue()[idx]);
                                }
                            } else {
                                value = Double.toString(d.getValueAsDoubleArray()[idx]);
                                if (isRW && idx < d.sizeW()) {
                                    valueW = Double.toString(d.getWriteValueAsDoubleArray()[idx]);
                                }
                            }
                            this.tablePanel.table.add(value, d.getDataTime(), colIdx);
                            if (!isRW) continue;
                            this.tablePanel.table.add(valueW, d.getDataTime(), colIdx + 1);
                            continue;
                        }
                        catch (HdbFailed e) {
                            // empty catch block
                        }
                    }
                    ++colIdx;
                    if (!isRW) continue;
                    ++colIdx;
                }
            }
            if (ai.isNumeric() && ai.isArray()) {
                hasImage = hasImage || ai.selection == 3;
                ai.arrayData = this.results[i2];
                ai.maxArraySize = -1;
                for (int k = 0; k < this.results[i2].size(); ++k) {
                    if (this.results[i2].get(k).size() <= ai.maxArraySize) continue;
                    ai.maxArraySize = this.results[i2].get(k).size();
                }
            }
            for (int j = 0; j < this.results[i2].size(); ++j) {
                HdbData d = this.results[i2].get(j);
                if (d.hasFailed()) {
                    this.errorDialog.addError(ai.name, d);
                    ++ai.errorSize;
                    ++nbError;
                    continue;
                }
                ++ai.dataSize;
                ++nbData;
            }
        }
        this.infoDialog.addText("Total data=" + nbData);
        this.infoDialog.addText("Total error=" + nbError);
        for (AttributeInfo ai : this.selection) {
            this.selectAttribute(ai, -1, ai.selection, false);
            if (ai.isRW()) {
                this.selectAttribute(ai, -1, ai.wselection, true);
            }
            if (!ai.isExpanded()) continue;
            for (i = 0; i < ai.arrAttInfos.size(); ++i) {
                ArrayAttributeInfo aai = ai.arrAttInfos.get(i);
                this.selectAttribute(ai, i, aai.selection, false);
                if (!ai.isRW()) continue;
                this.selectAttribute(ai, i, aai.wselection, true);
            }
        }
        this.tablePanel.table.setColumnName(colNames);
        this.tablePanel.table.dataChanged();
        this.errorDialog.commit();
        this.chartPanel.resetXItem();
        for (AttributeInfo ai : this.selection) {
            ArrayAttributeInfo aai;
            if (ai.isNumeric()) {
                if (ai.isArray()) {
                    if (ai.isExpanded()) {
                        for (i = 0; i < ai.arrAttInfos.size(); ++i) {
                            aai = ai.arrAttInfos.get(i);
                            this.chartPanel.addXArrayItem(ai, aai);
                        }
                    }
                } else {
                    this.chartPanel.addXItem(ai);
                }
            }
            this.selectAttribute(ai, -1, ai.selection, false);
            if (ai.isRW()) {
                this.selectAttribute(ai, -1, ai.wselection, true);
            }
            if (!ai.isExpanded()) continue;
            for (i = 0; i < ai.arrAttInfos.size(); ++i) {
                aai = ai.arrAttInfos.get(i);
                this.selectAttribute(ai, i, aai.selection, false);
                if (!ai.isRW()) continue;
                this.selectAttribute(ai, i, aai.wselection, true);
            }
        }
        if (hasChart) {
            this.viewDockedPanel.selectPanel(0);
        } else if (hasImage) {
            this.viewDockedPanel.selectPanel(2);
        } else if (hasTable) {
            this.viewDockedPanel.selectPanel(1);
        }
        this.imagePanel.updateImageSelection = false;
    }

    void updateSelectionList() {
        this.selPanel.updateSelectionList();
    }

    public String[] clickOnChart(JLChartEvent jlce) {
        JLDataView srcDataView = jlce.getDataView();
        boolean foundE = false;
        boolean foundR = false;
        boolean foundW = false;
        int i = 0;
        while (!(foundE || foundR || foundW || i >= this.selection.size())) {
            foundE = this.selection.get((int)i).errorData == srcDataView;
            foundR = this.selection.get((int)i).chartData == srcDataView;
            boolean bl = foundW = this.selection.get((int)i).wchartData == srcDataView;
            if (foundE || foundR || foundW) continue;
            ++i;
        }
        if (!(foundE || foundR || foundW)) {
            return null;
        }
        AttributeInfo ai = this.selection.get(i);
        if (foundE) {
            int idx = jlce.getDataViewIndex();
            String[] errors = Utils.makeStringArray(ai.errors.get(idx).getErrorMessage());
            String[] ret = new String[2 + errors.length];
            ret[0] = ai.name;
            ret[1] = Utils.formatTime((long)(jlce.getXValue() * 1000.0), 2);
            for (int j = 0; j < errors.length; ++j) {
                ret[2 + j] = errors[j];
            }
            return ret;
        }
        if (ai.isState()) {
            String[] ret = new String[]{foundR ? ai.name : ai.name + "_w", Utils.formatTime((long)(jlce.getXValue() * 1000.0), 2), HdbState.getStateString((int)((int)(jlce.getYValue() + 0.5)))};
            return ret;
        }
        return null;
    }

    void buildImageData() {
        double[][] data;
        long[] times;
        HdbDataSet hdbSet = this.selectedImage.arrayData;
        boolean showError = this.imagePanel.imageErrorCheck.isSelected();
        boolean isW = this.selectedImageRW;
        this.imagePanel.nameLabel.setText(this.selectedImage.name + (this.selectedImageRW ? "_w" : ""));
        int lgth = hdbSet == null ? 0 : hdbSet.size();
        if (lgth == 0) {
            this.imagePanel.image.clearData();
            return;
        }
        int lgthNoError = 0;
        for (int i = 0; i < lgth; ++i) {
            if (hdbSet.get(i).hasFailed()) continue;
            ++lgthNoError;
        }
        if (showError) {
            times = new long[lgth];
            data = new double[lgth][];
        } else {
            times = new long[lgthNoError];
            data = new double[lgthNoError][];
        }
        int k = 0;
        for (int i = 0; i < lgth; ++i) {
            if (showError) {
                times[k] = hdbSet.get(i).getDataTime() / 1000L;
                try {
                    data[k] = isW ? hdbSet.get(i).getWriteValueAsDoubleArray() : hdbSet.get(i).getValueAsDoubleArray();
                }
                catch (HdbFailed e) {
                    data[k] = new double[0];
                }
                ++k;
                continue;
            }
            if (hdbSet.get(i).hasFailed()) continue;
            times[k] = hdbSet.get(i).getDataTime() / 1000L;
            try {
                data[k] = isW ? hdbSet.get(i).getWriteValueAsDoubleArray() : hdbSet.get(i).getValueAsDoubleArray();
            }
            catch (HdbFailed e) {
                data[k] = new double[0];
            }
            ++k;
        }
        this.imagePanel.image.setData(times, (double[][])data);
    }

    void selectImageItem(AttributeInfo ai, boolean selectWrite) {
        this.selectedImage = ai;
        this.selectedImageRW = selectWrite;
        this.buildImageData();
    }

    void updateDockedView() {
        if (!this.viewDockedPanel.visible && !this.hdbTreeDockedPanel.visible) {
            this.hSplitPane.setTopComponent(null);
        } else {
            this.hSplitPane.setTopComponent(this.vSplitPane);
        }
        this.viewDataviewCheckBoxMenuItem.setSelected(this.viewDockedPanel.visible);
        this.viewQueryCheckBoxMenuItem.setSelected(this.hdbTreeDockedPanel.visible);
        this.viewSelectCheckBoxMenuItem.setSelected(this.selDockedPanel.visible);
    }

    void viewPanel(DockedPanel panel) {
        if (panel == this.viewDockedPanel) {
            this.vSplitPane.setRightComponent(this.viewDockedPanel);
            this.viewDockedPanel.visible = true;
        } else if (panel == this.hdbTreeDockedPanel) {
            this.vSplitPane.setLeftComponent(this.hdbTreeDockedPanel);
            this.hdbTreeDockedPanel.visible = true;
        } else if (panel == this.selDockedPanel) {
            this.hSplitPane.setBottomComponent(this.selDockedPanel);
            this.selDockedPanel.visible = true;
        }
        this.updateDockedView();
    }

    void closePanel(DockedPanel panel) {
        if (panel == this.viewDockedPanel) {
            this.vSplitPane.setRightComponent(null);
            this.viewDockedPanel.visible = false;
        } else if (panel == this.hdbTreeDockedPanel) {
            this.vSplitPane.setLeftComponent(null);
            this.hdbTreeDockedPanel.visible = false;
        } else if (panel == this.selDockedPanel) {
            this.hSplitPane.setBottomComponent(null);
            this.selDockedPanel.visible = false;
        }
        this.updateDockedView();
    }

    void minimizePanel(DockedPanel panel) {
        JPanel p = (JPanel)this.getContentPane();
        p.remove(panel);
        p.add((Component)this.hSplitPane, "Center");
        this.viewPanel(panel);
        this.viewDataviewCheckBoxMenuItem.setEnabled(true);
        this.viewQueryCheckBoxMenuItem.setEnabled(true);
        this.viewSelectCheckBoxMenuItem.setEnabled(true);
    }

    void maximizePanel(DockedPanel panel) {
        JPanel p = (JPanel)this.getContentPane();
        p.remove(this.hSplitPane);
        p.add((Component)panel, "Center");
        ((JPanel)this.getContentPane()).revalidate();
        this.viewDataviewCheckBoxMenuItem.setEnabled(false);
        this.viewQueryCheckBoxMenuItem.setEnabled(false);
        this.viewSelectCheckBoxMenuItem.setEnabled(false);
    }

    private void initComponents() {
        this.hSplitPane = new JSplitPane();
        this.vSplitPane = new JSplitPane();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.errorsMenuItem = new JMenuItem();
        this.infoMenuItem = new JMenuItem();
        this.viewDataviewCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.viewQueryCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.viewSelectCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.setDefaultCloseOperation(3);
        this.hSplitPane.setDividerSize(5);
        this.hSplitPane.setOrientation(0);
        this.vSplitPane.setDividerSize(5);
        this.hSplitPane.setLeftComponent(this.vSplitPane);
        this.getContentPane().add((Component)this.hSplitPane, "Center");
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.errorsMenuItem.setText("Errors ...");
        this.errorsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.errorsMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.errorsMenuItem);
        this.infoMenuItem.setText("Informations ...");
        this.infoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.infoMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.infoMenuItem);
        this.viewDataviewCheckBoxMenuItem.setSelected(true);
        this.viewDataviewCheckBoxMenuItem.setText("Dataviews");
        this.viewDataviewCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewDataviewCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewDataviewCheckBoxMenuItem);
        this.viewQueryCheckBoxMenuItem.setSelected(true);
        this.viewQueryCheckBoxMenuItem.setText("HDB Tree");
        this.viewQueryCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewQueryCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewQueryCheckBoxMenuItem);
        this.viewSelectCheckBoxMenuItem.setSelected(true);
        this.viewSelectCheckBoxMenuItem.setText("Selection table");
        this.viewSelectCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewSelectCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewSelectCheckBoxMenuItem);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.runningFromShell) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void errorsMenuItemActionPerformed(ActionEvent evt) {
        ATKGraphicsUtils.centerFrame((JComponent)((JPanel)this.getContentPane()), (Frame)this.errorDialog);
        this.errorDialog.setVisible(true);
    }

    private void viewQueryCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.viewQueryCheckBoxMenuItem.isSelected()) {
            this.viewPanel(this.hdbTreeDockedPanel);
        } else {
            this.closePanel(this.hdbTreeDockedPanel);
        }
    }

    private void viewDataviewCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.viewDataviewCheckBoxMenuItem.isSelected()) {
            this.viewPanel(this.viewDockedPanel);
        } else {
            this.closePanel(this.viewDockedPanel);
        }
    }

    private void viewSelectCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.viewSelectCheckBoxMenuItem.isSelected()) {
            this.viewPanel(this.selDockedPanel);
        } else {
            this.closePanel(this.selDockedPanel);
        }
    }

    private void infoMenuItemActionPerformed(ActionEvent evt) {
        ATKGraphicsUtils.centerFrame((JComponent)((JPanel)this.getContentPane()), (Frame)this.infoDialog);
        this.infoDialog.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new MainPanel().setVisible(true);
        } else {
            if (args.length % 2 != 0) {
                System.out.println("Invalid options");
                System.out.println("Usage jhdbviewer [-f filename] [-p (panel=tree|sel|view)] -[v view]");
                System.exit(0);
            }
            MainPanel p = new MainPanel(true, true);
            for (int i = 0; i < args.length; i += 2) {
                if (args[i].equals("-f")) {
                    String fileName = args[i + 1];
                    p.loadSelectionFile(fileName);
                    continue;
                }
                if (args[i].equals("-p")) {
                    int panel = Integer.parseInt(args[i + 1]);
                    boolean tree = (panel & 4) != 0;
                    boolean select = (panel & 2) != 0;
                    boolean views = (panel & 1) != 0;
                    p.setVisiblePanel(tree, select, views);
                    continue;
                }
                if (args[i].equals("-v")) {
                    int view = Integer.parseInt(args[i + 1]);
                    p.setVisibleView(view);
                    continue;
                }
                System.out.println("Unknown option " + args[i]);
                System.out.print("Usage jhdbviewer [-f selection_filename] [-p (panel=tree|sel|view)] -[v view]");
                System.exit(0);
            }
            p.performSearch();
            p.setVisible(true);
        }
    }

    public void progress(HdbReader reader, double d, int current, int nb) {
        if (this.searchDlg != null) {
            if (nb > 1) {
                this.searchDlg.setProgress(d, current + "/" + nb);
            } else {
                this.searchDlg.setProgress(d, null);
            }
        }
    }
}

