/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.AttributeInfo;
import HDBViewer.AttributeTree.TreeListener;
import HDBViewer.AttributeTree.TreePanel;
import HDBViewer.MainPanel;
import HDBViewer.Utils;
import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JSpinnerDateEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;

public class HDBTreePanel
extends JPanel
implements ActionListener,
TreeListener {
    MainPanel parent;
    JSpinnerDateEditor s0;
    JSpinnerDateEditor s1;
    TreePanel treePanel;
    private JButton backButton;
    private JButton forwardButton;
    JComboBox hdbModeCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox lastTimeCombo;
    private JPanel rightPanel;
    private JButton searchButton;
    private JPanel selPanel;
    private JDateChooser startDateChooser;
    private JDateChooser stopDateChooser;
    private JPanel treeBtnPanel;

    HDBTreePanel(MainPanel parent) {
        this.parent = parent;
        this.s0 = new JSpinnerDateEditor();
        ((JSpinner.DefaultEditor)this.s0.getEditor()).getTextField().setHorizontalAlignment(2);
        this.s1 = new JSpinnerDateEditor();
        ((JSpinner.DefaultEditor)this.s1.getEditor()).getTextField().setHorizontalAlignment(2);
        this.initComponents();
        this.treePanel = new TreePanel(parent.hdb.getReader());
        this.treePanel.addTreeListener(this);
        this.rightPanel.add((Component)this.treePanel, "Center");
        this.lastTimeCombo.setEditable(false);
        this.lastTimeCombo.removeAllItems();
        this.lastTimeCombo.addItem("Last 1 hour");
        this.lastTimeCombo.addItem("Last 4 hour");
        this.lastTimeCombo.addItem("Last 8 hour");
        this.lastTimeCombo.addItem("Last day");
        this.lastTimeCombo.addItem("Last week");
        this.lastTimeCombo.addItem("Last month");
        this.lastTimeCombo.setSelectedIndex(2);
        this.lastTimeCombo.addActionListener(this);
        long now = System.currentTimeMillis();
        this.startDateChooser.setDate(new Date(now - 28800000L));
        this.stopDateChooser.setDate(new Date(now));
    }

    String getStartDate() {
        String d = ((JSpinner.DefaultEditor)this.s0.getEditor()).getTextField().getText();
        return d;
    }

    String getStopDate() {
        String d = ((JSpinner.DefaultEditor)this.s1.getEditor()).getTextField().getText();
        return d;
    }

    void setDate(long start, long stop) {
        this.startDateChooser.setDate(new Date(start));
        this.stopDateChooser.setDate(new Date(stop));
    }

    void setTimeInterval(int it) {
        this.lastTimeCombo.setSelectedIndex(it);
    }

    int getTimeInterval() {
        return this.lastTimeCombo.getSelectedIndex();
    }

    long getStepDuration() {
        int idx = this.lastTimeCombo.getSelectedIndex();
        long time = 0L;
        switch (idx) {
            case 0: {
                time = 3600L;
                break;
            }
            case 1: {
                time = 14400L;
                break;
            }
            case 2: {
                time = 28800L;
                break;
            }
            case 3: {
                time = 86400L;
                break;
            }
            case 4: {
                time = 604800L;
                break;
            }
            case 5: {
                time = 2592000L;
            }
        }
        return time;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.lastTimeCombo) {
            long time = this.getStepDuration();
            long now = System.currentTimeMillis();
            this.startDateChooser.setDate(new Date(now - time * 1000L));
            this.stopDateChooser.setDate(new Date(now));
        }
    }

    @Override
    public void attributeAction(TreePanel source, ArrayList<AttributeInfo> list) {
        try {
            int i;
            for (i = 0; i < list.size(); ++i) {
                HdbSigInfo si = this.parent.hdb.getReader().getSigInfo(list.get(i).getFullName());
                list.get((int)i).type = HdbSigInfo.typeStr[si.type].substring(5).toLowerCase();
                list.get((int)i).sigInfo = si;
            }
            for (i = 0; i < list.size(); ++i) {
                AttributeInfo ai = list.get(i);
                if (AttributeInfo.isInList(ai, this.parent.selection)) continue;
                if (ai.isString()) {
                    ai.table = true;
                }
                if (ai.isNumeric() && !ai.isArray()) {
                    ai.selection = 1;
                }
                if (ai.isState() && !ai.isArray()) {
                    ai.step = true;
                }
                this.parent.selection.add(ai);
            }
            this.parent.updateSelectionList();
        }
        catch (HdbFailed e) {
            Utils.showError(e.getMessage());
        }
    }

    int getHdbMode() {
        return this.hdbModeCombo.getSelectedIndex();
    }

    void setHdbMode(int mode) {
        this.hdbModeCombo.setSelectedIndex(mode);
    }

    private void moveDate(long step) {
        long start = this.startDateChooser.getDate().getTime();
        long stop = this.stopDateChooser.getDate().getTime();
        this.startDateChooser.setDate(new Date(start += step * 1000L));
        this.stopDateChooser.setDate(new Date(stop += step * 1000L));
        this.parent.performSearch();
        this.parent.selPanel.updateSelectionList();
    }

    private void initComponents() {
        this.treeBtnPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.selPanel = new JPanel();
        this.startDateChooser = new JDateChooser(null, null, "HH:mm:ss  dd/MM/yyyy", (IDateEditor)this.s0);
        this.stopDateChooser = new JDateChooser(null, null, "HH:mm:ss  dd/MM/yyyy", (IDateEditor)this.s1);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.hdbModeCombo = new JComboBox();
        this.searchButton = new JButton();
        this.lastTimeCombo = new JComboBox();
        this.forwardButton = new JButton();
        this.backButton = new JButton();
        this.setLayout(new BorderLayout());
        this.treeBtnPanel.setLayout(new BorderLayout());
        this.rightPanel.setLayout(new BorderLayout());
        this.treeBtnPanel.add((Component)this.rightPanel, "Center");
        this.add((Component)this.treeBtnPanel, "Center");
        this.selPanel.setBorder(BorderFactory.createTitledBorder(null, "HDB Search", 0, 0, new Font("Dialog", 0, 10)));
        this.selPanel.setMinimumSize(new Dimension(0, 0));
        this.selPanel.setPreferredSize(new Dimension(270, 165));
        this.selPanel.setLayout(null);
        this.startDateChooser.setDateFormatString("dd/MM/yyyy HH:mm:ss");
        this.startDateChooser.setFont(new Font("Monospaced", 0, 12));
        this.selPanel.add((Component)this.startDateChooser);
        this.startDateChooser.setBounds(60, 15, 200, 25);
        this.stopDateChooser.setDateFormatString("dd/MM/yyyy HH:mm:ss");
        this.stopDateChooser.setFont(new Font("Monospaced", 0, 12));
        this.selPanel.add((Component)this.stopDateChooser);
        this.stopDateChooser.setBounds(60, 45, 200, 25);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Stop");
        this.selPanel.add(this.jLabel1);
        this.jLabel1.setBounds(10, 50, 45, 15);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText("Start");
        this.selPanel.add(this.jLabel2);
        this.jLabel2.setBounds(10, 20, 45, 15);
        this.hdbModeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal", "Ignore errors", "Filled", "Correlated"}));
        this.hdbModeCombo.setToolTipText("Select HDB extraction mode");
        this.selPanel.add(this.hdbModeCombo);
        this.hdbModeCombo.setBounds(10, 135, 120, 25);
        this.searchButton.setFont(new Font("Dialog", 0, 12));
        this.searchButton.setText("Perform search");
        this.searchButton.setToolTipText("Fetch data from HDB");
        this.searchButton.setMargin(new Insets(2, 5, 2, 5));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HDBTreePanel.this.searchButtonActionPerformed(evt);
            }
        });
        this.selPanel.add(this.searchButton);
        this.searchButton.setBounds(135, 135, 125, 25);
        this.lastTimeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lastTimeCombo.setSelectedIndex(-1);
        this.selPanel.add(this.lastTimeCombo);
        this.lastTimeCombo.setBounds(10, 75, 250, 24);
        this.forwardButton.setFont(new Font("Dialog", 0, 12));
        this.forwardButton.setText(">>");
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HDBTreePanel.this.forwardButtonActionPerformed(evt);
            }
        });
        this.selPanel.add(this.forwardButton);
        this.forwardButton.setBounds(135, 105, 125, 25);
        this.backButton.setFont(new Font("Dialog", 0, 12));
        this.backButton.setText("<<");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HDBTreePanel.this.backButtonActionPerformed(evt);
            }
        });
        this.selPanel.add(this.backButton);
        this.backButton.setBounds(10, 105, 120, 25);
        this.add((Component)this.selPanel, "South");
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.parent.performSearch();
        this.parent.selPanel.updateSelectionList();
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        this.moveDate(this.getStepDuration());
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.moveDate(-this.getStepDuration());
    }
}

