/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.ArrayAttributeInfo;
import HDBViewer.AttributeInfo;
import HDBViewer.MainPanel;
import HDBViewer.XAxisItem;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ChartPanel
extends JPanel
implements ActionListener {
    JLChart chart;
    MainPanel parent;
    boolean updateXCombo = false;
    private JPanel chartBtnPanel;
    JCheckBox chartErrorCheck;
    private JPanel chartPanel;
    private JLabel jLabel1;
    private JCheckBox onlyErrorCheck;
    private JCheckBox showGridCheckBox;
    private JCheckBox showLegendCheckBox;
    private JComboBox xViewCombo;

    ChartPanel(MainPanel parent) {
        this.parent = parent;
        this.initComponents();
        this.chart = new JLChart();
        this.chart.setPreferredSize(new Dimension(800, 600));
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY2Axis().setAutoScale(true);
        this.chart.getXAxis().setAnnotation(1);
        long now = System.currentTimeMillis();
        this.chart.getXAxis().setAutoScale(false);
        this.chart.getXAxis().setMinimum((double)(now - 3600000L));
        this.chart.getXAxis().setMaximum((double)now);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.setJLChartListener((IJLChartListener)parent);
        this.chartPanel.add((Component)this.chart, "Center");
        this.xViewCombo.removeAllItems();
        this.xViewCombo.addItem(new XAxisItem());
        this.xViewCombo.addActionListener(this);
    }

    public boolean isShowingError() {
        return this.chartErrorCheck.isSelected();
    }

    public void setShowError(boolean show) {
        this.chartErrorCheck.setSelected(show);
        this.updateShowError();
    }

    private void updateClickableError() {
        boolean b = this.onlyErrorCheck.isSelected();
        for (AttributeInfo ai : this.parent.selection) {
            if (ai.chartData != null) {
                ai.chartData.setClickable(!b);
            }
            if (ai.wchartData == null) continue;
            ai.wchartData.setClickable(!b);
        }
    }

    private void updateShowError() {
        boolean view = this.chartErrorCheck.isSelected();
        if (view) {
            for (AttributeInfo ai : this.parent.selection) {
                JLAxis a2;
                if (ai.chartData != null) {
                    JLAxis a1 = ai.chartData.getAxis();
                    if (a1 == null) continue;
                    a1.addDataView(ai.errorData);
                    continue;
                }
                if (ai.wchartData == null || (a2 = ai.wchartData.getAxis()) == null) continue;
                a2.addDataView(ai.errorData);
            }
        } else {
            for (AttributeInfo ai : this.parent.selection) {
                if (ai.errorData == null) continue;
                ai.errorData.removeFromAxis();
            }
        }
        this.chart.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.updateXCombo) {
            XAxisItem src = (XAxisItem)this.xViewCombo.getSelectedItem();
            if (src.isEmpty()) {
                this.chart.getXAxis().setAnnotation(1);
                this.chart.getXAxis().clearDataView();
            } else {
                JLDataView dvx = null;
                if (src.isScalar()) {
                    dvx = src.ai.chartData;
                } else if (src.isArrayItem()) {
                    dvx = src.aai.chartData;
                }
                if (dvx != null) {
                    JLAxis oldAxis = dvx.getAxis();
                    if (oldAxis != null) {
                        JOptionPane.showMessageDialog(this, "This view is already selected on an other axis.", "Error", 0);
                    } else {
                        this.chart.getXAxis().addDataView(dvx);
                    }
                }
            }
            this.chart.repaint();
        }
    }

    public void resetAll() {
        Vector views = new Vector();
        views.addAll(this.chart.getY1Axis().getViews());
        views.addAll(this.chart.getY2Axis().getViews());
        for (int i = 0; i < views.size(); ++i) {
            this.chart.removeDataView((JLDataView)views.get(i));
        }
        if (this.chart.getXAxis().isXY()) {
            this.chart.getXAxis().setAnnotation(1);
            this.chart.getXAxis().clearDataView();
        }
    }

    public void resetXItem() {
        this.updateXCombo = true;
        this.xViewCombo.removeAllItems();
        this.xViewCombo.addItem(new XAxisItem());
        this.updateXCombo = false;
    }

    public void addXItem(AttributeInfo ai) {
        this.updateXCombo = true;
        this.xViewCombo.addItem(new XAxisItem(ai));
        this.updateXCombo = false;
    }

    public void addXArrayItem(AttributeInfo ai, ArrayAttributeInfo aai) {
        this.updateXCombo = true;
        this.xViewCombo.addItem(new XAxisItem(ai, aai));
        this.updateXCombo = false;
    }

    private void initComponents() {
        this.chartBtnPanel = new JPanel();
        this.showLegendCheckBox = new JCheckBox();
        this.showGridCheckBox = new JCheckBox();
        this.onlyErrorCheck = new JCheckBox();
        this.chartErrorCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.xViewCombo = new JComboBox();
        this.chartPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.chartBtnPanel.setLayout(new FlowLayout(2, 5, 1));
        this.showLegendCheckBox.setFont(new Font("Dialog", 0, 12));
        this.showLegendCheckBox.setSelected(true);
        this.showLegendCheckBox.setText("Show legend");
        this.showLegendCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartPanel.this.showLegendCheckBoxActionPerformed(evt);
            }
        });
        this.chartBtnPanel.add(this.showLegendCheckBox);
        this.showGridCheckBox.setFont(new Font("Dialog", 0, 12));
        this.showGridCheckBox.setText("Show grid");
        this.showGridCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartPanel.this.showGridCheckBoxActionPerformed(evt);
            }
        });
        this.chartBtnPanel.add(this.showGridCheckBox);
        this.onlyErrorCheck.setFont(new Font("Dialog", 0, 12));
        this.onlyErrorCheck.setText("Clickable error only");
        this.onlyErrorCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartPanel.this.onlyErrorCheckActionPerformed(evt);
            }
        });
        this.chartBtnPanel.add(this.onlyErrorCheck);
        this.chartErrorCheck.setFont(new Font("Dialog", 0, 12));
        this.chartErrorCheck.setText("View Errors");
        this.chartErrorCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartPanel.this.chartErrorCheckActionPerformed(evt);
            }
        });
        this.chartBtnPanel.add(this.chartErrorCheck);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("   X Axis");
        this.chartBtnPanel.add(this.jLabel1);
        this.xViewCombo.setFont(new Font("Dialog", 0, 12));
        this.xViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.chartBtnPanel.add(this.xViewCombo);
        this.add((Component)this.chartBtnPanel, "South");
        this.chartPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.chartPanel.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
    }

    private void chartErrorCheckActionPerformed(ActionEvent evt) {
        this.updateShowError();
    }

    private void showLegendCheckBoxActionPerformed(ActionEvent evt) {
        this.chart.setLabelVisible(this.showLegendCheckBox.isSelected());
        this.chart.repaint();
    }

    private void showGridCheckBoxActionPerformed(ActionEvent evt) {
        boolean v = this.showGridCheckBox.isSelected();
        this.chart.getY1Axis().setGridVisible(v);
        this.chart.getY1Axis().setSubGridVisible(v);
        this.chart.getXAxis().setGridVisible(v);
        this.chart.getXAxis().setSubGridVisible(v);
        this.chart.repaint();
    }

    private void onlyErrorCheckActionPerformed(ActionEvent evt) {
        this.updateClickableError();
    }
}

