/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import HDBViewer.AttributeInfo;
import HDBViewer.AttributeTree.AttributeNode;
import HDBViewer.AttributeTree.RootNode;
import HDBViewer.AttributeTree.TreeListener;
import HDBViewer.AttributeTree.TreeNode;
import HDBViewer.AttributeTree.TreeNodeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.tango.jhdb.HdbReader;

public class TreePanel
extends JPanel
implements MouseListener,
TreeSelectionListener,
ActionListener {
    TreeNode root;
    DefaultTreeModel treeModel;
    JTree tree;
    JScrollPane treeView;
    ArrayList<TreeListener> listeners;
    JPopupMenu actionMenu;
    JMenuItem addMenu;

    public TreePanel(HdbReader reader) {
        this.root = new RootNode(reader);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        this.tree.setToggleClickCount(0);
        this.treeView = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)this.treeView, "Center");
        this.setPreferredSize(new Dimension(250, 400));
        this.setMinimumSize(new Dimension(10, 10));
        this.listeners = new ArrayList();
        this.actionMenu = new JPopupMenu();
        this.addMenu = new JMenuItem("Add");
        this.actionMenu.add(this.addMenu);
        this.addMenu.addActionListener(this);
    }

    public ArrayList<AttributeInfo> getSelection() {
        ArrayList<AttributeInfo> ret = new ArrayList<AttributeInfo>();
        TreePath[] paths = this.tree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            TreeNode node = (TreeNode)paths[i].getLastPathComponent();
            if (!(node instanceof AttributeNode)) continue;
            AttributeNode aNode = (AttributeNode)node;
            AttributeInfo ai = new AttributeInfo();
            ai.name = aNode.getAttributeName();
            ai.host = aNode.getHostName();
            ai.step = false;
            ret.add(ai);
        }
        return ret;
    }

    public void addTreeListener(TreeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeTreeListener(TreeListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeListener() {
        ArrayList<AttributeInfo> la = this.getSelection();
        for (TreeListener l : this.listeners) {
            l.attributeAction(this, la);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            if (e.getClickCount() == 1 && e.getButton() == 3 && !this.tree.isSelectionEmpty() && ((TreeNode)selPath.getLastPathComponent()).isLeaf()) {
                int nbSel;
                if (!this.tree.isPathSelected(selPath)) {
                    this.tree.addSelectionPath(selPath);
                }
                if ((nbSel = this.tree.getSelectionCount()) > 1) {
                    this.addMenu.setText("Add " + nbSel + " items");
                } else {
                    this.addMenu.setText("Add");
                }
                this.actionMenu.show(this.tree, e.getX(), e.getY());
            }
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                this.tree.setSelectionPath(selPath);
                this.fireTreeListener();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireTreeListener();
    }
}

