/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import HDBViewer.AttributeTree.DomainNode;
import HDBViewer.AttributeTree.HostAlias;
import HDBViewer.AttributeTree.TreeNode;
import HDBViewer.AttributeTree.TreeNodeRenderer;
import HDBViewer.Utils;
import javax.swing.ImageIcon;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;

class HostNode
extends TreeNode {
    String host;
    String alias;

    HostNode(HdbReader reader, String host) {
        this.reader = reader;
        this.host = host;
        this.alias = HostAlias.getInstance().getAliasFor(host);
    }

    @Override
    void populateNode() {
        try {
            String[] domains = this.reader.getDomains(this.host);
            for (int i = 0; i < domains.length; ++i) {
                this.add(new DomainNode(this.reader, this.host, domains[i]));
            }
        }
        catch (HdbFailed e) {
            Utils.showError(e.getMessage());
        }
    }

    @Override
    ImageIcon getIcon() {
        return TreeNodeRenderer.hosticon;
    }

    @Override
    public String toString() {
        return this.alias;
    }
}

