/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import HDBViewer.AttributeTree.MemberNode;
import HDBViewer.AttributeTree.TreeNode;
import HDBViewer.Utils;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;

class FamilyNode
extends TreeNode {
    String host;
    String domain;
    String family;

    FamilyNode(HdbReader reader, String host, String domain, String family) {
        this.reader = reader;
        this.host = host;
        this.domain = domain;
        this.family = family;
    }

    @Override
    void populateNode() {
        try {
            String[] members = this.reader.getMembers(this.host, this.domain, this.family);
            for (int i = 0; i < members.length; ++i) {
                this.add(new MemberNode(this.reader, this.host, this.domain, this.family, members[i]));
            }
        }
        catch (HdbFailed e) {
            Utils.showError(e.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.family;
    }
}

