/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import HDBViewer.AttributeTree.FamilyNode;
import HDBViewer.AttributeTree.TreeNode;
import HDBViewer.Utils;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;

class DomainNode
extends TreeNode {
    String host;
    String domain;

    DomainNode(HdbReader reader, String host, String domain) {
        this.reader = reader;
        this.host = host;
        this.domain = domain;
    }

    @Override
    void populateNode() {
        try {
            String[] families = this.reader.getFamilies(this.host, this.domain);
            for (int i = 0; i < families.length; ++i) {
                this.add(new FamilyNode(this.reader, this.host, this.domain, families[i]));
            }
        }
        catch (HdbFailed e) {
            Utils.showError(e.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.domain;
    }
}

