/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.ArrayAttributeInfo;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.util.ArrayList;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;

public class AttributeInfo {
    public static final int SEL_NONE = 0;
    public static final int SEL_Y1 = 1;
    public static final int SEL_Y2 = 2;
    public static final int SEL_IMAGE = 3;
    public String host;
    public String name;
    public String type;
    public String unit = "";
    public double A1 = 1.0;
    public HdbSigInfo sigInfo;
    public boolean step = false;
    public boolean table = false;
    public int selection = 0;
    public int wselection = 0;
    public int dataSize = 0;
    public int errorSize;
    public JLDataView chartData = null;
    public JLDataView wchartData = null;
    public JLDataView errorData;
    public ArrayList<HdbData> errors;
    public HdbDataSet arrayData;
    public int maxArraySize = -1;
    public ArrayList<ArrayAttributeInfo> arrAttInfos = null;

    public String getFullName() {
        return "tango://" + this.host + "/" + this.name;
    }

    public boolean isRW() {
        return this.sigInfo.isRW();
    }

    public boolean isArray() {
        return this.sigInfo.isArray();
    }

    public boolean isNumeric() {
        return this.sigInfo.isNumeric();
    }

    public boolean isString() {
        return this.sigInfo.isString();
    }

    public boolean isState() {
        return this.sigInfo.isState();
    }

    public boolean isExpanded() {
        if (!this.isArray() || this.arrAttInfos == null) {
            return false;
        }
        return this.arrAttInfos.size() > 0;
    }

    public void expand(ArrayList<Integer> ids) {
        this.arrAttInfos = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            ArrayAttributeInfo aai = new ArrayAttributeInfo(ids.get(i));
            this.arrAttInfos.add(aai);
        }
    }

    static boolean isInList(AttributeInfo item, ArrayList<AttributeInfo> list) {
        boolean found = false;
        int i = 0;
        while (!found && i < list.size()) {
            found = item.sigInfo.sigId.equals(list.get((int)i).sigInfo.sigId);
            if (found) continue;
            ++i;
        }
        return found;
    }

    static AttributeInfo getFromList(AttributeInfo item, ArrayList<AttributeInfo> list) {
        boolean found = false;
        int i = 0;
        while (!found && i < list.size()) {
            found = item.sigInfo.sigId.equals(list.get((int)i).sigInfo.sigId);
            if (found) continue;
            ++i;
        }
        if (!found) {
            return null;
        }
        return list.get(i);
    }
}

