/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.ArrayAttributeInfo;
import HDBViewer.AttributeInfo;
import HDBViewer.BooleanCellRenderer;
import HDBViewer.ConfigFileReader;
import HDBViewer.HDBFileFilter;
import HDBViewer.IDSelectionDlg;
import HDBViewer.MainPanel;
import HDBViewer.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;

public class SelectionPanel
extends JPanel {
    static final String[] colNames = new String[]{"Tango Host", "Attribute", "Type", "Records", "Table", "Step", "Sel. Y1", "Sel. Y2", "Sel. Img"};
    final MainPanel parent;
    DefaultTableModel selModel;
    JTable selTable;
    JScrollPane selView;
    SelRowItem[] rowToIdx;
    String defaultScriptPath = ".";
    String defaultSelFilePath = ".";
    private JButton allY1Button;
    private JButton allY2Button;
    private JPanel btnPanel;
    private JPanel innerScriptPanel;
    private JPanel innerSelectionPanel;
    private JPanel listPanel;
    private JButton loadButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JButton saveButton;
    private JButton scriptButton;
    private JTextField scriptText;

    SelectionPanel(MainPanel p) {
        this.parent = p;
        this.initComponents();
        this.selModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex >= 4) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return SelectionPanel.this.isEditable(row, column);
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                int selMode = 0;
                boolean b = (Boolean)aValue;
                int attIdx = SelectionPanel.this.rowToIdx[row].attIdx;
                boolean isW = SelectionPanel.this.rowToIdx[row].isWrite;
                int item = SelectionPanel.this.rowToIdx[row].arrayItem;
                switch (column) {
                    case 4: {
                        if (item < 0) {
                            SelectionPanel.this.parent.selection.get((int)attIdx).table = b;
                        } else {
                            SelectionPanel.this.parent.selection.get((int)attIdx).arrAttInfos.get((int)item).table = true;
                        }
                        SelectionPanel.this.updateSelectionList();
                        return;
                    }
                    case 5: {
                        if (item < 0) {
                            SelectionPanel.this.parent.selection.get((int)attIdx).step = b;
                        } else {
                            SelectionPanel.this.parent.selection.get((int)attIdx).arrAttInfos.get((int)item).step = true;
                        }
                        SelectionPanel.this.updateSelectionList();
                        return;
                    }
                    case 6: {
                        if (!b) break;
                        selMode = 1;
                        break;
                    }
                    case 7: {
                        if (!b) break;
                        selMode = 2;
                        break;
                    }
                    case 8: {
                        if (!b) break;
                        selMode = 3;
                    }
                }
                AttributeInfo ai = SelectionPanel.this.parent.selection.get(attIdx);
                if (item < 0 && ai.isArray() && (selMode == 1 || selMode == 2)) {
                    ArrayList<Integer> expandedIDs = IDSelectionDlg.getIds(ai.maxArraySize);
                    if (expandedIDs == null) {
                        SelectionPanel.this.updateSelectionList();
                        return;
                    }
                    if (ai.isExpanded()) {
                        for (int i = 0; i < ai.arrAttInfos.size(); ++i) {
                            SelectionPanel.this.parent.unselectAttribute(ai, i);
                        }
                    }
                    ai.expand(expandedIDs);
                    SelectionPanel.this.updateSelectionList();
                    return;
                }
                if (SelectionPanel.this.parent.selectAttribute(ai, item, selMode, isW)) {
                    for (AttributeInfo _ai : SelectionPanel.this.parent.selection) {
                        if (_ai != ai) {
                            if (_ai.selection == 3) {
                                _ai.selection = 0;
                            }
                            if (_ai.wselection != 3) continue;
                            _ai.wselection = 0;
                            continue;
                        }
                        if (isW) {
                            if (_ai.selection != 3) continue;
                            ai.selection = 0;
                            continue;
                        }
                        if (_ai.wselection != 3) continue;
                        ai.wselection = 0;
                    }
                }
                SelectionPanel.this.updateSelectionList();
            }
        };
        this.selTable = new JTable(this.selModel);
        this.selTable.setDefaultRenderer(Boolean.class, new BooleanCellRenderer());
        JScrollPane selView = new JScrollPane(this.selTable);
        selView.setPreferredSize(new Dimension(600, 100));
        this.listPanel.add((Component)selView, "Center");
        this.updateSelectionList();
        try {
            DbDatum df;
            Database db = ApiUtil.get_db_obj();
            DbDatum ds = db.get_property("HDBViewer", "scriptPath");
            if (!ds.is_empty()) {
                this.defaultScriptPath = ds.extractString();
            }
            if (!(df = db.get_property("HDBViewer", "selFilePath")).is_empty()) {
                this.defaultSelFilePath = df.extractString();
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    boolean isEditable(int row, int column) {
        if (column < 4) {
            return false;
        }
        int attIdx = this.rowToIdx[row].attIdx;
        int item = this.rowToIdx[row].arrayItem;
        AttributeInfo ai = this.parent.selection.get(attIdx);
        if (column == 4) {
            return true;
        }
        if (column == 5) {
            return item >= 0 || ai.isNumeric() && !ai.isArray();
        }
        if (column == 6 || column == 7) {
            return ai.isNumeric();
        }
        if (column == 8) {
            return item == -1 && ai.isNumeric() && ai.isArray();
        }
        return false;
    }

    String getPyScript() {
        return this.scriptText.getText();
    }

    void setPyScript(String name) {
        this.scriptText.setText(name);
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.btnPanel = new JPanel();
        this.innerScriptPanel = new JPanel();
        this.scriptText = new JTextField();
        this.scriptButton = new JButton();
        this.innerSelectionPanel = new JPanel();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.allY1Button = new JButton();
        this.allY2Button = new JButton();
        this.setLayout(new BorderLayout());
        this.listPanel.setLayout(new BorderLayout());
        this.add((Component)this.listPanel, "Center");
        this.btnPanel.setLayout(new GridBagLayout());
        this.innerScriptPanel.setBorder(BorderFactory.createTitledBorder(null, "Python script", 0, 0, new Font("Dialog", 0, 10)));
        this.innerScriptPanel.setLayout(new GridBagLayout());
        this.scriptText.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.innerScriptPanel.add((Component)this.scriptText, gridBagConstraints);
        this.scriptButton.setFont(new Font("Dialog", 0, 12));
        this.scriptButton.setText("...");
        this.scriptButton.setToolTipText("Load a python script");
        this.scriptButton.setMargin(new Insets(2, 5, 2, 5));
        this.scriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.scriptButtonActionPerformed(evt);
            }
        });
        this.innerScriptPanel.add((Component)this.scriptButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.btnPanel.add((Component)this.innerScriptPanel, gridBagConstraints);
        this.innerSelectionPanel.setBorder(BorderFactory.createTitledBorder(null, "Selection", 0, 0, new Font("Dialog", 0, 10)));
        this.innerSelectionPanel.setLayout(new FlowLayout(1, 2, 1));
        this.loadButton.setFont(new Font("Dialog", 0, 12));
        this.loadButton.setText("Load");
        this.loadButton.setToolTipText("Load a selection file");
        this.loadButton.setMargin(new Insets(2, 5, 2, 5));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.loadButtonActionPerformed(evt);
            }
        });
        this.innerSelectionPanel.add(this.loadButton);
        this.saveButton.setFont(new Font("Dialog", 0, 12));
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Save current selection to file");
        this.saveButton.setMargin(new Insets(2, 5, 2, 5));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.innerSelectionPanel.add(this.saveButton);
        this.removeButton.setFont(new Font("Dialog", 0, 12));
        this.removeButton.setText("Remove");
        this.removeButton.setToolTipText("Remove selected attribute from selection list");
        this.removeButton.setMargin(new Insets(2, 5, 2, 5));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.innerSelectionPanel.add(this.removeButton);
        this.removeAllButton.setFont(new Font("Dialog", 0, 12));
        this.removeAllButton.setText("Clear All");
        this.removeAllButton.setToolTipText("Clear the whole selection");
        this.removeAllButton.setMargin(new Insets(2, 5, 2, 5));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        this.innerSelectionPanel.add(this.removeAllButton);
        this.allY1Button.setFont(new Font("Dialog", 0, 12));
        this.allY1Button.setText("All Y1");
        this.allY1Button.setMargin(new Insets(2, 5, 2, 5));
        this.allY1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.allY1ButtonActionPerformed(evt);
            }
        });
        this.innerSelectionPanel.add(this.allY1Button);
        this.allY2Button.setFont(new Font("Dialog", 0, 12));
        this.allY2Button.setText("All Y2");
        this.allY2Button.setMargin(new Insets(2, 5, 2, 5));
        this.allY2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.allY2ButtonActionPerformed(evt);
            }
        });
        this.innerSelectionPanel.add(this.allY2Button);
        this.btnPanel.add((Component)this.innerSelectionPanel, new GridBagConstraints());
        this.add((Component)this.btnPanel, "South");
    }

    void updateSelectionList() {
        int nbAtt = 0;
        for (int i = 0; i < this.parent.selection.size(); ++i) {
            AttributeInfo ai = this.parent.selection.get(i);
            if (ai.isExpanded()) {
                if (ai.isRW()) {
                    nbAtt += 2 * (1 + ai.arrAttInfos.size());
                    continue;
                }
                nbAtt += 1 + ai.arrAttInfos.size();
                continue;
            }
            if (ai.isRW()) {
                nbAtt += 2;
                continue;
            }
            ++nbAtt;
        }
        int j = 0;
        Object[][] objs = new Object[nbAtt][9];
        this.rowToIdx = new SelRowItem[nbAtt];
        for (int i = 0; i < this.parent.selection.size(); ++i) {
            int k;
            AttributeInfo ai = this.parent.selection.get(i);
            objs[j][0] = ai.host;
            objs[j][1] = ai.name;
            objs[j][2] = ai.type;
            objs[j][3] = Integer.toString(ai.dataSize) + " (Err=" + Integer.toString(ai.errorSize) + ")";
            objs[j][4] = ai.table;
            objs[j][5] = ai.step;
            objs[j][6] = ai.selection == 1;
            objs[j][7] = ai.selection == 2;
            objs[j][8] = ai.selection == 3;
            this.rowToIdx[j] = new SelRowItem(i, false, -1);
            ++j;
            if (ai.isExpanded()) {
                k = 0;
                for (ArrayAttributeInfo aai : ai.arrAttInfos) {
                    objs[j][0] = ai.host;
                    objs[j][1] = ai.name + "[" + aai.idx + "]";
                    objs[j][2] = "Item #" + aai.idx;
                    objs[j][3] = Integer.toString(ai.dataSize) + " (Err=" + Integer.toString(ai.errorSize) + ")";
                    objs[j][4] = aai.table;
                    objs[j][5] = aai.step;
                    objs[j][6] = aai.selection == 1;
                    objs[j][7] = aai.selection == 2;
                    objs[j][8] = aai.selection == 3;
                    this.rowToIdx[j] = new SelRowItem(i, false, k);
                    ++j;
                    ++k;
                }
            }
            if (!ai.isRW()) continue;
            objs[j][0] = ai.host;
            objs[j][1] = ai.name + "_w";
            objs[j][2] = ai.type;
            objs[j][3] = Integer.toString(ai.dataSize) + " (Err=" + Integer.toString(ai.errorSize) + ")";
            objs[j][4] = ai.table;
            objs[j][5] = ai.step;
            objs[j][6] = ai.wselection == 1;
            objs[j][7] = ai.wselection == 2;
            objs[j][8] = ai.wselection == 3;
            this.rowToIdx[j] = new SelRowItem(i, true, -1);
            ++j;
            if (!ai.isExpanded()) continue;
            k = 0;
            for (ArrayAttributeInfo aai : ai.arrAttInfos) {
                objs[j][0] = ai.host;
                objs[j][1] = ai.name + "_w[" + aai.idx + "]";
                objs[j][2] = "Write item #" + aai.idx;
                objs[j][3] = Integer.toString(ai.dataSize) + " (Err=" + Integer.toString(ai.errorSize) + ")";
                objs[j][4] = aai.table;
                objs[j][5] = aai.step;
                objs[j][6] = aai.wselection == 1;
                objs[j][7] = aai.wselection == 2;
                objs[j][8] = aai.wselection == 3;
                this.rowToIdx[j] = new SelRowItem(i, true, k);
                ++j;
                ++k;
            }
        }
        this.selModel.setDataVector(objs, colNames);
        this.selTable.getColumnModel().getColumn(1).setPreferredWidth(350);
        this.selTable.getColumnModel().getColumn(3).setMinWidth(100);
        this.selTable.getColumnModel().getColumn(4).setMaxWidth(60);
        this.selTable.getColumnModel().getColumn(5).setMaxWidth(60);
        this.selTable.getColumnModel().getColumn(6).setMaxWidth(60);
        this.selTable.getColumnModel().getColumn(7).setMaxWidth(60);
        this.selTable.getColumnModel().getColumn(8).setMaxWidth(60);
    }

    private void removeID(String id) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.parent.selection.size()) {
            found = this.parent.selection.get((int)i).sigInfo.sigId == id;
            if (found) continue;
            ++i;
        }
        if (found) {
            AttributeInfo ai = this.parent.selection.get(i);
            this.parent.unselectAttribute(ai, -1);
            if (ai.isExpanded()) {
                for (int j = 0; j < ai.arrAttInfos.size(); ++j) {
                    this.parent.unselectAttribute(ai, j);
                }
            }
            this.parent.selection.remove(i);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int i;
        int[] rows = this.selTable.getSelectedRows();
        ArrayList<String> ids = new ArrayList<String>();
        for (i = 0; i < rows.length; ++i) {
            int attIdx = this.rowToIdx[rows[i]].attIdx;
            String id = this.parent.selection.get((int)attIdx).sigInfo.sigId;
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        for (i = 0; i < ids.size(); ++i) {
            this.removeID((String)ids.get(i));
        }
        this.updateSelectionList();
    }

    void loadFile(String fileName) {
        try {
            ConfigFileReader cf = new ConfigFileReader(new FileReader(fileName));
            ArrayList<AttributeInfo> list = cf.parseFile();
            for (int i = 0; i < list.size(); ++i) {
                HdbSigInfo si = this.parent.hdb.getReader().getSigInfo(list.get(i).getFullName());
                list.get((int)i).type = HdbSigInfo.typeStr[si.type].substring(5).toLowerCase();
                list.get((int)i).sigInfo = si;
            }
            this.parent.reset();
            this.parent.selection = list;
            this.updateSelectionList();
            this.parent.chartPanel.setShowError(cf.showError);
            this.parent.hdbTreePanel.setTimeInterval(cf.timeInterval);
            this.parent.hdbTreePanel.hdbModeCombo.setSelectedIndex(cf.hdbMode);
            this.scriptText.setText(cf.scriptName);
        }
        catch (IOException e) {
            Utils.showError("Cannot load file\n" + e.getMessage());
        }
        catch (HdbFailed e2) {
            Utils.showError("Cannot load file\n" + e2.getMessage());
        }
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.parent.selection.clear();
        this.updateSelectionList();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        File f = new File(this.defaultSelFilePath);
        JFileChooser chooser = f.exists() ? new JFileChooser(this.defaultSelFilePath) : new JFileChooser(".");
        String[] exts = new String[]{"hdb"};
        HDBFileFilter filter = new HDBFileFilter("HDB selection file", exts);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(null) == 0) {
            this.loadFile(chooser.getSelectedFile().getAbsolutePath());
            this.defaultSelFilePath = chooser.getSelectedFile().getPath();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        File f = new File(this.defaultSelFilePath);
        JFileChooser chooser = f.exists() ? new JFileChooser(this.defaultSelFilePath) : new JFileChooser(".");
        String[] exts = new String[]{"hdb"};
        HDBFileFilter filter = new HDBFileFilter("HDB selection file", exts);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(null) == 0) {
            this.parent.saveConfigFile(chooser.getSelectedFile().getAbsolutePath());
            this.defaultSelFilePath = chooser.getSelectedFile().getPath();
        }
    }

    private void scriptButtonActionPerformed(ActionEvent evt) {
        File f = new File(this.defaultScriptPath);
        JFileChooser chooser = f.exists() ? new JFileChooser(this.defaultScriptPath) : new JFileChooser(".");
        String[] exts = new String[]{"py"};
        HDBFileFilter filter = new HDBFileFilter("Python HDB script", exts);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(null) == 0) {
            this.scriptText.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void allY1ButtonActionPerformed(ActionEvent evt) {
        this.parent.selectAllY1();
    }

    private void allY2ButtonActionPerformed(ActionEvent evt) {
        this.parent.selectAllY2();
    }

    class SelRowItem {
        int attIdx;
        int arrayItem;
        boolean isWrite;

        SelRowItem(int idx, boolean write, int arrayItem) {
            this.attIdx = idx;
            this.isWrite = write;
            this.arrayItem = arrayItem;
        }
    }
}

