/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.CellItem;
import HDBViewer.RowItem;
import HDBViewer.Utils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class MultiLineTableModel
extends AbstractTableModel {
    private ArrayList<RowItem> data = new ArrayList();
    private int[] errorIndex;
    private String[] colNames = new String[0];
    private boolean doMicroSec = false;
    private boolean showError = true;

    public MultiLineTableModel() {
        this.errorIndex = new int[0];
    }

    public void setDoMicroSec(boolean doMicro) {
        this.doMicroSec = doMicro;
        this.fireTableDataChanged();
    }

    public boolean isDoingMicroSec() {
        return this.doMicroSec;
    }

    public void setShowError(boolean show) {
        this.showError = show;
        this.fireTableDataChanged();
    }

    public boolean isShowingError() {
        return this.showError;
    }

    public void setColumnNames(String[] names) {
        this.colNames = names;
        this.fireTableStructureChanged();
    }

    public void reset() {
        this.data = new ArrayList();
        this.colNames = new String[0];
        this.errorIndex = new int[0];
    }

    private RowItem binarySearch(long time) {
        int low = 0;
        int high = this.data.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.data.get((int)mid).time;
            if (midVal < time) {
                low = mid + 1;
                continue;
            }
            if (midVal > time) {
                high = mid - 1;
                continue;
            }
            return this.data.get(mid);
        }
        int r = -(low + 1);
        if (r < 0) {
            r = -(r + 1);
        }
        RowItem newItem = new RowItem();
        newItem.time = time;
        newItem.value = new ArrayList();
        this.data.add(r, newItem);
        return newItem;
    }

    public void add(String value, long time, int colIdx) {
        RowItem n = this.binarySearch(time);
        CellItem c = new CellItem();
        c.column = colIdx;
        c.value = value;
        n.value.add(c);
        if (value.startsWith("/Err")) {
            ++n.nbError;
        }
    }

    public void commit() {
        int nbIdx = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data.get(i).hasOnlyError()) continue;
            ++nbIdx;
        }
        this.errorIndex = new int[nbIdx];
        int nb = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data.get(i).hasOnlyError()) continue;
            this.errorIndex[nb] = i;
            ++nb;
        }
    }

    @Override
    public int getRowCount() {
        if (this.showError) {
            return this.data.size();
        }
        return this.errorIndex.length;
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.colNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int row = this.showError ? rowIndex : this.errorIndex[rowIndex];
        RowItem i = this.data.get(row);
        if (columnIndex == 0) {
            return Utils.formatTime(i.time, this.doMicroSec ? 1 : 0);
        }
        String r = i.getValueAt(columnIndex);
        if (this.showError) {
            return r;
        }
        if (r.startsWith("/Err")) {
            return "";
        }
        return r;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void appendRow(StringBuffer f, int r) {
        int cCount = this.getColumnCount();
        String[] ds = Utils.formatDateAndTime(this.data.get((int)r).time);
        f.append(ds[0]).append("\t");
        f.append(ds[1]).append("\t");
        for (int c = 1; c < cCount; ++c) {
            String v = (String)this.getValueAt(r, c);
            f.append(v).append("\t");
        }
        f.append("\n");
    }

    public String buildTabbedString(int[] rows) {
        int r;
        StringBuffer f = new StringBuffer();
        int cCount = this.getColumnCount();
        f.append("HDB Date\tHDB Time\t");
        for (int i = 1; i < cCount; ++i) {
            f.append(this.colNames[i]).append("\t");
        }
        f.append("\n");
        if (rows == null) {
            for (r = 0; r < this.getRowCount(); ++r) {
                this.appendRow(f, r);
            }
        } else {
            for (r = 0; r < rows.length; ++r) {
                this.appendRow(f, rows[r]);
            }
        }
        return f.toString();
    }

    public void saveFile(String fileName) throws IOException {
        FileWriter f = new FileWriter(fileName);
        f.write("# File generated from hdbviewer application\n");
        f.write("#\n");
        f.write(this.buildTabbedString(null));
        f.close();
    }
}

