/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.MultiLineCellRenderer;
import HDBViewer.MultiLineTableModel;
import java.io.IOException;
import javax.swing.JTable;

public class MultiLineTable
extends JTable {
    private final MultiLineTableModel tableModel;
    private final MultiLineCellRenderer renderer = new MultiLineCellRenderer();

    public MultiLineTable() {
        this.setDefaultRenderer(String.class, this.renderer);
        this.tableModel = new MultiLineTableModel();
        this.setModel(this.tableModel);
    }

    public void reset() {
        this.tableModel.reset();
    }

    public void setColumnName(String[] colNames) {
        this.tableModel.setColumnNames(colNames);
    }

    public void add(String value, long time, int colIdx) {
        this.tableModel.add(value, time, colIdx);
    }

    public void doMicroSec(boolean doMicro) {
        this.tableModel.setDoMicroSec(doMicro);
        this.updateSize();
    }

    public void showError(boolean show) {
        this.tableModel.setShowError(show);
        this.updateSize();
    }

    public void saveFile(String fileName) throws IOException {
        this.tableModel.saveFile(fileName);
    }

    public String getSelectionAsString() {
        return this.tableModel.buildTabbedString(this.getSelectedRows());
    }

    public void dataChanged() {
        this.tableModel.commit();
        this.updateSize();
    }

    private void updateSize() {
        this.updateRows();
        if (this.tableModel.getColumnCount() > 0) {
            if (this.tableModel.isDoingMicroSec()) {
                this.getColumnModel().getColumn(0).setMaxWidth(200);
                this.getColumnModel().getColumn(0).setPreferredWidth(200);
            } else {
                this.getColumnModel().getColumn(0).setMaxWidth(150);
                this.getColumnModel().getColumn(0).setPreferredWidth(150);
            }
        }
        this.validate();
    }

    private int cellHeight(int row, int col) {
        return this.renderer.getHeight((String)this.tableModel.getValueAt(row, col)) + 1;
    }

    void updateRow(int row) {
        int maxHeight = 0;
        for (int j = 0; j < this.getColumnCount(); ++j) {
            int ch = this.cellHeight(row, j);
            if (ch <= maxHeight) continue;
            maxHeight = ch;
        }
        this.setRowHeight(row, maxHeight);
    }

    public void updateRows() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    public int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.getModel().getRowCount() && !found) {
            found = y >= h && y <= h + this.getRowHeight(i);
            if (found) continue;
            h += this.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public int getColumnForLocation(int x) {
        boolean found = false;
        int i = 0;
        int w = 0;
        while (i < this.getModel().getColumnCount() && !found) {
            int cWidth = this.getColumnModel().getColumn(i).getWidth();
            found = x >= w && x <= w + cWidth;
            if (found) continue;
            w += cWidth;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }
}

