/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.Utils;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class MultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final Font TABLE_FONT = new Font("Dialog", 0, 12);
    private static final Font TABLE_FONT_BOLD = new Font("Dialog", 1, 12);
    private static final Color selColor = new Color(220, 220, 255);
    private static final Color backColor0 = new Color(250, 255, 255);
    private static final Color errorColor = new Color(200, 200, 200);
    private static final Border selBorder = BorderFactory.createLineBorder(selColor);
    int rowHeight;
    int wInset;

    public MultiLineCellRenderer() {
        this.setLayout(null);
        this.setEditable(false);
        this.setLineWrap(false);
        this.setWrapStyleWord(false);
        this.setFont(TABLE_FONT);
        this.rowHeight = this.getRowHeight();
        Insets m = this.getMargin();
        this.wInset = m.top + m.bottom;
    }

    public int getHeight(String value) {
        int nbLine = 1;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\n') continue;
            ++nbLine;
        }
        return nbLine * this.rowHeight + this.wInset;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str = (String)value;
        if (column == 0) {
            this.setFont(TABLE_FONT_BOLD);
        } else {
            this.setFont(TABLE_FONT);
        }
        if (str.startsWith("/Err")) {
            this.setText(str.substring(4));
        } else if (str.startsWith("/State")) {
            this.setText(str.substring(6));
        } else {
            this.setText(str);
        }
        int[] selRows = table.getSelectedRows();
        if (Utils.contains(selRows, row)) {
            this.setBackground(selColor);
        } else if (column > 0) {
            if (str.startsWith("/Err")) {
                this.setBackground(errorColor);
            } else if (str.startsWith("/State")) {
                int idx = str.indexOf(10);
                String stateStr = idx != -1 ? str.substring(6, idx) : str.substring(6);
                this.setBackground(ATKConstant.getColor4State((String)stateStr));
            } else {
                this.setBackground(Color.WHITE);
            }
        } else {
            this.setBackground(backColor0);
        }
        if (isSelected) {
            this.setBorder(selBorder);
        } else {
            this.setBorder(null);
        }
        return this;
    }
}

