/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.Utils;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class IDSelectionDlg
extends JDialog {
    private static IDSelectionDlg dialog = null;
    private static ArrayList<Integer> retIDs = null;
    private JPanel btnPanel;
    private JButton cancelButton;
    private JButton clearButton;
    private JTextArea idText;
    private JLabel infoLabel;
    private JTextArea infoTextArea;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton selectButton;

    public IDSelectionDlg() {
        super((Frame)null, true);
        this.initComponents();
        this.setTitle("Select Array item(s)");
    }

    public static ArrayList<Integer> getIds(int maxLength) {
        retIDs = null;
        if (dialog == null) {
            dialog = new IDSelectionDlg();
        }
        if (maxLength > 0) {
            dialog.setInfoText("Array length: " + maxLength);
        } else {
            dialog.setInfoText("");
        }
        ATKGraphicsUtils.centerDialog((Dialog)dialog, (int)400, (int)200);
        dialog.setVisible(true);
        return retIDs;
    }

    private void setInfoText(String msg) {
        this.infoLabel.setText(msg);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.infoTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.idText = new JTextArea();
        this.btnPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.clearButton = new JButton();
        this.selectButton = new JButton();
        this.cancelButton = new JButton();
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setColumns(20);
        this.infoTextArea.setRows(5);
        this.infoTextArea.setText("Enter list of ids to select. \nThe list of ids can be specified either as a comma\nseparated list of numbers or ranges (with each\nnumber in the range 0 to N-1 inclusive).\nEx: 0,1,2,44-67,82-99");
        this.jScrollPane2.setViewportView(this.infoTextArea);
        this.getContentPane().add((Component)this.jScrollPane2, "North");
        this.idText.setColumns(20);
        this.idText.setRows(3);
        this.jScrollPane1.setViewportView(this.idText);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.btnPanel.setLayout(new GridBagLayout());
        this.infoLabel.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.btnPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.clearButton.setFont(new Font("Dialog", 0, 12));
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDSelectionDlg.this.clearButtonActionPerformed(evt);
            }
        });
        this.btnPanel.add((Component)this.clearButton, new GridBagConstraints());
        this.selectButton.setFont(new Font("Dialog", 0, 12));
        this.selectButton.setText("Select");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDSelectionDlg.this.selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.btnPanel.add((Component)this.selectButton, gridBagConstraints);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDSelectionDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.btnPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectButtonActionPerformed(ActionEvent evt) {
        retIDs = new ArrayList();
        String[] idDef = this.idText.getText().split(",");
        try {
            int i = 0;
            while (true) {
                if (i >= idDef.length) {
                    this.setVisible(false);
                    return;
                }
                int mIdx = idDef[i].indexOf(45);
                if (mIdx == -1) {
                    int j = Integer.parseInt(idDef[i]);
                    if (retIDs.contains(j)) {
                        throw new Exception("Invalid id list. Overlap detected");
                    }
                    retIDs.add(j);
                } else {
                    int e;
                    String sR = idDef[i].substring(0, mIdx);
                    String eR = idDef[i].substring(mIdx + 1, idDef[i].length());
                    int s = Integer.parseInt(sR);
                    if (s > (e = Integer.parseInt(eR))) {
                        throw new Exception("Invalid range definition " + idDef[i]);
                    }
                    for (int j = s; j <= e; ++j) {
                        if (retIDs.contains(j)) {
                            throw new Exception("Invalid id list. Overlap detected");
                        }
                        retIDs.add(j);
                    }
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            Utils.showError("Invalid number " + e.getMessage());
            return;
        }
        catch (Exception e) {
            Utils.showError(e.getMessage());
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        retIDs = new ArrayList();
        this.setVisible(false);
    }
}

