/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.MainPanel;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DockedPanel
extends JPanel {
    static final Insets noInsets = new Insets(0, 0, 0, 0);
    static final ImageIcon closeIcon = new ImageIcon(DockedPanel.class.getResource("/HDBViewer/close.gif"));
    static final ImageIcon maximizeIcon = new ImageIcon(DockedPanel.class.getResource("/HDBViewer/maximize.gif"));
    static final ImageIcon minimizeIcon = new ImageIcon(DockedPanel.class.getResource("/HDBViewer/minimize.gif"));
    static final Color selColor = new Color(220, 220, 255);
    static final Color backColor = new Color(225, 225, 225);
    static final Font smalFont = new Font("Dialog", 0, 11);
    ArrayList<DockedItem> items;
    BarPanel barPanel;
    int selectedPanel;
    boolean visible;
    MainPanel parent;

    public DockedPanel(MainPanel parent) {
        this.parent = parent;
        this.items = new ArrayList();
        this.setLayout(new BorderLayout());
        this.barPanel = new BarPanel(this);
        this.add((Component)this.barPanel, "North");
        this.selectedPanel = -1;
        this.visible = true;
    }

    public void addPanel(String name, JPanel panel) {
        DockedItem it = new DockedItem(name, panel);
        this.items.add(it);
        if (this.selectedPanel == -1) {
            this.selectPanel(0);
        }
    }

    public void close() {
        this.parent.closePanel(this);
    }

    public void maximize() {
        this.parent.maximizePanel(this);
    }

    public void minimize() {
        this.parent.minimizePanel(this);
    }

    public void selectPanel(int idx) {
        if (this.selectedPanel >= 0) {
            JPanel panelToHide = this.items.get((int)this.selectedPanel).panel;
            this.remove(panelToHide);
        }
        this.selectedPanel = idx;
        JPanel panelToDisplay = this.items.get((int)idx).panel;
        this.add((Component)panelToDisplay, "Center");
        panelToDisplay.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    class DockedItem {
        String name;
        JPanel panel;
        int strWidth;
        int[] xPoly;
        int[] yPoly;
        int nbPoint;

        DockedItem(String name, JPanel panel) {
            this.name = name;
            this.panel = panel;
            this.strWidth = ATKGraphicsUtils.measureString((String)name, (Font)DockedPanel.smalFont).width;
            this.nbPoint = 5;
            this.xPoly = new int[this.nbPoint];
            this.yPoly = new int[this.nbPoint];
        }
    }

    class BarPanel
    extends JPanel
    implements ActionListener {
        DockedPanel parent;
        JButton closeBtn;
        JButton maximizeBtn;
        JButton minimizeBtn;
        TabBarPanel tabBar;

        BarPanel(DockedPanel parent) {
            this.parent = parent;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.tabBar = new TabBarPanel(parent);
            this.add((Component)this.tabBar, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.minimizeBtn = new JButton();
            this.minimizeBtn.setMargin(noInsets);
            this.minimizeBtn.setIcon(minimizeIcon);
            this.minimizeBtn.setToolTipText("Minimize");
            this.minimizeBtn.setEnabled(false);
            this.minimizeBtn.addActionListener(this);
            this.add((Component)this.minimizeBtn, gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.maximizeBtn = new JButton();
            this.maximizeBtn.setMargin(noInsets);
            this.maximizeBtn.setIcon(maximizeIcon);
            this.maximizeBtn.setToolTipText("Maximize");
            this.maximizeBtn.addActionListener(this);
            this.add((Component)this.maximizeBtn, gbc);
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.closeBtn = new JButton();
            this.closeBtn.setMargin(noInsets);
            this.closeBtn.setIcon(closeIcon);
            this.closeBtn.setToolTipText("Close");
            this.closeBtn.addActionListener(this);
            this.add((Component)this.closeBtn, gbc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.closeBtn) {
                this.parent.close();
            } else if (src == this.maximizeBtn) {
                this.parent.maximize();
                this.minimizeBtn.setEnabled(true);
                this.maximizeBtn.setEnabled(false);
            } else if (src == this.minimizeBtn) {
                this.parent.minimize();
                this.minimizeBtn.setEnabled(false);
                this.maximizeBtn.setEnabled(true);
            }
        }
    }

    class TabBarPanel
    extends JPanel
    implements MouseListener {
        DockedPanel parent;

        TabBarPanel(DockedPanel parent) {
            this.parent = parent;
            this.addMouseListener(this);
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
            g.setFont(smalFont);
            int pos = 5;
            int sPos = 0;
            int ePos = 0;
            for (int i = 0; i < this.parent.items.size(); ++i) {
                DockedItem di = this.parent.items.get(i);
                g.setColor(Color.BLACK);
                g.drawLine(pos, d.height, pos, 8);
                g.drawLine(pos, 8, pos + 6, 2);
                g.drawLine(pos + 6, 2, pos + di.strWidth + 10, 2);
                g.drawLine(pos + di.strWidth + 10, 2, pos + di.strWidth + 10, d.height);
                g.setColor(Color.WHITE);
                g.drawLine(pos + 1, d.height, pos + 1, 8);
                g.drawLine(pos + 1, 8, pos + 7, 3);
                g.drawLine(pos + 7, 3, pos + di.strWidth + 9, 3);
                di.xPoly[0] = pos + 2;
                di.yPoly[0] = d.height;
                di.xPoly[1] = pos + 2;
                di.yPoly[1] = 8;
                di.xPoly[2] = pos + 8;
                di.yPoly[2] = 4;
                di.xPoly[3] = pos + di.strWidth + 9;
                di.yPoly[3] = 4;
                di.xPoly[4] = pos + di.strWidth + 9;
                di.yPoly[4] = d.height;
                if (i == this.parent.selectedPanel) {
                    g.setColor(selColor);
                    sPos = pos;
                    ePos = pos + di.strWidth + 10;
                } else {
                    g.setColor(backColor);
                }
                g.fillPolygon(di.xPoly, di.yPoly, di.nbPoint);
                g.setColor(Color.BLACK);
                g.drawString(di.name, pos + 7, 13);
                pos = pos + di.strWidth + 10;
            }
            g.setColor(Color.BLACK);
            g.drawLine(0, d.height - 1, sPos, d.height - 1);
            g.drawLine(ePos, d.height - 1, d.width, d.height - 1);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            boolean found = false;
            int pos = 5;
            int i = 0;
            while (!found && i < this.parent.items.size()) {
                DockedItem di = this.parent.items.get(i);
                boolean bl = found = x >= pos && x <= pos + di.strWidth + 10;
                if (!found) {
                    ++i;
                }
                pos = pos + di.strWidth + 10;
            }
            if (found) {
                this.parent.selectPanel(i);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

