/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.ArrayAttributeInfo;
import HDBViewer.AttributeInfo;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Vector;

public class ConfigFileReader {
    String scriptName = "";
    boolean showError = false;
    int timeInterval = 0;
    int hdbMode = 0;
    private static final int NUMBER = 1;
    private static final int STRING = 2;
    private static final int COMA = 3;
    private static final int COLON = 4;
    private static final int OPENBRACE = 5;
    private static final int CLOSEBRACE = 6;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "COMA", "COLON", "'{'", "'}'"};
    private static final String COMA_STR = ",";
    private static final String COLON_STR = ":";
    private static final String OPENBRACE_STR = "{";
    private static final String CLOSEBRACE_STR = "}";
    private static final int MAX_BUFFER_SIZE = 65536;
    private static final int MAX_STRING_LENGTH = 4095;
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private char[] loadingBuffer = null;
    private int bufferIdx;
    private int bufferSize;
    private String word;
    private String version;
    private InputStreamReader f;
    private char[] tmpWord = new char[4096];

    public ConfigFileReader(FileReader fr) {
        this.f = fr;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
        this.loadingBuffer = new char[65536];
        this.bufferIdx = 0;
        this.bufferSize = 0;
    }

    public ConfigFileReader(InputStreamReader insr) {
        this.f = insr;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    public ConfigFileReader(String str) {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        this.f = new InputStreamReader(bis);
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void refill_buffer() throws IOException {
        if (this.bufferIdx >= this.bufferSize) {
            this.bufferSize = this.f.read(this.loadingBuffer);
            this.bufferIdx = 0;
        }
    }

    private void read_char() throws IOException {
        if (this.loadingBuffer != null) {
            this.refill_buffer();
            if (this.bufferSize <= 0) {
                this.CurrentChar = '\u0000';
            } else {
                this.CurrentChar = this.loadingBuffer[this.bufferIdx];
                ++this.bufferIdx;
            }
        } else {
            this.CurrentChar = !this.f.ready() ? (char)'\u0000' : (char)this.f.read();
        }
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws IOException {
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ',') {
            this.read_char();
            return COMA_STR;
        }
        if (this.CurrentChar == ':') {
            this.read_char();
            return COLON_STR;
        }
        if (this.CurrentChar == '{') {
            this.read_char();
            return OPENBRACE_STR;
        }
        if (this.CurrentChar == '}') {
            this.read_char();
            return CLOSEBRACE_STR;
        }
        int wIdx = 0;
        if (this.CurrentChar == '\"') {
            this.tmpWord[wIdx++] = this.CurrentChar;
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n' && wIdx < 4095) {
                this.tmpWord[wIdx++] = this.CurrentChar;
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n' || wIdx >= 4095) {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            this.tmpWord[wIdx++] = this.CurrentChar;
            this.read_char();
            return new String(this.tmpWord, 0, wIdx);
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != ':' && this.CurrentChar != '{' && this.CurrentChar != '}' && this.CurrentChar != ',' && wIdx < 4095) {
            this.tmpWord[wIdx++] = this.CurrentChar;
            this.read_char();
        }
        if (wIdx == 0) {
            return null;
        }
        return new String(this.tmpWord, 0, wIdx);
    }

    private boolean isNumber(String s) {
        char c;
        boolean ok = true;
        for (int i = 0; i < s.length() && ok; ok &= (c = s.charAt(i)) >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '-', ++i) {
        }
        return ok;
    }

    private int class_lex(String word) {
        if (word == null) {
            return 0;
        }
        if (word.length() == 0) {
            return 2;
        }
        if (word.charAt(0) == '\"') {
            return 2;
        }
        if (word.equals(COMA_STR)) {
            return 3;
        }
        if (word.equals(COLON_STR)) {
            return 4;
        }
        if (word.equals(OPENBRACE_STR)) {
            return 5;
        }
        if (word.equals(CLOSEBRACE_STR)) {
            return 6;
        }
        if (this.isNumber(word)) {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int lt, int le) throws IOException {
        if (lt != le) {
            throw new IOException("Invalid syntyax at line " + this.StartLine + ", " + this.lexical_word[le] + " expected");
        }
    }

    private int getCurrentLine() {
        return this.StartLine;
    }

    private void jumpPropertyValue() throws IOException {
        int lex = this.class_lex(this.word);
        if (lex == 5) {
            this.jumpBlock();
            return;
        }
        boolean ok = true;
        while (ok && this.word != null) {
            if (lex != 1 && lex != 2) {
                throw new IOException("Invalid syntyax at line " + this.StartLine + ": Number or String expected.");
            }
            this.word = this.read_word();
            lex = this.class_lex(this.word);
            ok = lex == 3;
            if (!ok) continue;
            this.word = this.read_word();
            lex = this.class_lex(this.word);
        }
    }

    private void jumpBlock() throws IOException {
        int lex = this.class_lex(this.word);
        this.CHECK_LEX(lex, 5);
        int nb = 1;
        while (nb > 0 && this.word != null) {
            this.word = this.read_word();
            lex = this.class_lex(this.word);
            if (lex == 5) {
                ++nb;
            }
            if (lex != 6) continue;
            --nb;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        this.word = this.read_word();
    }

    private void startBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 5);
        this.word = this.read_word();
    }

    private void jumpLexem(int lexem) throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), lexem);
        this.word = this.read_word();
    }

    private void endBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word();
    }

    private boolean isEndBlock() {
        return this.class_lex(this.word) == 6;
    }

    private double parseDouble() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        double ret = 0.0;
        try {
            ret = Double.parseDouble(this.word);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word();
        return ret;
    }

    private int parseInt() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        int ret = 0;
        try {
            ret = Integer.parseInt(this.word);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid integer number at line " + this.StartLine);
        }
        this.word = this.read_word();
        return ret;
    }

    private String extractQuote(String s) {
        if (s.charAt(0) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private String parseString() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String s = this.extractQuote(this.word);
        this.word = this.read_word();
        return s;
    }

    private boolean parseBoolean() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String value = this.word;
        this.word = this.read_word();
        return value.equalsIgnoreCase("true");
    }

    private String parseProperyName() throws IOException {
        String propName = this.parseString();
        this.jumpLexem(4);
        return propName;
    }

    private Color parseColor() throws IOException {
        int red = (int)this.parseDouble();
        this.jumpLexem(3);
        int green = (int)this.parseDouble();
        this.jumpLexem(3);
        int blue = (int)this.parseDouble();
        return new Color(red, green, blue);
    }

    private String parseStringArray() throws IOException {
        Vector<String> v = new Vector<String>();
        boolean end = false;
        while (!end && this.word != null) {
            String s = this.parseString();
            v.add(s);
            end = this.class_lex(this.word) != 3;
            if (end) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        String ret = "";
        for (int i = 0; i < v.size(); ++i) {
            ret = ret + (String)v.get(i) + "\n";
        }
        return ret;
    }

    private ArrayAttributeInfo parseExpandedSection(int idx) throws IOException {
        ArrayAttributeInfo aai = new ArrayAttributeInfo(idx);
        this.startBlock();
        while (!this.isEndBlock()) {
            String propName = this.parseProperyName();
            if (propName.equals("step")) {
                aai.step = this.parseBoolean();
                continue;
            }
            if (propName.equals("table")) {
                aai.table = this.parseBoolean();
                continue;
            }
            if (propName.equals("selection")) {
                aai.selection = this.parseInt();
                continue;
            }
            if (propName.equals("wselection")) {
                aai.wselection = this.parseInt();
                continue;
            }
            System.out.println("Warning, unknown expanded property found:" + propName);
            this.jumpPropertyValue();
        }
        this.endBlock();
        return aai;
    }

    private ArrayList<ArrayAttributeInfo> parseExpanded() throws IOException {
        ArrayList<ArrayAttributeInfo> list = new ArrayList<ArrayAttributeInfo>();
        this.startBlock();
        while (!this.isEndBlock()) {
            String idxName = this.parseString();
            if (!idxName.equalsIgnoreCase("idx")) {
                throw new IOException("Unexcpected keyword :" + idxName + " at line " + this.StartLine);
            }
            int idx = this.parseInt();
            ArrayAttributeInfo aai = this.parseExpandedSection(idx);
            list.add(aai);
        }
        this.endBlock();
        return list;
    }

    private AttributeInfo parseSection() throws IOException {
        String sectionName = this.parseString();
        if (sectionName.equals("Global")) {
            this.startBlock();
            while (!this.isEndBlock()) {
                String propName = this.parseProperyName();
                if (propName.equals("script")) {
                    this.scriptName = this.parseString();
                    continue;
                }
                if (propName.equals("showError")) {
                    this.showError = this.parseBoolean();
                    continue;
                }
                if (propName.equals("timeInterval")) {
                    this.timeInterval = this.parseInt();
                    continue;
                }
                if (propName.equals("hdbMode")) {
                    this.hdbMode = this.parseInt();
                    continue;
                }
                System.out.println("Warning, unknown global property found:" + propName);
                this.jumpPropertyValue();
            }
        } else {
            if (sectionName.equals("Attribute")) {
                AttributeInfo ai = new AttributeInfo();
                this.startBlock();
                while (!this.isEndBlock()) {
                    String propName = this.parseProperyName();
                    if (propName.equals("host")) {
                        ai.host = this.parseString();
                        continue;
                    }
                    if (propName.equals("name")) {
                        ai.name = this.parseString();
                        continue;
                    }
                    if (propName.equals("step")) {
                        ai.step = this.parseBoolean();
                        continue;
                    }
                    if (propName.equals("table")) {
                        ai.table = this.parseBoolean();
                        continue;
                    }
                    if (propName.equals("selection")) {
                        ai.selection = this.parseInt();
                        continue;
                    }
                    if (propName.equals("wselection")) {
                        ai.wselection = this.parseInt();
                        continue;
                    }
                    if (propName.equals("expanded")) {
                        ai.arrAttInfos = this.parseExpanded();
                        continue;
                    }
                    System.out.println("Warning, unknown attribute property found:" + propName);
                    this.jumpPropertyValue();
                }
                this.endBlock();
                return ai;
            }
            throw new IOException("Unexcpected keyword :" + sectionName + " at line " + this.StartLine);
        }
        this.endBlock();
        return null;
    }

    private String parseParamString() throws IOException {
        Vector<String> v = new Vector<String>();
        boolean end = false;
        while (!end && this.word != null) {
            int lex = this.class_lex(this.word);
            if (lex != 2 && lex != 1) {
                throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[1] + "' or '" + this.lexical_word[2] + "' expected");
            }
            v.add(this.extractQuote(this.word));
            this.word = this.read_word();
            end = this.class_lex(this.word) != 3;
            if (end) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        String ret = "";
        for (int i = 0; i < v.size(); ++i) {
            ret = ret + (String)v.get(i);
            if (i >= v.size() - 1) continue;
            ret = ret + "\n";
        }
        return ret;
    }

    public ArrayList<AttributeInfo> parseFile() throws IOException {
        boolean eof = false;
        ArrayList<AttributeInfo> objects = new ArrayList<AttributeInfo>();
        this.word = this.read_word();
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("HDBfile")) {
            throw new IOException("Invalid header !");
        }
        this.jumpLexem(2);
        this.version = this.parseString();
        this.jumpLexem(5);
        int lex = this.class_lex(this.word);
        while (!eof) {
            switch (lex) {
                case 2: {
                    AttributeInfo ai = this.parseSection();
                    if (ai == null) break;
                    objects.add(ai);
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    throw new IOException("Invalid syntyax at line " + this.StartLine + ": 'Global','Attribute' or '}' expected.");
                }
            }
            lex = this.class_lex(this.word);
            eof = this.word == null || lex == 6;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file at line " + this.StartLine + ".");
        }
        this.CHECK_LEX(this.class_lex(this.word), 6);
        return objects;
    }
}

