/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer;

import HDBViewer.AttributeInfo;
import HDBViewer.SelectionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class BooleanCellRenderer
implements TableCellRenderer {
    private static final Color backColor = new Color(240, 240, 255);
    private final JCheckBox checkBox = new JCheckBox();
    private final JButton button;
    private final JLabel empty = new JLabel("");

    BooleanCellRenderer() {
        this.checkBox.setHorizontalAlignment(0);
        this.button = new JButton("Expand");
        this.button.setMargin(new Insets(2, 2, 2, 2));
        this.button.setFont(new Font("Dialog", 0, 12));
    }

    private SelectionPanel getParent(JTable table) {
        Container c = table.getParent();
        boolean found = false;
        while (!found && c != null) {
            found = c instanceof SelectionPanel;
            if (found) continue;
            c = c.getParent();
        }
        return (SelectionPanel)c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Boolean b = (Boolean)value;
        SelectionPanel p = this.getParent(table);
        if (!p.isEditable(row, column)) {
            return this.empty;
        }
        int attIdx = p.rowToIdx[row].attIdx;
        int item = p.rowToIdx[row].arrayItem;
        AttributeInfo ai = p.parent.selection.get(attIdx);
        if ((column == 6 || column == 7) && ai.isArray() && item == -1 && ai.isNumeric()) {
            this.button.setText("Expand");
            return this.button;
        }
        this.checkBox.setSelected(b);
        if (column >= 6) {
            this.checkBox.setBackground(backColor);
        } else {
            this.checkBox.setBackground(Color.WHITE);
        }
        return this.checkBox;
    }
}

