/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import HDBViewer.AttributeTree.HostNode;
import HDBViewer.AttributeTree.TreeNode;
import HDBViewer.AttributeTree.TreeNodeRenderer;
import HDBViewer.Utils;
import javax.swing.ImageIcon;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;

class RootNode
extends TreeNode {
    RootNode(HdbReader reader) {
        this.reader = reader;
    }

    @Override
    void populateNode() {
        if (this.reader == null) {
            return;
        }
        try {
            String[] hosts = this.reader.getHosts();
            for (int i = 0; i < hosts.length; ++i) {
                this.add(new HostNode(this.reader, hosts[i]));
            }
        }
        catch (HdbFailed e) {
            Utils.showError(e.getMessage());
        }
    }

    @Override
    ImageIcon getIcon() {
        return TreeNodeRenderer.hosticon;
    }

    @Override
    public String toString() {
        return "Root";
    }
}

