/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import HDBViewer.AttributeTree.AttributeNode;
import HDBViewer.AttributeTree.TreeNode;
import HDBViewer.AttributeTree.TreeNodeRenderer;
import HDBViewer.Utils;
import javax.swing.ImageIcon;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;

class MemberNode
extends TreeNode {
    String host;
    String domain;
    String family;
    String member;

    MemberNode(HdbReader reader, String host, String domain, String family, String member) {
        this.reader = reader;
        this.host = host;
        this.domain = domain;
        this.family = family;
        this.member = member;
    }

    @Override
    void populateNode() {
        try {
            String[] names = this.reader.getNames(this.host, this.domain, this.family, this.member);
            for (int i = 0; i < names.length; ++i) {
                this.add(new AttributeNode(this.reader, this.host, this.domain, this.family, this.member, names[i]));
            }
        }
        catch (HdbFailed e) {
            Utils.showError(e.getMessage());
        }
    }

    @Override
    ImageIcon getIcon() {
        return TreeNodeRenderer.devicon;
    }

    @Override
    public String toString() {
        return this.member;
    }
}

