/*
 * Decompiled with CFR 0.152.
 */
package HDBViewer.AttributeTree;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import java.util.ArrayList;

public class HostAlias {
    private static HostAlias obj = null;
    ArrayList<String> hosts = new ArrayList();
    ArrayList<String> alias = new ArrayList();

    private HostAlias() {
        try {
            Database db = ApiUtil.get_db_obj();
            DbDatum datum = db.get_property("HDBViewer", "HostAlias");
            if (!datum.is_empty()) {
                String[] aliases = datum.extractStringArray();
                for (int i = 0; i < aliases.length; ++i) {
                    int idx = aliases[i].indexOf(44);
                    if (idx != -1) {
                        String hName = aliases[i].substring(0, idx);
                        String aName = aliases[i].substring(idx + 1, aliases[i].length());
                        this.hosts.add(hName);
                        this.alias.add(aName);
                        continue;
                    }
                    System.out.println("HostAlias() wrong syntax :" + aliases[i]);
                }
            }
        }
        catch (DevFailed e) {
            System.out.print("HostAlias() failed:" + e.errors[0].desc);
        }
    }

    static HostAlias getInstance() {
        if (obj == null) {
            obj = new HostAlias();
        }
        return obj;
    }

    String getAliasFor(String host) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.hosts.size()) {
            found = this.hosts.get(i).equalsIgnoreCase(host);
            if (found) continue;
            ++i;
        }
        if (found) {
            return this.alias.get(i);
        }
        return host;
    }
}

