/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbUShort
extends HdbData {
    int value = 0;
    int wvalue = 0;

    public HdbUShort(int n) {
        this.type = n;
    }

    public HdbUShort(int n, int n2) {
        this.type = n;
        this.value = n2;
    }

    public int getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public int getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseUSHort(arrayList.get(0));
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseUSHort(arrayList.get(0));
        }
    }

    private int parseUSHort(Object object) throws HdbFailed {
        int n;
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string == null) {
                    n = 0;
                }
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseUSHort: Invalid number syntax for value");
            }
        } else {
            Integer n2 = (Integer)object;
            n = n2;
        }
        return n;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 29) {
            return this.timeToStr(this.dataTime) + ": " + Long.toString(this.value) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + Long.toString(this.value) + ";" + Long.toString(this.wvalue) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        this.value = (int)((double)this.value * d);
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = ((HdbUShort)hdbData).value;
        this.wvalue = ((HdbUShort)hdbData).wvalue;
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        return Integer.toString(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            return Integer.toString(this.wvalue);
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }
}

