/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbUChar
extends HdbData {
    short value = 0;
    short wvalue = 0;

    public HdbUChar(int n) {
        this.type = n;
    }

    public HdbUChar(int n, short s) {
        this.type = n;
        this.value = s;
    }

    public short getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public short getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseUChar(arrayList.get(0));
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseUChar(arrayList.get(0));
        }
    }

    private short parseUChar(Object object) throws HdbFailed {
        short s;
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string == null) {
                    s = 0;
                }
                s = Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseUChar: Invalid number syntax for value");
            }
        } else {
            Short s2 = (Short)object;
            s = s2;
        }
        return s;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 21) {
            return this.timeToStr(this.dataTime) + ": " + Short.toString(this.value) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + Short.toString(this.value) + ";" + Long.toString(this.wvalue) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        this.value = (short)((double)this.value * d);
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = ((HdbUChar)hdbData).value;
        this.wvalue = ((HdbUChar)hdbData).wvalue;
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        return Short.toString(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            return Short.toString(this.wvalue);
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }
}

