/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbBoolean
extends HdbData {
    boolean value = false;
    boolean wvalue = false;

    public HdbBoolean(int n) {
        this.type = n;
    }

    public HdbBoolean(int n, boolean bl) {
        this.type = n;
        this.value = bl;
    }

    public boolean getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public boolean getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseBoolean(arrayList.get(0));
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseBoolean(arrayList.get(0));
        }
    }

    private boolean parseBoolean(Object object) throws HdbFailed {
        boolean bl;
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string == null) {
                    bl = false;
                }
                bl = Boolean.parseBoolean(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseBoolean: Invalid number syntax for value");
            }
        } else {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        }
        return bl;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 45) {
            return this.timeToStr(this.dataTime) + ": " + Boolean.toString(this.value) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + Boolean.toString(this.value) + ";" + Boolean.toString(this.wvalue) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = ((HdbBoolean)hdbData).value;
        this.wvalue = ((HdbBoolean)hdbData).wvalue;
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        return Boolean.toString(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            return Boolean.toString(this.wvalue);
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue ? 1.0 : 0.0;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value ? 1L : 0L;
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue ? 1L : 0L;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }
}

