/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.HdbSigParam;
import org.tango.jhdb.Period;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;

public class CassandraSchema
extends HdbReader {
    public static final String[] DEFAULT_CONTACT_POINTS = new String[]{"cassandra2"};
    private Session session;
    private static final String[] tableNames = new String[]{"", "att_scalar_devdouble_ro", "att_scalar_devdouble_rw", "att_array_devdouble_ro", "att_array_devdouble_rw", "att_scalar_devlong64_ro", "att_scalar_devlong64_rw", "att_array_devlong64_ro", "att_array_devlong64_rw", "", "", "", "", "att_scalar_devstring_ro", "att_scalar_devstring_rw", "att_array_devstring_ro", "att_array_devstring_rw", "att_scalar_devfloat_ro", "att_scalar_devfloat_rw", "att_array_devfloat_ro", "att_array_devfloat_rw", "att_scalar_devuchar_ro", "att_scalar_devuchar_rw", "att_array_devuchar_ro", "att_array_devuchar_rw", "att_scalar_devshort_ro", "att_scalar_devshort_rw", "att_array_devshort_ro", "att_array_devshort_rw", "att_scalar_devushort_ro", "att_scalar_devushort_rw", "att_array_devushort_ro", "att_array_devushort_rw", "att_scalar_devlong_ro", "att_scalar_devlong_rw", "att_array_devlong_ro", "att_array_devlong_rw", "att_scalar_devulong_ro", "att_scalar_devulong_rw", "att_array_devulong_ro", "att_array_devulong_rw", "att_scalar_devstate_ro", "att_scalar_devstate_rw", "att_array_devstate_ro", "att_array_devstate_rw", "att_scalar_devboolean_ro", "att_scalar_devboolean_rw", "att_array_devboolean_ro", "att_array_devboolean_rw", "att_scalar_devencoded_ro", "att_scalar_devencoded_rw", "att_array_devencoded_ro", "att_array_devencoded_rw", "att_scalar_devulong64_ro", "att_scalar_devulong64_rw", "att_array_devulong64_ro", "att_array_devulong64_rw"};
    private static final int MAX_ASYNCH_CALL = 6;
    private static PreparedStatement[] prepQueries = new PreparedStatement[tableNames.length * 2];

    public CassandraSchema(String[] stringArray, String string, String string2, String string3) throws HdbFailed {
        Object object;
        Object object2;
        if (stringArray == null || stringArray.length == 0) {
            object2 = System.getenv("HDB_CONTACT_POINTS");
            if (object2 != null && !((String)object2).isEmpty()) {
                object = new StringTokenizer((String)object2, ",");
                stringArray = new String[((StringTokenizer)object).countTokens()];
                int n = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    stringArray[n++] = ((StringTokenizer)object).nextToken();
                }
            } else {
                stringArray = DEFAULT_CONTACT_POINTS;
            }
        }
        if ((string2 == null || string2.isEmpty()) && ((string2 = System.getenv("HDB_USER")) == null || string2.isEmpty())) {
            string2 = "hdbreader";
        }
        if ((string3 == null || string3.isEmpty()) && ((string3 = System.getenv("HDB_PASSWORD")) == null || string3.isEmpty())) {
            string3 = "R3aderP4ss";
        }
        if ((string == null || string.isEmpty()) && ((string = System.getenv("HDB_NAME")) == null || string.isEmpty())) {
            string = "hdb";
        }
        try {
            object = string2.equalsIgnoreCase("anonymous") ? Cluster.builder() : Cluster.builder().withCredentials(string2, string3);
            for (String string4 : stringArray) {
                ((Cluster.Builder)object).addContactPoint(string4);
            }
            object2 = ((Cluster.Builder)object).build();
            ((Cluster)object2).getConfiguration().getProtocolOptions().setCompression(ProtocolOptions.Compression.LZ4);
            this.session = ((Cluster)object2).connect(string);
        }
        catch (Exception exception) {
            throw new HdbFailed(exception.getMessage());
        }
        for (int i = 0; i < prepQueries.length; ++i) {
            CassandraSchema.prepQueries[i] = null;
        }
    }

    private PreparedStatement getPreparedQuery(int n, boolean bl) throws HdbFailed {
        int n2;
        int n3 = n2 = bl ? 2 * n + 1 : 2 * n;
        if (n < 0 || n >= tableNames.length) {
            throw new HdbFailed("Invalid type code=" + n);
        }
        if (prepQueries[n2] != null) {
            return prepQueries[n2];
        }
        boolean bl2 = HdbSigInfo.isRWType(n);
        String string = bl2 ? ",value_w" : "";
        String string2 = tableNames[n];
        if (string2.isEmpty()) {
            throw new HdbFailed("Invalid request on a not supported type " + HdbSigInfo.typeStr[n]);
        }
        String string3 = bl ? "SELECT data_time,data_time_us,recv_time,recv_time_us,insert_time,insert_time_us,error_desc,quality,value_r" + string + " FROM " + string2 + " WHERE att_conf_id = ?" + " AND period = ?" : "SELECT data_time,data_time_us,recv_time,recv_time_us,insert_time,insert_time_us,error_desc,quality,value_r" + string + " FROM " + string2 + " WHERE att_conf_id = ?" + " AND period = ?" + " AND data_time >= ?" + " AND data_time <= ?";
        CassandraSchema.prepQueries[n2] = this.session.prepare(string3);
        return prepQueries[n2];
    }

    @Override
    public String getInfo() throws HdbFailed {
        String string = String.format("%.1f", 1.8);
        String string2 = "Cassandra HDB++ API v" + string + "\n";
        String string3 = "Cluster:" + this.session.getCluster().getClusterName();
        return string2 + string3;
    }

    @Override
    public String[] getAttributeList() throws HdbFailed {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "SELECT cs_name,att_name FROM att_conf";
        try {
            ResultSet resultSet = this.session.execute(string);
            for (Row row : resultSet) {
                String string2 = row.getString("cs_name");
                String string3 = row.getString("att_name");
                arrayList.add("tango://" + string2 + "/" + string3);
            }
        }
        catch (DriverException driverException) {
            throw new HdbFailed(driverException.getMessage());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private String[] getList(String string) throws HdbFailed {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ResultSet resultSet = this.session.execute(string);
            for (Row row : resultSet) {
                arrayList.add(row.getString(0));
            }
        }
        catch (DriverException driverException) {
            throw new HdbFailed(driverException.getMessage());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    @Override
    public String[] getHosts() throws HdbFailed {
        return this.getList("select distinct cs_name from att_conf");
    }

    @Override
    public String[] getDomains(String string) throws HdbFailed {
        return this.getList("select domain from domains where cs_name='" + string + "'");
    }

    @Override
    public String[] getFamilies(String string, String string2) throws HdbFailed {
        return this.getList("select family from families where cs_name='" + string + "' and domain='" + string2 + "'");
    }

    @Override
    public String[] getMembers(String string, String string2, String string3) throws HdbFailed {
        return this.getList("select member from members where cs_name='" + string + "' and domain='" + string2 + "' and family='" + string3 + "'");
    }

    @Override
    public String[] getNames(String string, String string2, String string3, String string4) throws HdbFailed {
        return this.getList("select name from att_names where cs_name='" + string + "' and domain='" + string2 + "' and family='" + string3 + "' and member='" + string4 + "'");
    }

    @Override
    public HdbSigInfo getSigInfo(String string) throws HdbFailed {
        HdbSigInfo hdbSigInfo = new HdbSigInfo();
        hdbSigInfo.name = string;
        if (!string.startsWith("tango://")) {
            throw new HdbFailed("Fully qualified attribute name expected (eg:tango://hostname:port/domain/family/member/name)");
        }
        String[] stringArray = (string = string.substring(8)).split("/");
        if (stringArray.length != 5) {
            throw new HdbFailed("Invalid attribute name syntax (eg:tango://hostname:port/domain/family/member/name)");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1] + "/" + stringArray[2] + "/" + stringArray[3] + "/" + stringArray[4];
        String string4 = "SELECT att_conf_id,data_type FROM att_conf WHERE cs_name='" + string2 + "' AND att_name='" + string3 + "'";
        try {
            ResultSet resultSet = this.session.execute(string4);
            Row row = resultSet.one();
            if (row == null) {
                throw new HdbFailed("Signal not found");
            }
            hdbSigInfo.sigId = row.getUUID("att_conf_id").toString();
            hdbSigInfo.type = HdbSigInfo.typeFromName(row.getString("data_type"));
        }
        catch (DriverException driverException) {
            throw new HdbFailed(driverException.getMessage());
        }
        return hdbSigInfo;
    }

    @Override
    public HdbDataSet findErrors(String string, String string2, String string3) throws HdbFailed {
        throw new HdbFailed("Not implemented");
    }

    @Override
    public HdbSigParam getLastParam(String string) throws HdbFailed {
        HdbSigInfo hdbSigInfo = this.getSigInfo(string);
        String string2 = "SELECT recv_time,recv_time_us,insert_time,insert_time_us,label,unit,standard_unit,display_unit,format,archive_rel_change,archive_abs_change,archive_period,description FROM att_parameter  WHERE att_conf_id=" + UUID.fromString(hdbSigInfo.sigId) + " ORDER BY recv_time desc limit 1;";
        HdbSigParam hdbSigParam = new HdbSigParam();
        try {
            ResultSet resultSet = this.session.execute(string2);
            Row row = resultSet.one();
            if (row != null) {
                hdbSigParam.recvTime = this.timeValue(row.getDate(0), row.getInt(1));
                hdbSigParam.insertTime = this.timeValue(row.getDate(2), row.getInt(3));
                hdbSigParam.label = row.getString(4);
                hdbSigParam.unit = row.getString(5);
                try {
                    hdbSigParam.standard_unit = Double.parseDouble(row.getString(6));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.standard_unit = 1.0;
                }
                try {
                    hdbSigParam.display_unit = Double.parseDouble(row.getString(7));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.display_unit = 1.0;
                }
            } else {
                throw new HdbFailed("Cannot get parameter for " + string);
            }
            hdbSigParam.format = row.getString(8);
            hdbSigParam.archive_rel_change = row.getString(9);
            hdbSigParam.archive_abs_change = row.getString(10);
            hdbSigParam.archive_period = row.getString(11);
            hdbSigParam.description = row.getString(12);
        }
        catch (DriverException driverException) {
            throw new HdbFailed("Failed to get parameter history: " + driverException.getMessage());
        }
        return hdbSigParam;
    }

    @Override
    public ArrayList<HdbSigParam> getParams(String string, String string2, String string3) throws HdbFailed {
        this.checkDates(string2, string3);
        HdbSigInfo hdbSigInfo = this.getSigInfo(string);
        String string4 = "SELECT recv_time,recv_time_us,insert_time,insert_time_us,label,unit,standard_unit,display_unit,format,archive_rel_change,archive_abs_change,archive_period,description FROM att_parameter  WHERE att_conf_id=" + UUID.fromString(hdbSigInfo.sigId) + " AND recv_time>='" + this.toDBDate(string2) + "'" + " AND recv_time<='" + this.toDBDate(string3) + "'";
        ArrayList<HdbSigParam> arrayList = new ArrayList<HdbSigParam>();
        try {
            ResultSet resultSet = this.session.execute(string4);
            for (Row row : resultSet) {
                HdbSigParam hdbSigParam = new HdbSigParam();
                hdbSigParam.recvTime = this.timeValue(row.getDate(0), row.getInt(1));
                hdbSigParam.insertTime = this.timeValue(row.getDate(2), row.getInt(3));
                hdbSigParam.label = row.getString(4);
                hdbSigParam.unit = row.getString(5);
                try {
                    hdbSigParam.standard_unit = Double.parseDouble(row.getString(6));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.standard_unit = 1.0;
                }
                try {
                    hdbSigParam.display_unit = Double.parseDouble(row.getString(7));
                }
                catch (NumberFormatException numberFormatException) {
                    hdbSigParam.display_unit = 1.0;
                }
                hdbSigParam.format = row.getString(8);
                hdbSigParam.archive_rel_change = row.getString(9);
                hdbSigParam.archive_abs_change = row.getString(10);
                hdbSigParam.archive_period = row.getString(11);
                hdbSigParam.description = row.getString(12);
                arrayList.add(hdbSigParam);
            }
        }
        catch (DriverException driverException) {
            throw new HdbFailed("Failed to get parameter history: " + driverException.getMessage());
        }
        return arrayList;
    }

    @Override
    HdbDataSet getDataFromDB(HdbSigInfo hdbSigInfo, String string, String string2) throws HdbFailed {
        if (hdbSigInfo == null) {
            throw new HdbFailed("sigInfo input parameters is null");
        }
        this.checkDates(string, string2);
        boolean bl = HdbSigInfo.isRWType(hdbSigInfo.type);
        ArrayList<Period> arrayList = Period.getPeriods(string, string2);
        int n = arrayList.size();
        ArrayList<HdbData> arrayList2 = new ArrayList<HdbData>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<Object> arrayList4 = null;
        if (bl) {
            arrayList4 = new ArrayList<Object>();
        }
        for (int i = 0; i < n; i += 6) {
            Object object;
            Object object2;
            int n2;
            ArrayList<ResultSetFuture> arrayList5 = new ArrayList<ResultSetFuture>();
            for (n2 = 0; n2 < 6 && n2 + i < n; ++n2) {
                object2 = arrayList.get(i + n2);
                object = ((Period)object2).isFull ? this.getPreparedQuery(hdbSigInfo.type, ((Period)object2).isFull).bind(UUID.fromString(hdbSigInfo.sigId), ((Period)object2).partitionDate) : this.getPreparedQuery(hdbSigInfo.type, ((Period)object2).isFull).bind(UUID.fromString(hdbSigInfo.sigId), ((Period)object2).partitionDate, ((Period)object2).start, ((Period)object2).end);
                ((Statement)object).setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
                ((Statement)object).setFetchSize(Integer.MAX_VALUE);
                arrayList5.add(this.session.executeAsync((Statement)object));
            }
            object2 = new ArrayList();
            try {
                for (ResultSetFuture resultSetFuture : arrayList5) {
                    ((ArrayList)object2).add(resultSetFuture.getUninterruptibly());
                }
            }
            catch (NoHostAvailableException noHostAvailableException) {
                throw new HdbFailed("Error (NoHostAvailable): " + noHostAvailableException.getMessage());
            }
            catch (QueryExecutionException queryExecutionException) {
                throw new HdbFailed("Error (QueryExecution): " + queryExecutionException.getMessage());
            }
            catch (QueryValidationException queryValidationException) {
                throw new HdbFailed("Error (QueryValidation): " + queryValidationException.getMessage());
            }
            if (this.hasProgressListener()) {
                this.fireProgressListener((double)(i + n2) / (double)n);
            }
            try {
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    ResultSet resultSet = (ResultSet)object.next();
                    for (Row row : resultSet) {
                        HdbData hdbData = HdbData.createData(hdbSigInfo.type);
                        switch (hdbSigInfo.type) {
                            case 45: 
                            case 46: {
                                this.setValue(arrayList3, row.getBool(8));
                                if (!bl) break;
                                this.setValue(arrayList4, row.getBool(9));
                                break;
                            }
                            case 47: 
                            case 48: {
                                this.setValueBoolean(arrayList3, row.getList(8, Boolean.class));
                                if (!bl) break;
                                this.setValueBoolean(arrayList4, row.getList(9, Boolean.class));
                                break;
                            }
                            case 21: 
                            case 22: 
                            case 25: 
                            case 26: {
                                this.setValue(arrayList3, (short)row.getInt(8));
                                if (!bl) break;
                                this.setValue(arrayList4, (short)row.getInt(9));
                                break;
                            }
                            case 23: 
                            case 24: 
                            case 27: 
                            case 28: {
                                this.setValueShort(arrayList3, row.getList(8, Integer.class));
                                if (!bl) break;
                                this.setValueShort(arrayList4, row.getList(9, Integer.class));
                                break;
                            }
                            case 29: 
                            case 30: 
                            case 33: 
                            case 34: 
                            case 41: 
                            case 42: {
                                this.setValue(arrayList3, row.getInt(8));
                                if (!bl) break;
                                this.setValue(arrayList4, row.getInt(9));
                                break;
                            }
                            case 31: 
                            case 32: 
                            case 35: 
                            case 36: 
                            case 43: 
                            case 44: {
                                this.setValueInteger(arrayList3, row.getList(8, Integer.class));
                                if (!bl) break;
                                this.setValueInteger(arrayList4, row.getList(9, Integer.class));
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 37: 
                            case 38: {
                                this.setValue(arrayList3, row.getLong(8));
                                if (!bl) break;
                                this.setValue(arrayList4, row.getLong(9));
                                break;
                            }
                            case 7: 
                            case 8: 
                            case 39: 
                            case 40: {
                                this.setValueLong(arrayList3, row.getList(8, Long.class));
                                if (!bl) break;
                                this.setValueLong(arrayList4, row.getList(9, Long.class));
                                break;
                            }
                            case 1: 
                            case 2: {
                                this.setValue(arrayList3, row.getDouble(8));
                                if (!bl) break;
                                this.setValue(arrayList4, row.getDouble(9));
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.setValueDouble(arrayList3, row.getList(8, Double.class));
                                if (!bl) break;
                                this.setValueDouble(arrayList4, row.getList(9, Double.class));
                                break;
                            }
                            case 17: 
                            case 18: {
                                this.setValue(arrayList3, row.getFloat(8));
                                if (!bl) break;
                                this.setValue(arrayList4, row.getFloat(9));
                                break;
                            }
                            case 19: 
                            case 20: {
                                this.setValueFloat(arrayList3, row.getList(8, Float.class));
                                if (!bl) break;
                                this.setValueFloat(arrayList4, row.getList(9, Float.class));
                                break;
                            }
                            case 13: 
                            case 14: {
                                this.setValue(arrayList3, row.getString(8));
                                if (!bl) break;
                                this.setValue(arrayList4, row.getString(9));
                                break;
                            }
                            case 15: 
                            case 16: {
                                this.setValueString(arrayList3, row.getList(8, String.class));
                                if (!bl) break;
                                this.setValueString(arrayList4, row.getList(9, String.class));
                            }
                        }
                        hdbData.parse(this.timeValue(row.getDate(0), row.getInt(1)), this.timeValue(row.getDate(2), row.getInt(3)), this.timeValue(row.getDate(4), row.getInt(5)), row.getString(6), row.getInt(7), arrayList3, arrayList4);
                        arrayList2.add(hdbData);
                    }
                }
                continue;
            }
            catch (DriverException driverException) {
                throw new HdbFailed("Failed to get data: " + driverException.getMessage());
            }
        }
        return new HdbDataSet(arrayList2);
    }

    private void setValue(ArrayList<Object> arrayList, double d) {
        arrayList.clear();
        arrayList.add(d);
    }

    private void setValueDouble(ArrayList<Object> arrayList, List<Double> list) {
        arrayList.clear();
        arrayList.addAll(list);
    }

    private void setValue(ArrayList<Object> arrayList, float f) {
        arrayList.clear();
        arrayList.add(Float.valueOf(f));
    }

    private void setValueFloat(ArrayList<Object> arrayList, List<Float> list) {
        arrayList.clear();
        arrayList.addAll(list);
    }

    private void setValue(ArrayList<Object> arrayList, boolean bl) {
        arrayList.clear();
        arrayList.add(bl);
    }

    private void setValueBoolean(ArrayList<Object> arrayList, List<Boolean> list) {
        arrayList.clear();
        arrayList.addAll(list);
    }

    private void setValue(ArrayList<Object> arrayList, int n) {
        arrayList.clear();
        arrayList.add(n);
    }

    private void setValueInteger(ArrayList<Object> arrayList, List<Integer> list) {
        arrayList.clear();
        arrayList.addAll(list);
    }

    private void setValue(ArrayList<Object> arrayList, long l) {
        arrayList.clear();
        arrayList.add(l);
    }

    private void setValueLong(ArrayList<Object> arrayList, List<Long> list) {
        arrayList.clear();
        arrayList.addAll(list);
    }

    private void setValue(ArrayList<Object> arrayList, short s) {
        arrayList.clear();
        arrayList.add(s);
    }

    private void setValueShort(ArrayList<Object> arrayList, List<Integer> list) {
        arrayList.clear();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(i).shortValue());
        }
    }

    private void setValue(ArrayList<Object> arrayList, String string) {
        arrayList.clear();
        arrayList.add(string);
    }

    private void setValueString(ArrayList<Object> arrayList, List<String> list) {
        arrayList.clear();
        arrayList.addAll(list);
    }

    private long timeValue(Date date, int n) {
        long l = date.getTime();
        l = l / 1000L * 1000000L;
        return l += (long)n;
    }

    private String toDBDate(String string) {
        return string.substring(6, 10) + "-" + string.substring(3, 5) + "-" + string.substring(0, 2) + " " + string.substring(11, 19);
    }
}

