/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbState
extends HdbData {
    int value = 0;
    int wvalue = 0;

    public HdbState(int n) {
        this.type = n;
    }

    public HdbState(int n, int n2) {
        this.type = n;
        this.value = n2;
    }

    public int getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public int getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseState(arrayList.get(0));
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseState(arrayList.get(0));
        }
    }

    private int parseState(Object object) throws HdbFailed {
        int n;
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string == null) {
                    n = 0;
                }
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseState: Invalid number syntax for value");
            }
        } else {
            Integer n2 = (Integer)object;
            n = n2;
        }
        return n;
    }

    public static String getStateString(int n) {
        switch (n) {
            case 0: {
                return "ON";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "INSERT";
            }
            case 5: {
                return "EXTRACT";
            }
            case 6: {
                return "MOVING";
            }
            case 7: {
                return "STANDBY";
            }
            case 8: {
                return "FAULT";
            }
            case 9: {
                return "INIT";
            }
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "ALARM";
            }
            case 12: {
                return "DISABLE";
            }
            case 13: {
                return "UNKNOWN";
            }
        }
        return "Unknown code";
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 41) {
            return this.timeToStr(this.dataTime) + ": " + HdbState.getStateString(this.value) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + HdbState.getStateString(this.value) + ";" + HdbState.getStateString(this.wvalue) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = ((HdbState)hdbData).value;
        this.wvalue = ((HdbState)hdbData).wvalue;
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        return HdbState.getStateString(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            return HdbState.getStateString(this.wvalue);
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }
}

