/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbShortArray
extends HdbData {
    short[] value = null;
    short[] wvalue = null;

    public HdbShortArray(int n) {
        this.type = n;
    }

    public HdbShortArray(int n, short[] sArray) {
        this.type = n;
        this.value = sArray;
    }

    public short[] getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public short[] getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseShortArray(arrayList);
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseShortArray(arrayList);
        }
    }

    private short[] parseShortArray(ArrayList<Object> arrayList) throws HdbFailed {
        short[] sArray = new short[arrayList.size()];
        if (arrayList.size() == 0) {
            return sArray;
        }
        if (arrayList.get(0) instanceof String) {
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    sArray[i] = string == null ? (short)0 : Short.parseShort(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseShortArray: Invalid number syntax");
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Short s = (Short)arrayList.get(i);
                sArray[i] = s;
            }
        }
        return sArray;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 27) {
            return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + "," + Integer.toString(this.wvalue.length) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        for (int i = 0; i < this.dataSize(); ++i) {
            this.value[i] = (short)((double)this.value[i] * d);
        }
    }

    @Override
    int dataSize() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            if (this.wvalue == null) {
                return 0;
            }
            return this.wvalue.length;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = (short[])((HdbShortArray)hdbData).value.clone();
        if (((HdbShortArray)hdbData).wvalue != null) {
            this.wvalue = (short[])((HdbShortArray)hdbData).wvalue.clone();
        }
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        return this.arrayValue(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            return this.arrayValue(this.wvalue);
        }
        return "";
    }

    private String arrayValue(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Short[" + sArray.length + "]\n");
        for (int i = 0; i < sArray.length; ++i) {
            stringBuffer.append(Short.toString(sArray[i]));
            if (i >= sArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        double[] dArray = new double[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            dArray[i] = this.value[i];
        }
        return dArray;
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        double[] dArray = new double[this.wvalue.length];
        for (int i = 0; i < this.wvalue.length; ++i) {
            dArray[i] = this.wvalue[i];
        }
        return dArray;
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        long[] lArray = new long[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            lArray[i] = this.value[i];
        }
        return lArray;
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        long[] lArray = new long[this.wvalue.length];
        for (int i = 0; i < this.wvalue.length; ++i) {
            lArray[i] = this.wvalue[i];
        }
        return lArray;
    }
}

