/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbDataSet {
    ArrayList<HdbData> data;
    String name = "";
    int type;
    long invalidValue = Long.MIN_VALUE;

    public HdbDataSet() {
        this.data = new ArrayList();
    }

    public HdbDataSet(ArrayList<HdbData> arrayList) {
        this.data = arrayList;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.data.size();
    }

    public void applyConversionFactor(double d) {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.get(i).applyConversionFactor(d);
        }
    }

    public HdbData get(int n) {
        return this.data.get(n);
    }

    public HdbData getLast() {
        int n = this.size();
        if (n > 0) {
            return this.data.get(n - 1);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.data.size() == 0;
    }

    public void removeHasFailed() {
        int n = 0;
        while (n < this.size()) {
            HdbData hdbData = this.get(n);
            if (hdbData.hasFailed()) {
                this.data.remove(n);
                continue;
            }
            ++n;
        }
    }

    public void removeFirst() {
        this.data.remove(0);
    }

    public HdbData getBefore(long l) {
        int n;
        int n2 = 0;
        int n3 = this.size() - 1;
        if (this.size() <= 0) {
            return null;
        }
        while (n2 <= n3) {
            n = n2 + n3 >>> 1;
            long l2 = this.data.get(n).getDataTime();
            if (l2 < l) {
                n2 = n + 1;
                continue;
            }
            if (l2 > l) {
                n3 = n - 1;
                continue;
            }
            return this.data.get(n);
        }
        n = -(n2 + 1);
        if (n < 0) {
            n = -(n + 1);
        }
        if (n == 0) {
            return this.get(0);
        }
        return this.get(n - 1);
    }

    public long[] getDataTimeArray() {
        long[] lArray = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            lArray[i] = this.get(i).getDataTime();
        }
        return lArray;
    }

    public double[] getValueAsDoubleArray() throws HdbFailed {
        if (HdbSigInfo.isArrayType(this.getType())) {
            throw new HdbFailed("Not a scalar type ");
        }
        if (!HdbSigInfo.isNumericType(this.getType())) {
            throw new HdbFailed("Not a numerical type ");
        }
        double[] dArray = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            dArray[i] = this.get(i).hasFailed() ? Double.NaN : this.get(i).getValueAsDouble();
        }
        return dArray;
    }

    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        if (HdbSigInfo.isArrayType(this.getType())) {
            throw new HdbFailed("Not a scalar type ");
        }
        if (!HdbSigInfo.isNumericType(this.getType())) {
            throw new HdbFailed("Not a numerical type ");
        }
        double[] dArray = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            dArray[i] = this.get(i).hasFailed() ? Double.NaN : this.get(i).getWriteValueAsDouble();
        }
        return dArray;
    }

    public void setInvalidValueForInteger(long l) {
        this.invalidValue = l;
    }

    public long[] getValueAsLongArray() throws HdbFailed {
        if (HdbSigInfo.isArrayType(this.getType())) {
            throw new HdbFailed("Not a scalar type ");
        }
        if (!HdbSigInfo.isIntegerType(this.getType())) {
            throw new HdbFailed("Not an integer type ");
        }
        long[] lArray = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            lArray[i] = this.get(i).hasFailed() ? this.invalidValue : this.get(i).getValueAsLong();
        }
        return lArray;
    }

    public long[] getWriteValueAsLongArray() throws HdbFailed {
        if (HdbSigInfo.isArrayType(this.getType())) {
            throw new HdbFailed("Not a scalar type ");
        }
        if (!HdbSigInfo.isIntegerType(this.getType())) {
            throw new HdbFailed("Not an integer type ");
        }
        long[] lArray = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            lArray[i] = this.get(i).hasFailed() ? this.invalidValue : this.get(i).getWriteValueAsLong();
        }
        return lArray;
    }
}

