/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbByteArray
extends HdbData {
    byte[] value = null;
    byte[] wvalue = null;

    public HdbByteArray(int n) {
        this.type = n;
    }

    public HdbByteArray(int n, byte[] byArray) {
        this.type = n;
        this.value = byArray;
    }

    public byte[] getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public byte[] getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseByteArray(arrayList);
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseByteArray(arrayList);
        }
    }

    private byte[] parseByteArray(ArrayList<Object> arrayList) throws HdbFailed {
        byte[] byArray = new byte[arrayList.size()];
        if (arrayList.size() == 0) {
            return byArray;
        }
        if (arrayList.get(0) instanceof String) {
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    byArray[i] = string == null ? (byte)0 : Byte.parseByte(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseByteArray: Invalid number syntax");
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Byte by = (Byte)arrayList.get(0);
                byArray[i] = by;
            }
        }
        return byArray;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 11) {
            return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + "," + Integer.toString(this.wvalue.length) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        for (int i = 0; i < this.dataSize(); ++i) {
            this.value[i] = (byte)((double)this.value[i] * d);
        }
    }

    @Override
    int dataSize() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            if (this.wvalue == null) {
                return 0;
            }
            return this.wvalue.length;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = (byte[])((HdbByteArray)hdbData).value.clone();
        if (((HdbByteArray)hdbData).wvalue != null) {
            this.wvalue = (byte[])((HdbByteArray)hdbData).wvalue.clone();
        }
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        return this.arrayValue(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            return this.arrayValue(this.wvalue);
        }
        return "";
    }

    private String arrayValue(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Byte[" + byArray.length + "]\n");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Byte.toString(byArray[i]));
            if (i >= byArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        double[] dArray = new double[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            dArray[i] = this.value[i];
        }
        return dArray;
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        double[] dArray = new double[this.wvalue.length];
        for (int i = 0; i < this.wvalue.length; ++i) {
            dArray[i] = this.wvalue[i];
        }
        return dArray;
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        long[] lArray = new long[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            lArray[i] = this.value[i];
        }
        return lArray;
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        long[] lArray = new long[this.wvalue.length];
        for (int i = 0; i < this.wvalue.length; ++i) {
            lArray[i] = this.wvalue[i];
        }
        return lArray;
    }
}

