/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.tango.jhdb.Hdb;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbProgressListener;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.HdbSigParam;
import org.tango.jhdb.data.HdbData;
import org.tango.jhdb.data.HdbDataSet;

public abstract class HdbReader {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_IGNORE_ERROR = 1;
    public static final int MODE_FILLED = 2;
    public static final int MODE_CORRELATED = 3;
    private long extraPointLookupPeriod = 3600L;
    private boolean extraPointEnabled = false;
    private ArrayList<HdbProgressListener> prgListeners = null;
    int totalRequest;
    int currentRequest;
    static final String DEFAULT_DB_NAME = "hdb";
    static final String DEFAULT_DB_USER = "hdbreader";
    static final String DEFAULT_DB_PASSWORD = "R3aderP4ss";

    public HdbDataSet getData(String string, String string2, String string3) throws HdbFailed {
        if (string == null) {
            throw new HdbFailed("attName input parameters is null");
        }
        HdbSigInfo hdbSigInfo = this.getSigInfo(string);
        return this.getData(hdbSigInfo, string2, string3);
    }

    public HdbDataSet getData(HdbSigInfo hdbSigInfo, String string, String string2) throws HdbFailed {
        this.totalRequest = 1;
        this.currentRequest = 1;
        return this.getDataPrivate(hdbSigInfo, string, string2);
    }

    abstract HdbDataSet getDataFromDB(HdbSigInfo var1, String var2, String var3) throws HdbFailed;

    public HdbDataSet[] getData(String[] stringArray, String string, String string2, int n) throws HdbFailed {
        if (stringArray == null) {
            throw new HdbFailed("getData(): attNames input parameters is null");
        }
        HdbSigInfo[] hdbSigInfoArray = new HdbSigInfo[stringArray.length];
        for (int i = 0; i < hdbSigInfoArray.length; ++i) {
            hdbSigInfoArray[i] = this.getSigInfo(stringArray[i]);
        }
        return this.getData(hdbSigInfoArray, string, string2, n);
    }

    public HdbDataSet[] getData(HdbSigInfo[] hdbSigInfoArray, String string, String string2, int n) throws HdbFailed {
        int n2;
        if (hdbSigInfoArray == null) {
            throw new HdbFailed("getData(): sigInfos input parameters is null");
        }
        this.totalRequest = hdbSigInfoArray.length;
        HdbDataSet[] hdbDataSetArray = new HdbDataSet[hdbSigInfoArray.length];
        for (n2 = 0; n2 < hdbDataSetArray.length; ++n2) {
            this.currentRequest = n2 + 1;
            hdbDataSetArray[n2] = this.getDataPrivate(hdbSigInfoArray[n2], string, string2);
        }
        if (n == 1 || n == 3 || n == 2) {
            for (n2 = 0; n2 < hdbDataSetArray.length; ++n2) {
                hdbDataSetArray[n2].removeHasFailed();
            }
        }
        if (n == 3 && hdbDataSetArray.length > 1) {
            this.correlate(hdbDataSetArray);
        }
        if (n == 2 && hdbDataSetArray.length > 1) {
            this.fill(hdbDataSetArray);
        }
        return hdbDataSetArray;
    }

    public abstract String[] getAttributeList() throws HdbFailed;

    public abstract String[] getHosts() throws HdbFailed;

    public abstract String[] getDomains(String var1) throws HdbFailed;

    public abstract String[] getFamilies(String var1, String var2) throws HdbFailed;

    public abstract String[] getMembers(String var1, String var2, String var3) throws HdbFailed;

    public abstract String[] getNames(String var1, String var2, String var3, String var4) throws HdbFailed;

    public abstract HdbSigInfo getSigInfo(String var1) throws HdbFailed;

    public abstract ArrayList<HdbSigParam> getParams(String var1, String var2, String var3) throws HdbFailed;

    public abstract HdbSigParam getLastParam(String var1) throws HdbFailed;

    public abstract HdbDataSet findErrors(String var1, String var2, String var3) throws HdbFailed;

    public void setExtraPointLookupPeriod(long l) {
        this.extraPointLookupPeriod = l;
    }

    public long getExtraPointLookupPeriod() {
        return this.extraPointLookupPeriod;
    }

    public void enableExtraPoint() {
        this.extraPointEnabled = true;
    }

    public void disableExtraPoint() {
        this.extraPointEnabled = true;
    }

    public boolean isExtraPointEnabled() {
        return this.extraPointEnabled;
    }

    public void checkDates(String string, String string2) throws HdbFailed {
        Date date;
        Date date2;
        if (string == null) {
            throw new HdbFailed("startDate input parameters is null");
        }
        if (string2 == null) {
            throw new HdbFailed("stopDate input parameters is null");
        }
        try {
            date2 = Hdb.hdbDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new HdbFailed("Wrong start date format : " + parseException.getMessage());
        }
        try {
            date = Hdb.hdbDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            throw new HdbFailed("Wrong stop date format : " + parseException.getMessage());
        }
        if (date.compareTo(date2) <= 0) {
            throw new HdbFailed("startDate must be before stopDate");
        }
    }

    public abstract String getInfo() throws HdbFailed;

    public boolean hasProgressListener() {
        return this.prgListeners != null && this.prgListeners.size() > 0;
    }

    public void addProgressListener(HdbProgressListener hdbProgressListener) {
        if (this.prgListeners == null) {
            this.prgListeners = new ArrayList();
        }
        if (!this.prgListeners.contains(hdbProgressListener)) {
            this.prgListeners.add(hdbProgressListener);
        }
    }

    public void removeProgressListener(HdbProgressListener hdbProgressListener) {
        if (this.prgListeners != null) {
            this.prgListeners.remove(hdbProgressListener);
        }
    }

    void fireProgressListener(double d) {
        if (this.prgListeners == null) {
            return;
        }
        for (HdbProgressListener hdbProgressListener : this.prgListeners) {
            hdbProgressListener.progress(this, d, this.currentRequest, this.totalRequest);
        }
    }

    private HdbDataSet getDataPrivate(HdbSigInfo hdbSigInfo, String string, String string2) throws HdbFailed {
        HdbDataSet hdbDataSet = this.getDataFromDB(hdbSigInfo, string, string2);
        if (hdbDataSet.size() == 0 && this.extraPointEnabled) {
            Date date;
            try {
                date = Hdb.hdbDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new HdbFailed("Wrong startDate format : " + parseException.getMessage());
            }
            date.setTime(date.getTime() - this.extraPointLookupPeriod * 1000L);
            String string3 = Hdb.hdbDateFormat.format(date);
            string2 = string;
            hdbDataSet = this.getDataFromDB(hdbSigInfo, string3, string2);
            if (hdbDataSet.size() > 0) {
                ArrayList<HdbData> arrayList = new ArrayList<HdbData>();
                arrayList.add(hdbDataSet.getLast());
                hdbDataSet = new HdbDataSet(arrayList);
            }
        }
        hdbDataSet.setName(hdbSigInfo.name);
        hdbDataSet.setType(hdbSigInfo.type);
        return hdbDataSet;
    }

    private boolean isBefore(HdbDataSet[] hdbDataSetArray, int n, long l) {
        boolean bl = true;
        for (int i = 0; i < hdbDataSetArray.length && bl; ++i) {
            if (i == n) continue;
            bl = bl && l < hdbDataSetArray[i].get(0).getDataTime();
        }
        return bl;
    }

    private void correlate(HdbDataSet[] hdbDataSetArray) throws HdbFailed {
        int n;
        int n2;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (n2 = 0; n2 < hdbDataSetArray.length; ++n2) {
            if (hdbDataSetArray[n2].size() >= n3) continue;
            n4 = n2;
            n3 = hdbDataSetArray[n2].size();
        }
        n2 = 0;
        while (n2 == 0 && hdbDataSetArray[n4].size() > 0) {
            long l = hdbDataSetArray[n4].get(0).getDataTime();
            if (this.isBefore(hdbDataSetArray, n4, l)) {
                hdbDataSetArray[n4].removeFirst();
                continue;
            }
            n2 = 1;
        }
        int n5 = hdbDataSetArray[n4].size();
        for (n = 0; n < hdbDataSetArray.length; ++n) {
            if (n == n4) continue;
            ArrayList<HdbData> arrayList = new ArrayList<HdbData>();
            for (int i = 0; i < n5; ++i) {
                long l = hdbDataSetArray[n4].get(i).getDataTime();
                HdbData hdbData = hdbDataSetArray[n].getBefore(l).copy();
                arrayList.add(hdbData);
            }
            HdbDataSet hdbDataSet = new HdbDataSet(arrayList);
            hdbDataSet.setType(hdbDataSetArray[n].getType());
            hdbDataSet.setName(hdbDataSetArray[n].getName());
            hdbDataSetArray[n] = hdbDataSet;
        }
        for (n = 0; n < hdbDataSetArray.length; ++n) {
            if (n == n4) continue;
            for (int i = 0; i < n5; ++i) {
                long l = hdbDataSetArray[n4].get(i).getDataTime();
                hdbDataSetArray[n].get(i).setDataTime(l);
            }
        }
    }

    private void insertTime(ArrayList<Long> arrayList, long l) {
        int n;
        int n2 = 0;
        int n3 = arrayList.size() - 1;
        while (n2 <= n3) {
            n = n2 + n3 >>> 1;
            long l2 = arrayList.get(n);
            if (l2 < l) {
                n2 = n + 1;
                continue;
            }
            if (l2 > l) {
                n3 = n - 1;
                continue;
            }
            return;
        }
        n = -(n2 + 1);
        if (n < 0) {
            n = -(n + 1);
        }
        arrayList.add(n, l);
    }

    private void fill(HdbDataSet[] hdbDataSetArray) throws HdbFailed {
        Object object;
        int n;
        for (int i = 0; i < hdbDataSetArray.length; ++i) {
            if (!hdbDataSetArray[i].isEmpty()) continue;
            throw new HdbFailed("FILLED mode cannot be done on empty HdbDataSet");
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (n = 0; n < hdbDataSetArray.length; ++n) {
            for (int i = 0; i < hdbDataSetArray[n].size(); ++i) {
                object = hdbDataSetArray[n].get(i);
                this.insertTime(arrayList, ((HdbData)object).getDataTime());
            }
        }
        for (n = 0; n < hdbDataSetArray.length; ++n) {
            ArrayList<HdbData> arrayList2 = new ArrayList<HdbData>();
            for (int i = 0; i < arrayList.size(); ++i) {
                HdbData hdbData = hdbDataSetArray[n].getBefore(arrayList.get(i)).copy();
                arrayList2.add(hdbData);
            }
            object = new HdbDataSet(arrayList2);
            ((HdbDataSet)object).setType(hdbDataSetArray[n].getType());
            ((HdbDataSet)object).setName(hdbDataSetArray[n].getName());
            hdbDataSetArray[n] = object;
        }
        for (n = 0; n < hdbDataSetArray.length; ++n) {
            for (int i = 0; i < arrayList.size(); ++i) {
                hdbDataSetArray[n].get(i).setDataTime(arrayList.get(i));
            }
        }
    }
}

