/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbReader;

class AttributeBrowser {
    private String name;
    private ArrayList<AttributeBrowser> children;

    public AttributeBrowser(String string) {
        this.name = string;
        this.children = null;
    }

    public String getName() {
        return this.name;
    }

    public AttributeBrowser get(int n) {
        return this.children.get(n);
    }

    public AttributeBrowser getBrowser(String string) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.size()) {
            bl = this.get(n).getName().equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            return this.get(n);
        }
        return null;
    }

    public int size() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    public void addChild(String string) {
        int n;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (string.startsWith("tango://")) {
            string = string.substring(8);
        }
        if ((n = string.indexOf("/")) == -1) {
            this.addToList(string);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            AttributeBrowser attributeBrowser = this.addToList(string2);
            attributeBrowser.addChild(string3);
        }
    }

    private AttributeBrowser addToList(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        while (!bl && n < this.children.size()) {
            n2 = this.children.get((int)n).name.compareToIgnoreCase(string);
            bl = n2 >= 0;
            if (bl) continue;
            ++n;
        }
        if (n2 == 0) {
            return this.children.get(n);
        }
        AttributeBrowser attributeBrowser = new AttributeBrowser(string);
        this.children.add(n, attributeBrowser);
        return attributeBrowser;
    }

    static AttributeBrowser constructBrowser(HdbReader hdbReader) throws HdbFailed {
        AttributeBrowser attributeBrowser = new AttributeBrowser("root");
        String[] stringArray = hdbReader.getAttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            attributeBrowser.addChild(stringArray[i]);
        }
        return attributeBrowser;
    }

    String[] getHosts() throws HdbFailed {
        String[] stringArray = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            stringArray[i] = this.get(i).getName();
        }
        return stringArray;
    }

    String[] getDomains(String string) throws HdbFailed {
        AttributeBrowser attributeBrowser = this.getBrowser(string);
        if (attributeBrowser == null) {
            throw new HdbFailed("host '" + string + "' not defined");
        }
        String[] stringArray = new String[attributeBrowser.size()];
        for (int i = 0; i < attributeBrowser.size(); ++i) {
            stringArray[i] = attributeBrowser.get(i).getName();
        }
        return stringArray;
    }

    public String[] getFamilies(String string, String string2) throws HdbFailed {
        AttributeBrowser attributeBrowser = this.getBrowser(string);
        if (attributeBrowser == null) {
            throw new HdbFailed("host '" + string + "' not defined");
        }
        AttributeBrowser attributeBrowser2 = attributeBrowser.getBrowser(string2);
        if (attributeBrowser2 == null) {
            throw new HdbFailed("domain '" + string2 + "' not defined in '" + string + "'");
        }
        String[] stringArray = new String[attributeBrowser2.size()];
        for (int i = 0; i < attributeBrowser2.size(); ++i) {
            stringArray[i] = attributeBrowser2.get(i).getName();
        }
        return stringArray;
    }

    public String[] getMembers(String string, String string2, String string3) throws HdbFailed {
        AttributeBrowser attributeBrowser = this.getBrowser(string);
        if (attributeBrowser == null) {
            throw new HdbFailed("host '" + string + "' not defined");
        }
        AttributeBrowser attributeBrowser2 = attributeBrowser.getBrowser(string2);
        if (attributeBrowser2 == null) {
            throw new HdbFailed("domain '" + string2 + "' not defined in '" + string + "'");
        }
        AttributeBrowser attributeBrowser3 = attributeBrowser2.getBrowser(string3);
        if (attributeBrowser3 == null) {
            throw new HdbFailed("family '" + string3 + "' not defined in '" + string + "/" + string2 + "'");
        }
        String[] stringArray = new String[attributeBrowser3.size()];
        for (int i = 0; i < attributeBrowser3.size(); ++i) {
            stringArray[i] = attributeBrowser3.get(i).getName();
        }
        return stringArray;
    }

    public String[] getNames(String string, String string2, String string3, String string4) throws HdbFailed {
        AttributeBrowser attributeBrowser = this.getBrowser(string);
        if (attributeBrowser == null) {
            throw new HdbFailed("host '" + string + "' not defined");
        }
        AttributeBrowser attributeBrowser2 = attributeBrowser.getBrowser(string2);
        if (attributeBrowser2 == null) {
            throw new HdbFailed("domain '" + string2 + "' not defined in '" + string + "'");
        }
        AttributeBrowser attributeBrowser3 = attributeBrowser2.getBrowser(string3);
        if (attributeBrowser3 == null) {
            throw new HdbFailed("family '" + string3 + "' not defined in '" + string + "/" + string2 + "'");
        }
        AttributeBrowser attributeBrowser4 = attributeBrowser3.getBrowser(string4);
        if (attributeBrowser4 == null) {
            throw new HdbFailed("member '" + string4 + "' not defined in '" + string + "/" + string2 + "/" + string3 + "'");
        }
        String[] stringArray = new String[attributeBrowser4.size()];
        for (int i = 0; i < attributeBrowser4.size(); ++i) {
            stringArray[i] = attributeBrowser4.get(i).getName();
        }
        return stringArray;
    }
}

