/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbStringArray
extends HdbData {
    String[] value = null;
    String[] wvalue = null;

    public HdbStringArray(int n) {
        this.type = n;
    }

    public HdbStringArray(int n, String[] stringArray) {
        this.type = n;
        this.value = stringArray;
    }

    public String[] getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public String[] getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseArray(arrayList);
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseArray(arrayList);
        }
    }

    private String[] parseArray(ArrayList<Object> arrayList) throws HdbFailed {
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            stringArray[i] = string == null ? "NULL" : string;
        }
        return stringArray;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 15) {
            return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + "," + Integer.toString(this.wvalue.length) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
    }

    @Override
    int dataSize() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            if (this.wvalue == null) {
                return 0;
            }
            return this.wvalue.length;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = (String[])((HdbStringArray)hdbData).value.clone();
        if (((HdbStringArray)hdbData).wvalue != null) {
            this.wvalue = (String[])((HdbStringArray)hdbData).wvalue.clone();
        }
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.isInvalid()) {
            return "ATTR_INVALID";
        }
        return this.arrayValue(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return "ATTR_INVALID";
            }
            return this.arrayValue(this.wvalue);
        }
        return "";
    }

    private String arrayValue(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("String[" + stringArray.length + "]\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }
}

