/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbString
extends HdbData {
    String value = null;
    String wvalue = null;

    public HdbString(int n) {
        this.type = n;
    }

    public HdbString(int n, String string) {
        this.type = n;
        this.value = string;
    }

    public String getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public String getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        String string = (String)arrayList.get(0);
        this.value = string == null ? "NULL" : string;
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            String string = (String)arrayList.get(0);
            this.wvalue = string == null ? "NULL" : string;
        }
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 13) {
            return this.timeToStr(this.dataTime) + ": " + this.value + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + this.value + ";" + this.wvalue + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = new String(((HdbString)hdbData).value);
        this.wvalue = new String(((HdbString)hdbData).wvalue);
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.isInvalid()) {
            return "ATTR_INVALID";
        }
        return this.value;
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return "ATTR_INVALID";
            }
            return this.wvalue;
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum cannot be converted to double");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }
}

