/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbLong64
extends HdbData {
    long value = 0L;
    long wvalue = 0L;

    public HdbLong64(int n) {
        this.type = n;
    }

    public HdbLong64(int n, long l) {
        this.type = n;
        this.value = l;
    }

    public long getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public long getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseLong64(arrayList.get(0));
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseLong64(arrayList.get(0));
        }
    }

    private long parseLong64(Object object) throws HdbFailed {
        long l;
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string == null) {
                    l = 0L;
                }
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseLong64: Invalid number syntax for value");
            }
        } else {
            Long l2 = (Long)object;
            l = l2;
        }
        return l;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 5) {
            return this.timeToStr(this.dataTime) + ": " + Long.toString(this.value) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + Long.toString(this.value) + ";" + Long.toString(this.wvalue) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        this.value = (long)((double)this.value * d);
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = ((HdbLong64)hdbData).value;
        this.wvalue = ((HdbLong64)hdbData).wvalue;
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.isInvalid()) {
            return "ATTR_INVALID";
        }
        return Long.toString(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return "ATTR_INVALID";
            }
            return Long.toString(this.wvalue);
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.isInvalid()) {
            return Double.NaN;
        }
        return this.value;
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return Double.NaN;
            }
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }
}

