/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbFloat
extends HdbData {
    float value = Float.NaN;
    float wvalue = Float.NaN;

    public HdbFloat(int n) {
        this.type = n;
    }

    public HdbFloat(int n, float f) {
        this.type = n;
        this.value = f;
    }

    public float getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public float getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseFloat(arrayList.get(0));
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseFloat(arrayList.get(0));
        }
    }

    private float parseFloat(Object object) throws HdbFailed {
        float f;
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string == null) {
                    f = Float.NaN;
                }
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseFloat: Invalid number syntax for write value");
            }
        } else {
            Float f2 = (Float)object;
            f = f2.floatValue();
        }
        return f;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 17) {
            return this.timeToStr(this.dataTime) + ": " + Double.toString(this.value) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": " + Double.toString(this.value) + ";" + Double.toString(this.wvalue) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        this.value = (float)((double)this.value * d);
    }

    @Override
    int dataSize() {
        return 1;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            return 1;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = ((HdbFloat)hdbData).value;
        this.wvalue = ((HdbFloat)hdbData).wvalue;
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.isInvalid()) {
            return "ATTR_INVALID";
        }
        return Float.toString(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return "ATTR_INVALID";
            }
            return Float.toString(this.wvalue);
        }
        return "";
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.isInvalid()) {
            return Double.NaN;
        }
        return this.value;
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return Double.NaN;
            }
            return this.wvalue;
        }
        throw new HdbFailed("This datum has no write value");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an array");
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }
}

