/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbDoubleArray
extends HdbData {
    double[] value = null;
    double[] wvalue = null;

    public HdbDoubleArray(int n) {
        this.type = n;
    }

    public HdbDoubleArray(int n, double[] dArray) {
        this.type = n;
        this.value = dArray;
    }

    public double[] getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public double[] getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseDoubleArray(arrayList);
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseDoubleArray(arrayList);
        }
    }

    private double[] parseDoubleArray(ArrayList<Object> arrayList) throws HdbFailed {
        double[] dArray = new double[arrayList.size()];
        if (arrayList.size() == 0) {
            return dArray;
        }
        try {
            Object object = arrayList.get(0);
            if (object == null || object instanceof String) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    dArray[i] = string == null ? Double.NaN : Double.parseDouble(string);
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Double d = (Double)arrayList.get(i);
                    dArray[i] = d == null ? Double.NaN : d;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new HdbFailed("parseDoubleArray: Invalid number syntax");
        }
        return dArray;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 3) {
            return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + "," + Integer.toString(this.wvalue.length) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
        for (int i = 0; i < this.dataSize(); ++i) {
            this.value[i] = this.value[i] * d;
        }
    }

    @Override
    int dataSize() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            if (this.wvalue == null) {
                return 0;
            }
            return this.wvalue.length;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = (double[])((HdbDoubleArray)hdbData).value.clone();
        if (((HdbDoubleArray)hdbData).wvalue != null) {
            this.wvalue = (double[])((HdbDoubleArray)hdbData).wvalue.clone();
        }
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.isInvalid()) {
            return "ATTR_INVALID";
        }
        return this.arrayValue(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return "ATTR_INVALID";
            }
            return this.arrayValue(this.wvalue);
        }
        return "";
    }

    private String arrayValue(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Double[" + dArray.length + "]\n");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(Double.toString(dArray[i]));
            if (i >= dArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        return this.wvalue;
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        throw new HdbFailed("This datum is not an integer");
    }
}

