/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbBoolean;
import org.tango.jhdb.data.HdbBooleanArray;
import org.tango.jhdb.data.HdbByte;
import org.tango.jhdb.data.HdbByteArray;
import org.tango.jhdb.data.HdbDouble;
import org.tango.jhdb.data.HdbDoubleArray;
import org.tango.jhdb.data.HdbFloat;
import org.tango.jhdb.data.HdbFloatArray;
import org.tango.jhdb.data.HdbLong;
import org.tango.jhdb.data.HdbLong64;
import org.tango.jhdb.data.HdbLong64Array;
import org.tango.jhdb.data.HdbLongArray;
import org.tango.jhdb.data.HdbShort;
import org.tango.jhdb.data.HdbShortArray;
import org.tango.jhdb.data.HdbState;
import org.tango.jhdb.data.HdbStateArray;
import org.tango.jhdb.data.HdbString;
import org.tango.jhdb.data.HdbStringArray;
import org.tango.jhdb.data.HdbUChar;
import org.tango.jhdb.data.HdbUCharArray;
import org.tango.jhdb.data.HdbULong;
import org.tango.jhdb.data.HdbULongArray;
import org.tango.jhdb.data.HdbUShort;
import org.tango.jhdb.data.HdbUShortArray;

public abstract class HdbData {
    static final SimpleDateFormat dfr = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    int type;
    long dataTime;
    long recvTime;
    long insertTime;
    int qualityFactor;
    String errorMessage = null;

    public long getDataTime() {
        return this.dataTime;
    }

    public void setDataTime(long l) {
        this.dataTime = l;
    }

    public long getRecvTime() {
        return this.recvTime;
    }

    public long getInsertTime() {
        return this.insertTime;
    }

    public int getQualityFactor() {
        return this.qualityFactor;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasFailed() {
        return this.errorMessage != null;
    }

    public int size() {
        if (this.hasFailed()) {
            return 0;
        }
        return this.dataSize();
    }

    public int sizeW() {
        if (this.hasFailed()) {
            return 0;
        }
        return this.dataSizeW();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasWriteValue() {
        return HdbSigInfo.isRWType(this.type);
    }

    public boolean isArray() {
        return HdbSigInfo.isArrayType(this.type);
    }

    public abstract double getValueAsDouble() throws HdbFailed;

    public abstract double[] getValueAsDoubleArray() throws HdbFailed;

    public abstract double getWriteValueAsDouble() throws HdbFailed;

    public abstract double[] getWriteValueAsDoubleArray() throws HdbFailed;

    public abstract long getValueAsLong() throws HdbFailed;

    public abstract long[] getValueAsLongArray() throws HdbFailed;

    public abstract long getWriteValueAsLong() throws HdbFailed;

    public abstract long[] getWriteValueAsLongArray() throws HdbFailed;

    public abstract void parseValue(ArrayList<Object> var1) throws HdbFailed;

    public abstract void parseWriteValue(ArrayList<Object> var1) throws HdbFailed;

    public abstract String getValueAsString();

    public abstract String getWriteValueAsString();

    public void parse(long l, long l2, long l3, String string, int n, ArrayList<Object> arrayList, ArrayList<Object> arrayList2) throws HdbFailed {
        this.dataTime = l;
        this.recvTime = l2;
        this.insertTime = l3;
        if (string != null && string.isEmpty()) {
            string = null;
        }
        this.errorMessage = string;
        this.qualityFactor = n;
        if (!this.hasFailed()) {
            this.parseValue(arrayList);
            this.parseWriteValue(arrayList2);
        }
    }

    public String timeToStr(long l) {
        long l2 = l / 1000L;
        Date date = new Date(l2);
        String string = dfr.format(date);
        String string2 = String.format("%06d", l % 1000000L);
        return string + "." + string2;
    }

    public boolean isInvalid() {
        return this.qualityFactor == 1;
    }

    public String qualitytoStr(int n) {
        switch (n) {
            case 0: {
                return "ATTR_VALID";
            }
            case 1: {
                return "ATTR_INVALID";
            }
            case 2: {
                return "ATTR_ALARM";
            }
            case 3: {
                return "ATTR_CHANGING";
            }
            case 4: {
                return "ATTR_WARNING";
            }
        }
        return "UNKNOWN QUALITY";
    }

    abstract int dataSize();

    abstract int dataSizeW();

    abstract void copyData(HdbData var1);

    public HdbData copy() throws HdbFailed {
        HdbData hdbData = HdbData.createData(this.type);
        hdbData.dataTime = this.dataTime;
        hdbData.recvTime = this.recvTime;
        hdbData.insertTime = this.insertTime;
        hdbData.qualityFactor = this.qualityFactor;
        hdbData.errorMessage = this.errorMessage;
        hdbData.copyData(this);
        return hdbData;
    }

    public abstract void applyConversionFactor(double var1);

    public static HdbData createData(int n) throws HdbFailed {
        switch (n) {
            case 45: 
            case 46: {
                return new HdbBoolean(n);
            }
            case 47: 
            case 48: {
                return new HdbBooleanArray(n);
            }
            case 9: 
            case 10: {
                return new HdbByte(n);
            }
            case 11: 
            case 12: {
                return new HdbByteArray(n);
            }
            case 21: 
            case 22: {
                return new HdbUChar(n);
            }
            case 23: 
            case 24: {
                return new HdbUCharArray(n);
            }
            case 25: 
            case 26: {
                return new HdbShort(n);
            }
            case 27: 
            case 28: {
                return new HdbShortArray(n);
            }
            case 29: 
            case 30: {
                return new HdbUShort(n);
            }
            case 31: 
            case 32: {
                return new HdbUShortArray(n);
            }
            case 33: 
            case 34: {
                return new HdbLong(n);
            }
            case 35: 
            case 36: {
                return new HdbLongArray(n);
            }
            case 37: 
            case 38: {
                return new HdbULong(n);
            }
            case 39: 
            case 40: {
                return new HdbULongArray(n);
            }
            case 5: 
            case 6: {
                return new HdbLong64(n);
            }
            case 7: 
            case 8: {
                return new HdbLong64Array(n);
            }
            case 1: 
            case 2: {
                return new HdbDouble(n);
            }
            case 3: 
            case 4: {
                return new HdbDoubleArray(n);
            }
            case 17: 
            case 18: {
                return new HdbFloat(n);
            }
            case 19: 
            case 20: {
                return new HdbFloatArray(n);
            }
            case 41: 
            case 42: {
                return new HdbState(n);
            }
            case 43: 
            case 44: {
                return new HdbStateArray(n);
            }
            case 13: 
            case 14: {
                return new HdbString(n);
            }
            case 15: 
            case 16: {
                return new HdbStringArray(n);
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                throw new HdbFailed("Type " + HdbSigInfo.typeStr[n] + " not supported yet !");
            }
        }
        throw new HdbFailed("Unknown signal type code=" + n);
    }
}

