/*
 * Decompiled with CFR 0.152.
 */
package org.tango.jhdb.data;

import java.util.ArrayList;
import org.tango.jhdb.HdbFailed;
import org.tango.jhdb.HdbSigInfo;
import org.tango.jhdb.data.HdbData;

public class HdbBooleanArray
extends HdbData {
    boolean[] value = null;
    boolean[] wvalue = null;

    public HdbBooleanArray(int n) {
        this.type = n;
    }

    public HdbBooleanArray(int n, boolean[] blArray) {
        this.type = n;
        this.value = blArray;
    }

    public boolean[] getValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.value;
    }

    public boolean[] getWriteValue() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        return this.wvalue;
    }

    @Override
    public void parseValue(ArrayList<Object> arrayList) throws HdbFailed {
        this.value = this.parseBooleanArray(arrayList);
    }

    @Override
    public void parseWriteValue(ArrayList<Object> arrayList) throws HdbFailed {
        if (arrayList != null) {
            this.wvalue = this.parseBooleanArray(arrayList);
        }
    }

    private boolean[] parseBooleanArray(ArrayList<Object> arrayList) throws HdbFailed {
        boolean[] blArray = new boolean[arrayList.size()];
        if (arrayList.size() == 0) {
            return blArray;
        }
        if (arrayList.get(0) instanceof String) {
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    blArray[i] = string == null ? false : Boolean.parseBoolean(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new HdbFailed("parseBoolean: Invalid number syntax");
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Boolean bl = (Boolean)arrayList.get(0);
                blArray[i] = bl;
            }
        }
        return blArray;
    }

    public String toString() {
        if (this.hasFailed()) {
            return this.timeToStr(this.dataTime) + ": " + this.errorMessage;
        }
        if (this.type == 47) {
            return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + " " + this.qualitytoStr(this.qualityFactor);
        }
        return this.timeToStr(this.dataTime) + ": dim=" + Integer.toString(this.value.length) + "," + Integer.toString(this.wvalue.length) + " " + this.qualitytoStr(this.qualityFactor);
    }

    @Override
    public void applyConversionFactor(double d) {
    }

    @Override
    int dataSize() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    @Override
    int dataSizeW() {
        if (HdbSigInfo.isRWType(this.type)) {
            if (this.wvalue == null) {
                return 0;
            }
            return this.wvalue.length;
        }
        return 0;
    }

    @Override
    void copyData(HdbData hdbData) {
        this.value = (boolean[])((HdbBooleanArray)hdbData).value.clone();
        if (((HdbBooleanArray)hdbData).wvalue != null) {
            this.wvalue = (boolean[])((HdbBooleanArray)hdbData).wvalue.clone();
        }
    }

    @Override
    public String getValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.isInvalid()) {
            return "ATTR_INVALID";
        }
        return this.arrayValue(this.value);
    }

    @Override
    public String getWriteValueAsString() {
        if (this.hasFailed()) {
            return this.errorMessage;
        }
        if (this.hasWriteValue()) {
            if (this.isInvalid()) {
                return "ATTR_INVALID";
            }
            return this.arrayValue(this.wvalue);
        }
        return "";
    }

    private String arrayValue(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Boolean[" + blArray.length + "]\n");
        for (int i = 0; i < blArray.length; ++i) {
            stringBuffer.append(Boolean.toString(blArray[i]));
            if (i >= blArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public double getValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double getWriteValueAsDouble() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public double[] getValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        double[] dArray = new double[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            dArray[i] = this.value[i] ? 1.0 : 0.0;
        }
        return dArray;
    }

    @Override
    public double[] getWriteValueAsDoubleArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        double[] dArray = new double[this.wvalue.length];
        for (int i = 0; i < this.wvalue.length; ++i) {
            dArray[i] = this.wvalue[i] ? 1.0 : 0.0;
        }
        return dArray;
    }

    @Override
    public long getValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public long getWriteValueAsLong() throws HdbFailed {
        throw new HdbFailed("This datum is not scalar");
    }

    @Override
    public long[] getValueAsLongArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        long[] lArray = new long[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            lArray[i] = this.value[i] ? 1L : 0L;
        }
        return lArray;
    }

    @Override
    public long[] getWriteValueAsLongArray() throws HdbFailed {
        if (this.hasFailed()) {
            throw new HdbFailed(this.errorMessage);
        }
        if (!this.hasWriteValue()) {
            throw new HdbFailed("This datum has no write value");
        }
        long[] lArray = new long[this.wvalue.length];
        for (int i = 0; i < this.wvalue.length; ++i) {
            lArray[i] = this.wvalue[i] ? 1L : 0L;
        }
        return lArray;
    }
}

